/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class Potion
implements FeatureElement {
    public static final Codec<Holder<Potion>> CODEC = BuiltInRegistries.POTION.holderByNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Potion>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.POTION);
    @Nullable
    private final String name;
    private final List<MobEffectInstance> effects;
    private FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;

    public Potion(MobEffectInstance ... $$0) {
        this((String)null, $$0);
    }

    public Potion(@Nullable String $$0, MobEffectInstance ... $$1) {
        this.name = $$0;
        this.effects = List.of($$1);
    }

    public Potion requiredFeatures(FeatureFlag ... $$0) {
        this.requiredFeatures = FeatureFlags.REGISTRY.subset($$0);
        return this;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    public static String getName(Optional<Holder<Potion>> $$02, String $$1) {
        String $$2;
        if ($$02.isPresent() && ($$2 = $$02.get().value().name) != null) {
            return $$1 + $$2;
        }
        String $$3 = $$02.flatMap(Holder::unwrapKey).map($$0 -> $$0.location().getPath()).orElse("empty");
        return $$1 + $$3;
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public boolean hasInstantEffects() {
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance $$0 : this.effects) {
                if (!$$0.getEffect().value().isInstantenous()) continue;
                return true;
            }
        }
        return false;
    }
}

