/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class Ingredient
implements Predicate<ItemStack> {
    public static final Ingredient EMPTY = new Ingredient(Stream.empty());
    public static final StreamCodec<RegistryFriendlyByteBuf, Ingredient> CONTENTS_STREAM_CODEC = ItemStack.LIST_STREAM_CODEC.map($$0 -> Ingredient.fromValues($$0.stream().map(ItemValue::new)), $$0 -> Arrays.asList($$0.getItems()));
    private final Value[] values;
    @Nullable
    private ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;
    public static final Codec<Ingredient> CODEC = Ingredient.codec(true);
    public static final Codec<Ingredient> CODEC_NONEMPTY = Ingredient.codec(false);

    private Ingredient(Stream<? extends Value> $$0) {
        this.values = (Value[])$$0.toArray(Value[]::new);
    }

    private Ingredient(Value[] $$0) {
        this.values = $$0;
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap($$0 -> $$0.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @Override
    public boolean test(@Nullable ItemStack $$0) {
        if ($$0 == null) {
            return false;
        }
        if (this.isEmpty()) {
            return $$0.isEmpty();
        }
        for (ItemStack $$1 : this.getItems()) {
            if (!$$1.is($$0.getItem())) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            ItemStack[] $$0 = this.getItems();
            this.stackingIds = new IntArrayList($$0.length);
            for (ItemStack $$1 : $$0) {
                this.stackingIds.add(StackedContents.getStackingIndex($$1));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public boolean equals(Object $$0) {
        if ($$0 instanceof Ingredient) {
            Ingredient $$1 = (Ingredient)$$0;
            return Arrays.equals(this.values, $$1.values);
        }
        return false;
    }

    private static Ingredient fromValues(Stream<? extends Value> $$0) {
        Ingredient $$1 = new Ingredient($$0);
        return $$1.isEmpty() ? EMPTY : $$1;
    }

    public static Ingredient of() {
        return EMPTY;
    }

    public static Ingredient of(ItemLike ... $$0) {
        return Ingredient.of(Arrays.stream($$0).map(ItemStack::new));
    }

    public static Ingredient of(ItemStack ... $$0) {
        return Ingredient.of(Arrays.stream($$0));
    }

    public static Ingredient of(Stream<ItemStack> $$02) {
        return Ingredient.fromValues($$02.filter($$0 -> !$$0.isEmpty()).map(ItemValue::new));
    }

    public static Ingredient of(TagKey<Item> $$0) {
        return Ingredient.fromValues(Stream.of(new TagValue($$0)));
    }

    private static Codec<Ingredient> codec(boolean $$0) {
        Codec $$12 = Codec.list(Value.CODEC).comapFlatMap($$1 -> {
            if (!$$0 && $$1.size() < 1) {
                return DataResult.error(() -> "Item array cannot be empty, at least one item must be defined");
            }
            return DataResult.success((Object)$$1.toArray(new Value[0]));
        }, List::of);
        return Codec.either((Codec)$$12, Value.CODEC).flatComapMap($$02 -> (Ingredient)$$02.map(Ingredient::new, $$0 -> new Ingredient(new Value[]{$$0})), $$1 -> {
            if ($$1.values.length == 1) {
                return DataResult.success((Object)Either.right((Object)$$1.values[0]));
            }
            if ($$1.values.length == 0 && !$$0) {
                return DataResult.error(() -> "Item array cannot be empty, at least one item must be defined");
            }
            return DataResult.success((Object)Either.left((Object)$$1.values));
        });
    }

    @Override
    public /* synthetic */ boolean test(@Nullable Object object) {
        return this.test((ItemStack)object);
    }

    static interface Value {
        public static final Codec<Value> CODEC = Codec.xor(ItemValue.CODEC, TagValue.CODEC).xmap($$02 -> (Value)$$02.map($$0 -> $$0, $$0 -> $$0), $$0 -> {
            if ($$0 instanceof TagValue) {
                TagValue $$1 = (TagValue)$$0;
                return Either.right((Object)$$1);
            }
            if ($$0 instanceof ItemValue) {
                ItemValue $$2 = (ItemValue)$$0;
                return Either.left((Object)$$2);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> getItems();
    }

    record TagValue(TagKey<Item> tag) implements Value
    {
        static final Codec<TagValue> CODEC = RecordCodecBuilder.create($$02 -> $$02.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter($$0 -> $$0.tag)).apply((Applicative)$$02, TagValue::new));

        @Override
        public boolean equals(Object $$0) {
            if ($$0 instanceof TagValue) {
                TagValue $$1 = (TagValue)$$0;
                return $$1.tag.location().equals(this.tag.location());
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList $$0 = Lists.newArrayList();
            for (Holder<Item> $$1 : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                $$0.add(new ItemStack($$1));
            }
            return $$0;
        }
    }

    record ItemValue(ItemStack item) implements Value
    {
        static final Codec<ItemValue> CODEC = RecordCodecBuilder.create($$02 -> $$02.group((App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("item").forGetter($$0 -> $$0.item)).apply((Applicative)$$02, ItemValue::new));

        @Override
        public boolean equals(Object $$0) {
            if ($$0 instanceof ItemValue) {
                ItemValue $$1 = (ItemValue)$$0;
                return $$1.item.getItem().equals(this.item.getItem()) && $$1.item.getCount() == this.item.getCount();
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }
    }
}

