/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class ExplosionDamageCalculator {
    public Optional<Float> getBlockExplosionResistance(Explosion $$0, BlockGetter $$1, BlockPos $$2, BlockState $$3, FluidState $$4) {
        if ($$3.isAir() && $$4.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(Math.max($$3.getBlock().getExplosionResistance(), $$4.getExplosionResistance())));
    }

    public boolean shouldBlockExplode(Explosion $$0, BlockGetter $$1, BlockPos $$2, BlockState $$3, float $$4) {
        return true;
    }

    public boolean shouldDamageEntity(Explosion $$0, Entity $$1) {
        return true;
    }

    public float getKnockbackMultiplier(Entity $$0) {
        return 1.0f;
    }

    public float getEntityDamageAmount(Explosion $$0, Entity $$1) {
        float $$2 = $$0.radius() * 2.0f;
        Vec3 $$3 = $$0.center();
        double $$4 = Math.sqrt($$1.distanceToSqr($$3)) / (double)$$2;
        double $$5 = (1.0 - $$4) * (double)Explosion.getSeenPercent($$3, $$1);
        return (float)(($$5 * $$5 + $$5) / 2.0 * 7.0 * (double)$$2 + 1.0);
    }
}

