/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class StateHolder<O, S> {
    public static final String NAME_TAG = "Name";
    public static final String PROPERTIES_TAG = "Properties";
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_ENTRY_TO_STRING_FUNCTION = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> $$0) {
            if ($$0 == null) {
                return "<NULL>";
            }
            Property<?> $$1 = $$0.getKey();
            return $$1.getName() + "=" + this.getName($$1, $$0.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> $$0, Comparable<?> $$1) {
            return $$0.getName($$1);
        }

        @Override
        public /* synthetic */ Object apply(@Nullable Object object) {
            return this.apply((Map.Entry)object);
        }
    };
    protected final O owner;
    private final Reference2ObjectArrayMap<Property<?>, Comparable<?>> values;
    private Table<Property<?>, Comparable<?>, S> neighbours;
    protected final MapCodec<S> propertiesCodec;

    protected StateHolder(O $$0, Reference2ObjectArrayMap<Property<?>, Comparable<?>> $$1, MapCodec<S> $$2) {
        this.owner = $$0;
        this.values = $$1;
        this.propertiesCodec = $$2;
    }

    public <T extends Comparable<T>> S cycle(Property<T> $$0) {
        return this.setValue($$0, (Comparable)StateHolder.findNextInCollection($$0.getPossibleValues(), this.getValue($$0)));
    }

    protected static <T> T findNextInCollection(Collection<T> $$0, T $$1) {
        Iterator<T> $$2 = $$0.iterator();
        while ($$2.hasNext()) {
            if (!$$2.next().equals($$1)) continue;
            if ($$2.hasNext()) {
                return $$2.next();
            }
            return $$0.iterator().next();
        }
        return $$2.next();
    }

    public String toString() {
        StringBuilder $$0 = new StringBuilder();
        $$0.append(this.owner);
        if (!this.getValues().isEmpty()) {
            $$0.append('[');
            $$0.append(this.getValues().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            $$0.append(']');
        }
        return $$0.toString();
    }

    public Collection<Property<?>> getProperties() {
        return Collections.unmodifiableCollection(this.values.keySet());
    }

    public <T extends Comparable<T>> boolean hasProperty(Property<T> $$0) {
        return this.values.containsKey($$0);
    }

    public <T extends Comparable<T>> T getValue(Property<T> $$0) {
        Comparable $$1 = (Comparable)this.values.get($$0);
        if ($$1 == null) {
            throw new IllegalArgumentException("Cannot get property " + String.valueOf($$0) + " as it does not exist in " + String.valueOf(this.owner));
        }
        return (T)((Comparable)$$0.getValueClass().cast($$1));
    }

    public <T extends Comparable<T>> Optional<T> getOptionalValue(Property<T> $$0) {
        Comparable $$1 = (Comparable)this.values.get($$0);
        if ($$1 == null) {
            return Optional.empty();
        }
        return Optional.of((Comparable)$$0.getValueClass().cast($$1));
    }

    public <T extends Comparable<T>, V extends T> S setValue(Property<T> $$0, V $$1) {
        Comparable $$2 = (Comparable)this.values.get($$0);
        if ($$2 == null) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf($$0) + " as it does not exist in " + String.valueOf(this.owner));
        }
        if ($$2.equals($$1)) {
            return (S)this;
        }
        Object $$3 = this.neighbours.get($$0, $$1);
        if ($$3 == null) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf($$0) + " to " + String.valueOf($$1) + " on " + String.valueOf(this.owner) + ", it is not an allowed value");
        }
        return (S)$$3;
    }

    public <T extends Comparable<T>, V extends T> S trySetValue(Property<T> $$0, V $$1) {
        Comparable $$2 = (Comparable)this.values.get($$0);
        if ($$2 == null || $$2.equals($$1)) {
            return (S)this;
        }
        Object $$3 = this.neighbours.get($$0, $$1);
        if ($$3 == null) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf($$0) + " to " + String.valueOf($$1) + " on " + String.valueOf(this.owner) + ", it is not an allowed value");
        }
        return (S)$$3;
    }

    public void populateNeighbours(Map<Map<Property<?>, Comparable<?>>, S> $$0) {
        if (this.neighbours != null) {
            throw new IllegalStateException();
        }
        HashBasedTable $$1 = HashBasedTable.create();
        for (Map.Entry $$2 : this.values.entrySet()) {
            Property $$3 = (Property)$$2.getKey();
            for (Comparable $$4 : $$3.getPossibleValues()) {
                if ($$4.equals($$2.getValue())) continue;
                $$1.put((Object)$$3, (Object)$$4, $$0.get(this.makeNeighbourValues($$3, $$4)));
            }
        }
        this.neighbours = $$1.isEmpty() ? $$1 : ArrayTable.create((Table)$$1);
    }

    private Map<Property<?>, Comparable<?>> makeNeighbourValues(Property<?> $$0, Comparable<?> $$1) {
        Reference2ObjectArrayMap $$2 = new Reference2ObjectArrayMap(this.values);
        $$2.put($$0, $$1);
        return $$2;
    }

    public Map<Property<?>, Comparable<?>> getValues() {
        return this.values;
    }

    protected static <O, S extends StateHolder<O, S>> Codec<S> codec(Codec<O> $$02, Function<O, S> $$1) {
        return $$02.dispatch(NAME_TAG, $$0 -> $$0.owner, $$12 -> {
            StateHolder $$2 = (StateHolder)$$1.apply($$12);
            if ($$2.getValues().isEmpty()) {
                return MapCodec.unit((Object)$$2);
            }
            return $$2.propertiesCodec.codec().lenientOptionalFieldOf(PROPERTIES_TAG).xmap($$1 -> $$1.orElse($$2), Optional::of);
        });
    }
}

