/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import org.slf4j.Logger;

public class ChunkSerializer {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    public static ProtoChunk read(ServerLevel $$02, PoiManager $$1, RegionStorageInfo $$22, ChunkPos $$3, CompoundTag $$4) {
        ProtoChunk $$39;
        BlendingData $$32;
        ChunkPos $$5 = new ChunkPos($$4.getInt(X_POS_TAG), $$4.getInt(Z_POS_TAG));
        if (!Objects.equals($$3, $$5)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{$$3, $$3, $$5});
            $$02.getServer().reportMisplacedChunk($$5, $$3, $$22);
        }
        UpgradeData $$6 = $$4.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData($$4.getCompound(TAG_UPGRADE_DATA), $$02) : UpgradeData.EMPTY;
        boolean $$7 = $$4.getBoolean(IS_LIGHT_ON_TAG);
        ListTag $$8 = $$4.getList(SECTIONS_TAG, 10);
        int $$9 = $$02.getSectionsCount();
        LevelChunkSection[] $$10 = new LevelChunkSection[$$9];
        boolean $$11 = $$02.dimensionType().hasSkyLight();
        ServerChunkCache $$12 = $$02.getChunkSource();
        LevelLightEngine $$13 = ((ChunkSource)$$12).getLightEngine();
        Registry<Biome> $$14 = $$02.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> $$15 = ChunkSerializer.makeBiomeCodec($$14);
        boolean $$16 = false;
        for (int $$17 = 0; $$17 < $$8.size(); ++$$17) {
            boolean $$28;
            CompoundTag $$18 = $$8.getCompound($$17);
            byte $$19 = $$18.getByte("Y");
            int $$20 = $$02.getSectionIndexFromSectionY($$19);
            if ($$20 >= 0 && $$20 < $$10.length) {
                LevelChunkSection $$25;
                PalettedContainer<Holder<Biome>> $$24;
                PalettedContainer<BlockState> $$222;
                if ($$18.contains("block_states", 10)) {
                    PalettedContainer $$21 = (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$18.getCompound("block_states")).promotePartial($$2 -> ChunkSerializer.logErrors($$3, $$19, $$2)).getOrThrow(ChunkReadException::new);
                } else {
                    $$222 = new PalettedContainer<BlockState>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                }
                if ($$18.contains("biomes", 10)) {
                    PalettedContainerRO $$23 = (PalettedContainerRO)$$15.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$18.getCompound("biomes")).promotePartial($$2 -> ChunkSerializer.logErrors($$3, $$19, $$2)).getOrThrow(ChunkReadException::new);
                } else {
                    $$24 = new PalettedContainer<Holder<Biome>>($$14.asHolderIdMap(), $$14.getHolderOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                }
                $$10[$$20] = $$25 = new LevelChunkSection($$222, $$24);
                SectionPos $$26 = SectionPos.of($$3, $$19);
                $$1.checkConsistencyWithBlocks($$26, $$25);
            }
            boolean $$27 = $$18.contains(BLOCK_LIGHT_TAG, 7);
            boolean bl = $$28 = $$11 && $$18.contains(SKY_LIGHT_TAG, 7);
            if (!$$27 && !$$28) continue;
            if (!$$16) {
                $$13.retainData($$3, true);
                $$16 = true;
            }
            if ($$27) {
                $$13.queueSectionData(LightLayer.BLOCK, SectionPos.of($$3, $$19), new DataLayer($$18.getByteArray(BLOCK_LIGHT_TAG)));
            }
            if (!$$28) continue;
            $$13.queueSectionData(LightLayer.SKY, SectionPos.of($$3, $$19), new DataLayer($$18.getByteArray(SKY_LIGHT_TAG)));
        }
        long $$29 = $$4.getLong("InhabitedTime");
        ChunkType $$30 = ChunkSerializer.getChunkTypeFromTag($$4);
        if ($$4.contains("blending_data", 10)) {
            BlendingData $$31 = BlendingData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)$$4.getCompound("blending_data"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
        } else {
            $$32 = null;
        }
        if ($$30 == ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> $$33 = LevelChunkTicks.load($$4.getList(BLOCK_TICKS_TAG, 10), $$0 -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse($$0)), $$3);
            LevelChunkTicks<Fluid> $$34 = LevelChunkTicks.load($$4.getList(FLUID_TICKS_TAG, 10), $$0 -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse($$0)), $$3);
            LevelChunk $$35 = new LevelChunk($$02.getLevel(), $$3, $$6, $$33, $$34, $$29, $$10, ChunkSerializer.postLoadChunk($$02, $$4), $$32);
        } else {
            ProtoChunkTicks<Block> $$36 = ProtoChunkTicks.load($$4.getList(BLOCK_TICKS_TAG, 10), $$0 -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse($$0)), $$3);
            ProtoChunkTicks<Fluid> $$37 = ProtoChunkTicks.load($$4.getList(FLUID_TICKS_TAG, 10), $$0 -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse($$0)), $$3);
            ProtoChunk $$38 = new ProtoChunk($$3, $$6, $$10, $$36, $$37, $$02, $$14, $$32);
            $$39 = $$38;
            $$39.setInhabitedTime($$29);
            if ($$4.contains("below_zero_retrogen", 10)) {
                BelowZeroRetrogen.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)$$4.getCompound("below_zero_retrogen"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$38::setBelowZeroRetrogen);
            }
            ChunkStatus $$40 = ChunkStatus.byName($$4.getString("Status"));
            $$38.setPersistedStatus($$40);
            if ($$40.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                $$38.setLightEngine($$13);
            }
        }
        $$39.setLightCorrect($$7);
        CompoundTag $$41 = $$4.getCompound(HEIGHTMAPS_TAG);
        EnumSet<Heightmap.Types> $$42 = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types $$43 : ((ChunkAccess)$$39).getPersistedStatus().heightmapsAfter()) {
            String $$44 = $$43.getSerializationKey();
            if ($$41.contains($$44, 12)) {
                $$39.setHeightmap($$43, $$41.getLongArray($$44));
                continue;
            }
            $$42.add($$43);
        }
        Heightmap.primeHeightmaps($$39, $$42);
        CompoundTag $$45 = $$4.getCompound("structures");
        $$39.setAllStarts(ChunkSerializer.unpackStructureStart(StructurePieceSerializationContext.fromLevel($$02), $$45, $$02.getSeed()));
        $$39.setAllReferences(ChunkSerializer.unpackStructureReferences($$02.registryAccess(), $$3, $$45));
        if ($$4.getBoolean("shouldSave")) {
            $$39.setUnsaved(true);
        }
        ListTag $$46 = $$4.getList("PostProcessing", 9);
        for (int $$47 = 0; $$47 < $$46.size(); ++$$47) {
            ListTag $$48 = $$46.getList($$47);
            for (int $$49 = 0; $$49 < $$48.size(); ++$$49) {
                ((ChunkAccess)$$39).addPackedPostProcess($$48.getShort($$49), $$47);
            }
        }
        if ($$30 == ChunkType.LEVELCHUNK) {
            return new ImposterProtoChunk((LevelChunk)((Object)$$39), false);
        }
        ProtoChunk $$50 = $$39;
        ListTag $$51 = $$4.getList("entities", 10);
        for (int $$52 = 0; $$52 < $$51.size(); ++$$52) {
            $$50.addEntity($$51.getCompound($$52));
        }
        ListTag $$53 = $$4.getList("block_entities", 10);
        for (int $$54 = 0; $$54 < $$53.size(); ++$$54) {
            CompoundTag $$55 = $$53.getCompound($$54);
            $$39.setBlockEntityNbt($$55);
        }
        CompoundTag $$56 = $$4.getCompound("CarvingMasks");
        for (String $$57 : $$56.getAllKeys()) {
            GenerationStep.Carving $$58 = GenerationStep.Carving.valueOf($$57);
            $$50.setCarvingMask($$58, new CarvingMask($$56.getLongArray($$57), $$39.getMinBuildHeight()));
        }
        return $$50;
    }

    private static void logErrors(ChunkPos $$0, int $$1, String $$2) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{$$0.x, $$1, $$0.z, $$2});
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> $$0) {
        return PalettedContainer.codecRO($$0.asHolderIdMap(), $$0.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, $$0.getHolderOrThrow(Biomes.PLAINS));
    }

    public static CompoundTag write(ServerLevel $$0, ChunkAccess $$12) {
        UpgradeData $$6;
        BelowZeroRetrogen $$5;
        ChunkPos $$2 = $$12.getPos();
        CompoundTag $$3 = NbtUtils.addCurrentDataVersion(new CompoundTag());
        $$3.putInt(X_POS_TAG, $$2.x);
        $$3.putInt("yPos", $$12.getMinSection());
        $$3.putInt(Z_POS_TAG, $$2.z);
        $$3.putLong("LastUpdate", $$0.getGameTime());
        $$3.putLong("InhabitedTime", $$12.getInhabitedTime());
        $$3.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey($$12.getPersistedStatus()).toString());
        BlendingData $$4 = $$12.getBlendingData();
        if ($$4 != null) {
            BlendingData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)$$4).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$1 -> $$3.put("blending_data", (Tag)$$1));
        }
        if (($$5 = $$12.getBelowZeroRetrogen()) != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)$$5).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$1 -> $$3.put("below_zero_retrogen", (Tag)$$1));
        }
        if (!($$6 = $$12.getUpgradeData()).isEmpty()) {
            $$3.put(TAG_UPGRADE_DATA, $$6.write());
        }
        LevelChunkSection[] $$7 = $$12.getSections();
        ListTag $$8 = new ListTag();
        ThreadedLevelLightEngine $$9 = $$0.getChunkSource().getLightEngine();
        Registry<Biome> $$10 = $$0.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> $$11 = ChunkSerializer.makeBiomeCodec($$10);
        boolean $$122 = $$12.isLightCorrect();
        for (int $$13 = $$9.getMinLightSection(); $$13 < $$9.getMaxLightSection(); ++$$13) {
            int $$14 = $$12.getSectionIndexFromSectionY($$13);
            boolean $$15 = $$14 >= 0 && $$14 < $$7.length;
            DataLayer $$16 = $$9.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of($$2, $$13));
            DataLayer $$17 = $$9.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of($$2, $$13));
            if (!$$15 && $$16 == null && $$17 == null) continue;
            CompoundTag $$18 = new CompoundTag();
            if ($$15) {
                LevelChunkSection $$19 = $$7[$$14];
                $$18.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, $$19.getStates()).getOrThrow());
                $$18.put("biomes", (Tag)$$11.encodeStart((DynamicOps)NbtOps.INSTANCE, $$19.getBiomes()).getOrThrow());
            }
            if ($$16 != null && !$$16.isEmpty()) {
                $$18.putByteArray(BLOCK_LIGHT_TAG, $$16.getData());
            }
            if ($$17 != null && !$$17.isEmpty()) {
                $$18.putByteArray(SKY_LIGHT_TAG, $$17.getData());
            }
            if ($$18.isEmpty()) continue;
            $$18.putByte("Y", (byte)$$13);
            $$8.add($$18);
        }
        $$3.put(SECTIONS_TAG, $$8);
        if ($$122) {
            $$3.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag $$20 = new ListTag();
        for (BlockPos $$21 : $$12.getBlockEntitiesPos()) {
            CompoundTag $$22 = $$12.getBlockEntityNbtForSaving($$21, $$0.registryAccess());
            if ($$22 == null) continue;
            $$20.add($$22);
        }
        $$3.put("block_entities", $$20);
        if ($$12.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk $$23 = (ProtoChunk)$$12;
            ListTag $$24 = new ListTag();
            $$24.addAll($$23.getEntities());
            $$3.put("entities", $$24);
            CompoundTag $$25 = new CompoundTag();
            for (GenerationStep.Carving $$26 : GenerationStep.Carving.values()) {
                CarvingMask $$27 = $$23.getCarvingMask($$26);
                if ($$27 == null) continue;
                $$25.putLongArray($$26.toString(), $$27.toArray());
            }
            $$3.put("CarvingMasks", $$25);
        }
        ChunkSerializer.saveTicks($$0, $$3, $$12.getTicksForSerialization());
        $$3.put("PostProcessing", ChunkSerializer.packOffsets($$12.getPostProcessing()));
        CompoundTag $$28 = new CompoundTag();
        for (Map.Entry<Heightmap.Types, Heightmap> $$29 : $$12.getHeightmaps()) {
            if (!$$12.getPersistedStatus().heightmapsAfter().contains($$29.getKey())) continue;
            $$28.put($$29.getKey().getSerializationKey(), new LongArrayTag($$29.getValue().getRawData()));
        }
        $$3.put(HEIGHTMAPS_TAG, $$28);
        $$3.put("structures", ChunkSerializer.packStructureData(StructurePieceSerializationContext.fromLevel($$0), $$2, $$12.getAllStarts(), $$12.getAllReferences()));
        return $$3;
    }

    private static void saveTicks(ServerLevel $$02, CompoundTag $$1, ChunkAccess.TicksToSave $$2) {
        long $$3 = $$02.getLevelData().getGameTime();
        $$1.put(BLOCK_TICKS_TAG, $$2.blocks().save($$3, $$0 -> BuiltInRegistries.BLOCK.getKey((Block)$$0).toString()));
        $$1.put(FLUID_TICKS_TAG, $$2.fluids().save($$3, $$0 -> BuiltInRegistries.FLUID.getKey((Fluid)$$0).toString()));
    }

    public static ChunkType getChunkTypeFromTag(@Nullable CompoundTag $$0) {
        if ($$0 != null) {
            return ChunkStatus.byName($$0.getString("Status")).getChunkType();
        }
        return ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel $$0, CompoundTag $$1) {
        ListTag $$2 = ChunkSerializer.getListOfCompoundsOrNull($$1, "entities");
        ListTag $$32 = ChunkSerializer.getListOfCompoundsOrNull($$1, "block_entities");
        if ($$2 == null && $$32 == null) {
            return null;
        }
        return $$3 -> {
            if ($$2 != null) {
                $$0.addLegacyChunkEntities(EntityType.loadEntitiesRecursive($$2, $$0));
            }
            if ($$32 != null) {
                for (int $$4 = 0; $$4 < $$32.size(); ++$$4) {
                    CompoundTag $$5 = $$32.getCompound($$4);
                    boolean $$6 = $$5.getBoolean("keepPacked");
                    if ($$6) {
                        $$3.setBlockEntityNbt($$5);
                        continue;
                    }
                    BlockPos $$7 = BlockEntity.getPosFromTag($$5);
                    BlockEntity $$8 = BlockEntity.loadStatic($$7, $$3.getBlockState($$7), $$5, $$0.registryAccess());
                    if ($$8 == null) continue;
                    $$3.setBlockEntity($$8);
                }
            }
        };
    }

    @Nullable
    private static ListTag getListOfCompoundsOrNull(CompoundTag $$0, String $$1) {
        ListTag $$2 = $$0.getList($$1, 10);
        return $$2.isEmpty() ? null : $$2;
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext $$0, ChunkPos $$1, Map<Structure, StructureStart> $$2, Map<Structure, LongSet> $$3) {
        CompoundTag $$4 = new CompoundTag();
        CompoundTag $$5 = new CompoundTag();
        Registry<Structure> $$6 = $$0.registryAccess().registryOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> $$7 : $$2.entrySet()) {
            ResourceLocation $$8 = $$6.getKey($$7.getKey());
            $$5.put($$8.toString(), $$7.getValue().createTag($$0, $$1));
        }
        $$4.put("starts", $$5);
        CompoundTag $$9 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> $$10 : $$3.entrySet()) {
            if ($$10.getValue().isEmpty()) continue;
            ResourceLocation $$11 = $$6.getKey($$10.getKey());
            $$9.put($$11.toString(), new LongArrayTag($$10.getValue()));
        }
        $$4.put("References", $$9);
        return $$4;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext $$0, CompoundTag $$1, long $$2) {
        HashMap $$3 = Maps.newHashMap();
        Registry<Structure> $$4 = $$0.registryAccess().registryOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = $$1.getCompound("starts");
        for (String $$6 : $$5.getAllKeys()) {
            ResourceLocation $$7 = ResourceLocation.tryParse($$6);
            Structure $$8 = $$4.get($$7);
            if ($$8 == null) {
                LOGGER.error("Unknown structure start: {}", (Object)$$7);
                continue;
            }
            StructureStart $$9 = StructureStart.loadStaticStart($$0, $$5.getCompound($$6), $$2);
            if ($$9 == null) continue;
            $$3.put($$8, $$9);
        }
        return $$3;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess $$0, ChunkPos $$1, CompoundTag $$22) {
        HashMap $$3 = Maps.newHashMap();
        Registry<Structure> $$4 = $$0.registryOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = $$22.getCompound("References");
        for (String $$6 : $$5.getAllKeys()) {
            ResourceLocation $$7 = ResourceLocation.tryParse($$6);
            Structure $$8 = $$4.get($$7);
            if ($$8 == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)$$7, (Object)$$1);
                continue;
            }
            long[] $$9 = $$5.getLongArray($$6);
            if ($$9.length == 0) continue;
            $$3.put($$8, new LongOpenHashSet(Arrays.stream($$9).filter($$2 -> {
                ChunkPos $$3 = new ChunkPos($$2);
                if ($$3.getChessboardDistance($$1) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{$$7, $$3, $$1});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return $$3;
    }

    public static ListTag packOffsets(ShortList[] $$0) {
        ListTag $$1 = new ListTag();
        for (ShortList $$2 : $$0) {
            ListTag $$3 = new ListTag();
            if ($$2 != null) {
                for (Short $$4 : $$2) {
                    $$3.add(ShortTag.valueOf($$4));
                }
            }
            $$1.add($$3);
        }
        return $$1;
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String $$0) {
            super($$0);
        }
    }
}

