/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import org.slf4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ENTITIES_TAG = "Entities";
    private static final String POSITION_TAG = "Position";
    private final ServerLevel level;
    private final SimpleRegionStorage simpleRegionStorage;
    private final LongSet emptyChunks = new LongOpenHashSet();
    private final ProcessorMailbox<Runnable> entityDeserializerQueue;

    public EntityStorage(SimpleRegionStorage $$0, ServerLevel $$1, Executor $$2) {
        this.simpleRegionStorage = $$0;
        this.level = $$1;
        this.entityDeserializerQueue = ProcessorMailbox.create($$2, "entity-deserializer");
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> loadEntities(ChunkPos $$0) {
        if (this.emptyChunks.contains($$0.toLong())) {
            return CompletableFuture.completedFuture(EntityStorage.emptyChunk($$0));
        }
        CompletableFuture<Optional<CompoundTag>> $$12 = this.simpleRegionStorage.read($$0);
        this.reportLoadFailureIfPresent($$12, $$0);
        return $$12.thenApplyAsync($$1 -> {
            if ($$1.isEmpty()) {
                this.emptyChunks.add($$0.toLong());
                return EntityStorage.emptyChunk($$0);
            }
            try {
                ChunkPos $$2 = EntityStorage.readChunkPos((CompoundTag)$$1.get());
                if (!Objects.equals($$0, $$2)) {
                    LOGGER.error("Chunk file at {} is in the wrong location. (Expected {}, got {})", new Object[]{$$0, $$0, $$2});
                    this.level.getServer().reportMisplacedChunk($$2, $$0, this.simpleRegionStorage.storageInfo());
                }
            }
            catch (Exception $$3) {
                LOGGER.warn("Failed to parse chunk {} position info", (Object)$$0, (Object)$$3);
                this.level.getServer().reportChunkLoadFailure($$3, this.simpleRegionStorage.storageInfo(), $$0);
            }
            CompoundTag $$4 = this.simpleRegionStorage.upgradeChunkTag((CompoundTag)$$1.get(), -1);
            ListTag $$5 = $$4.getList(ENTITIES_TAG, 10);
            List $$6 = (List)EntityType.loadEntitiesRecursive($$5, this.level).collect(ImmutableList.toImmutableList());
            return new ChunkEntities($$0, $$6);
        }, this.entityDeserializerQueue::tell);
    }

    private static ChunkPos readChunkPos(CompoundTag $$0) {
        int[] $$1 = $$0.getIntArray(POSITION_TAG);
        return new ChunkPos($$1[0], $$1[1]);
    }

    private static void writeChunkPos(CompoundTag $$0, ChunkPos $$1) {
        $$0.put(POSITION_TAG, new IntArrayTag(new int[]{$$1.x, $$1.z}));
    }

    private static ChunkEntities<Entity> emptyChunk(ChunkPos $$0) {
        return new ChunkEntities<Entity>($$0, (List<Entity>)ImmutableList.of());
    }

    @Override
    public void storeEntities(ChunkEntities<Entity> $$0) {
        ChunkPos $$12 = $$0.getPos();
        if ($$0.isEmpty()) {
            if (this.emptyChunks.add($$12.toLong())) {
                this.reportSaveFailureIfPresent(this.simpleRegionStorage.write($$12, null), $$12);
            }
            return;
        }
        ListTag $$2 = new ListTag();
        $$0.getEntities().forEach($$1 -> {
            CompoundTag $$2 = new CompoundTag();
            if ($$1.save($$2)) {
                $$2.add($$2);
            }
        });
        CompoundTag $$3 = NbtUtils.addCurrentDataVersion(new CompoundTag());
        $$3.put(ENTITIES_TAG, $$2);
        EntityStorage.writeChunkPos($$3, $$12);
        this.reportSaveFailureIfPresent(this.simpleRegionStorage.write($$12, $$3), $$12);
        this.emptyChunks.remove($$12.toLong());
    }

    private void reportSaveFailureIfPresent(CompletableFuture<?> $$0, ChunkPos $$12) {
        $$0.exceptionally($$1 -> {
            LOGGER.error("Failed to store entity chunk {}", (Object)$$12, $$1);
            this.level.getServer().reportChunkSaveFailure((Throwable)$$1, this.simpleRegionStorage.storageInfo(), $$12);
            return null;
        });
    }

    private void reportLoadFailureIfPresent(CompletableFuture<?> $$0, ChunkPos $$12) {
        $$0.exceptionally($$1 -> {
            LOGGER.error("Failed to load entity chunk {}", (Object)$$12, $$1);
            this.level.getServer().reportChunkLoadFailure((Throwable)$$1, this.simpleRegionStorage.storageInfo(), $$12);
            return null;
        });
    }

    @Override
    public void flush(boolean $$0) {
        this.simpleRegionStorage.synchronize($$0).join();
        this.entityDeserializerQueue.runAll();
    }

    @Override
    public void close() throws IOException {
        this.simpleRegionStorage.close();
    }
}

