/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;

public class SectionStorage<R>
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String SECTIONS_TAG = "Sections";
    private final SimpleRegionStorage simpleRegionStorage;
    private final Long2ObjectMap<Optional<R>> storage = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet dirty = new LongLinkedOpenHashSet();
    private final Function<Runnable, Codec<R>> codec;
    private final Function<Runnable, R> factory;
    private final RegistryAccess registryAccess;
    private final ChunkIOErrorReporter errorReporter;
    protected final LevelHeightAccessor levelHeightAccessor;

    public SectionStorage(SimpleRegionStorage $$0, Function<Runnable, Codec<R>> $$1, Function<Runnable, R> $$2, RegistryAccess $$3, ChunkIOErrorReporter $$4, LevelHeightAccessor $$5) {
        this.simpleRegionStorage = $$0;
        this.codec = $$1;
        this.factory = $$2;
        this.registryAccess = $$3;
        this.errorReporter = $$4;
        this.levelHeightAccessor = $$5;
    }

    protected void tick(BooleanSupplier $$0) {
        while (this.hasWork() && $$0.getAsBoolean()) {
            ChunkPos $$1 = SectionPos.of(this.dirty.firstLong()).chunk();
            this.writeColumn($$1);
        }
    }

    public boolean hasWork() {
        return !this.dirty.isEmpty();
    }

    @Nullable
    protected Optional<R> get(long $$0) {
        return (Optional)this.storage.get($$0);
    }

    protected Optional<R> getOrLoad(long $$0) {
        if (this.outsideStoredRange($$0)) {
            return Optional.empty();
        }
        Optional<R> $$1 = this.get($$0);
        if ($$1 != null) {
            return $$1;
        }
        this.readColumn(SectionPos.of($$0).chunk());
        $$1 = this.get($$0);
        if ($$1 == null) {
            throw Util.pauseInIde(new IllegalStateException());
        }
        return $$1;
    }

    protected boolean outsideStoredRange(long $$0) {
        int $$1 = SectionPos.sectionToBlockCoord(SectionPos.y($$0));
        return this.levelHeightAccessor.isOutsideBuildHeight($$1);
    }

    protected R getOrCreate(long $$0) {
        if (this.outsideStoredRange($$0)) {
            throw Util.pauseInIde(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> $$1 = this.getOrLoad($$0);
        if ($$1.isPresent()) {
            return $$1.get();
        }
        R $$2 = this.factory.apply(() -> this.setDirty($$0));
        this.storage.put($$0, Optional.of($$2));
        return $$2;
    }

    private void readColumn(ChunkPos $$0) {
        Optional<CompoundTag> $$1 = this.tryRead($$0).join();
        RegistryOps<Tag> $$2 = this.registryAccess.createSerializationContext(NbtOps.INSTANCE);
        this.readColumn($$0, $$2, $$1.orElse(null));
    }

    private CompletableFuture<Optional<CompoundTag>> tryRead(ChunkPos $$0) {
        return this.simpleRegionStorage.read($$0).exceptionally($$1 -> {
            if ($$1 instanceof IOException) {
                IOException $$2 = (IOException)$$1;
                LOGGER.error("Error reading chunk {} data from disk", (Object)$$0, (Object)$$2);
                this.errorReporter.reportChunkLoadFailure($$2, this.simpleRegionStorage.storageInfo(), $$0);
                return Optional.empty();
            }
            throw new CompletionException((Throwable)$$1);
        });
    }

    private void readColumn(ChunkPos $$0, RegistryOps<Tag> $$12, @Nullable CompoundTag $$22) {
        if ($$22 == null) {
            for (int $$3 = this.levelHeightAccessor.getMinSection(); $$3 < this.levelHeightAccessor.getMaxSection(); ++$$3) {
                this.storage.put(SectionStorage.getKey($$0, $$3), Optional.empty());
            }
        } else {
            int $$6;
            Dynamic $$4 = new Dynamic($$12, (Object)$$22);
            int $$5 = SectionStorage.getVersion($$4);
            boolean $$7 = $$5 != ($$6 = SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            Dynamic<Tag> $$8 = this.simpleRegionStorage.upgradeChunkTag((Dynamic<Tag>)$$4, $$5);
            OptionalDynamic $$9 = $$8.get(SECTIONS_TAG);
            for (int $$10 = this.levelHeightAccessor.getMinSection(); $$10 < this.levelHeightAccessor.getMaxSection(); ++$$10) {
                long $$11 = SectionStorage.getKey($$0, $$10);
                Optional $$122 = $$9.get(Integer.toString($$10)).result().flatMap($$1 -> this.codec.apply(() -> this.setDirty($$11)).parse($$1).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)));
                this.storage.put($$11, $$122);
                $$122.ifPresent($$2 -> {
                    this.onSectionLoad($$11);
                    if ($$7) {
                        this.setDirty($$11);
                    }
                });
            }
        }
    }

    private void writeColumn(ChunkPos $$0) {
        RegistryOps<Tag> $$12 = this.registryAccess.createSerializationContext(NbtOps.INSTANCE);
        Dynamic<Tag> $$2 = this.writeColumn($$0, $$12);
        Tag $$3 = (Tag)$$2.getValue();
        if ($$3 instanceof CompoundTag) {
            this.simpleRegionStorage.write($$0, (CompoundTag)$$3).exceptionally($$1 -> {
                this.errorReporter.reportChunkSaveFailure((Throwable)$$1, this.simpleRegionStorage.storageInfo(), $$0);
                return null;
            });
        } else {
            LOGGER.error("Expected compound tag, got {}", (Object)$$3);
        }
    }

    private <T> Dynamic<T> writeColumn(ChunkPos $$0, DynamicOps<T> $$1) {
        HashMap $$2 = Maps.newHashMap();
        for (int $$32 = this.levelHeightAccessor.getMinSection(); $$32 < this.levelHeightAccessor.getMaxSection(); ++$$32) {
            long $$4 = SectionStorage.getKey($$0, $$32);
            this.dirty.remove($$4);
            Optional $$5 = (Optional)this.storage.get($$4);
            if ($$5 == null || $$5.isEmpty()) continue;
            DataResult $$6 = this.codec.apply(() -> this.setDirty($$4)).encodeStart($$1, $$5.get());
            String $$7 = Integer.toString($$32);
            $$6.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$3 -> $$2.put($$1.createString($$7), $$3));
        }
        return new Dynamic($$1, $$1.createMap((Map)ImmutableMap.of((Object)$$1.createString(SECTIONS_TAG), (Object)$$1.createMap((Map)$$2), (Object)$$1.createString("DataVersion"), (Object)$$1.createInt(SharedConstants.getCurrentVersion().getDataVersion().getVersion()))));
    }

    private static long getKey(ChunkPos $$0, int $$1) {
        return SectionPos.asLong($$0.x, $$1, $$0.z);
    }

    protected void onSectionLoad(long $$0) {
    }

    protected void setDirty(long $$0) {
        Optional $$1 = (Optional)this.storage.get($$0);
        if ($$1 == null || $$1.isEmpty()) {
            LOGGER.warn("No data for position: {}", (Object)SectionPos.of($$0));
            return;
        }
        this.dirty.add($$0);
    }

    private static int getVersion(Dynamic<?> $$0) {
        return $$0.get("DataVersion").asInt(1945);
    }

    public void flush(ChunkPos $$0) {
        if (this.hasWork()) {
            for (int $$1 = this.levelHeightAccessor.getMinSection(); $$1 < this.levelHeightAccessor.getMaxSection(); ++$$1) {
                long $$2 = SectionStorage.getKey($$0, $$1);
                if (!this.dirty.contains($$2)) continue;
                this.writeColumn($$0);
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.simpleRegionStorage.close();
    }
}

