/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class JigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext $$02, Holder<StructureTemplatePool> $$1, Optional<ResourceLocation> $$22, int $$3, BlockPos $$4, boolean $$5, Optional<Heightmap.Types> $$6, int $$7, PoolAliasLookup $$8, DimensionPadding $$9, LiquidSettings $$10) {
        int $$31;
        BlockPos $$23;
        RegistryAccess $$11 = $$02.registryAccess();
        ChunkGenerator $$12 = $$02.chunkGenerator();
        StructureTemplateManager $$13 = $$02.structureTemplateManager();
        LevelHeightAccessor $$14 = $$02.heightAccessor();
        WorldgenRandom $$15 = $$02.random();
        Registry<StructureTemplatePool> $$16 = $$11.registryOrThrow(Registries.TEMPLATE_POOL);
        Rotation $$172 = Rotation.getRandom($$15);
        StructureTemplatePool $$18 = $$1.unwrapKey().flatMap($$2 -> $$16.getOptional($$8.lookup((ResourceKey<StructureTemplatePool>)$$2))).orElse($$1.value());
        StructurePoolElement $$19 = $$18.getRandomTemplate($$15);
        if ($$19 == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if ($$22.isPresent()) {
            ResourceLocation $$20 = $$22.get();
            Optional<BlockPos> $$21 = JigsawPlacement.getRandomNamedJigsaw($$19, $$20, $$4, $$172, $$13, $$15);
            if ($$21.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)$$20, (Object)$$1.unwrapKey().map($$0 -> $$0.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            BlockPos $$222 = $$21.get();
        } else {
            $$23 = $$4;
        }
        BlockPos $$24 = $$23.subtract($$4);
        BlockPos $$25 = $$4.subtract($$24);
        PoolElementStructurePiece $$26 = new PoolElementStructurePiece($$13, $$19, $$25, $$19.getGroundLevelDelta(), $$172, $$19.getBoundingBox($$13, $$25, $$172), $$10);
        BoundingBox $$27 = $$26.getBoundingBox();
        int $$28 = ($$27.maxX() + $$27.minX()) / 2;
        int $$29 = ($$27.maxZ() + $$27.minZ()) / 2;
        if ($$6.isPresent()) {
            int $$30 = $$4.getY() + $$12.getFirstFreeHeight($$28, $$29, $$6.get(), $$14, $$02.randomState());
        } else {
            $$31 = $$25.getY();
        }
        int $$32 = $$27.minY() + $$26.getGroundLevelDelta();
        $$26.move(0, $$31 - $$32, 0);
        int $$33 = $$31 + $$24.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos($$28, $$33, $$29), $$17 -> {
            ArrayList $$18 = Lists.newArrayList();
            $$18.add($$26);
            if ($$3 <= 0) {
                return;
            }
            AABB $$19 = new AABB($$28 - $$7, Math.max($$33 - $$7, $$14.getMinBuildHeight() + $$9.bottom()), $$29 - $$7, $$28 + $$7 + 1, Math.min($$33 + $$7 + 1, $$14.getMaxBuildHeight() - $$9.top()), $$29 + $$7 + 1);
            VoxelShape $$20 = Shapes.join(Shapes.create($$19), Shapes.create(AABB.of($$27)), BooleanOp.ONLY_FIRST);
            JigsawPlacement.addPieces($$02.randomState(), $$3, $$5, $$12, $$13, $$14, $$15, $$16, $$26, $$18, $$20, $$8, $$10);
            $$18.forEach($$17::addPiece);
        }));
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement $$0, ResourceLocation $$1, BlockPos $$2, Rotation $$3, StructureTemplateManager $$4, WorldgenRandom $$5) {
        List<StructureTemplate.StructureBlockInfo> $$6 = $$0.getShuffledJigsawBlocks($$4, $$2, $$3, $$5);
        Optional<BlockPos> $$7 = Optional.empty();
        for (StructureTemplate.StructureBlockInfo $$8 : $$6) {
            ResourceLocation $$9 = ResourceLocation.tryParse(Objects.requireNonNull($$8.nbt(), () -> String.valueOf($$8) + " nbt was null").getString("name"));
            if (!$$1.equals($$9)) continue;
            $$7 = Optional.of($$8.pos());
            break;
        }
        return $$7;
    }

    private static void addPieces(RandomState $$0, int $$1, boolean $$2, ChunkGenerator $$3, StructureTemplateManager $$4, LevelHeightAccessor $$5, RandomSource $$6, Registry<StructureTemplatePool> $$7, PoolElementStructurePiece $$8, List<PoolElementStructurePiece> $$9, VoxelShape $$10, PoolAliasLookup $$11, LiquidSettings $$12) {
        Placer $$13 = new Placer($$7, $$1, $$3, $$4, $$9, $$6);
        $$13.tryPlacingChildren($$8, (MutableObject<VoxelShape>)new MutableObject((Object)$$10), 0, $$2, $$5, $$0, $$11, $$12);
        while ($$13.placing.hasNext()) {
            PieceState $$14 = (PieceState)$$13.placing.next();
            $$13.tryPlacingChildren($$14.piece, $$14.free, $$14.depth, $$2, $$5, $$0, $$11, $$12);
        }
    }

    public static boolean generateJigsaw(ServerLevel $$02, Holder<StructureTemplatePool> $$1, ResourceLocation $$2, int $$3, BlockPos $$4, boolean $$5) {
        ChunkGenerator $$6 = $$02.getChunkSource().getGenerator();
        StructureTemplateManager $$7 = $$02.getStructureManager();
        StructureManager $$8 = $$02.structureManager();
        RandomSource $$9 = $$02.getRandom();
        Structure.GenerationContext $$10 = new Structure.GenerationContext($$02.registryAccess(), $$6, $$6.getBiomeSource(), $$02.getChunkSource().randomState(), $$7, $$02.getSeed(), new ChunkPos($$4), $$02, $$0 -> true);
        Optional<Structure.GenerationStub> $$11 = JigsawPlacement.addPieces($$10, $$1, Optional.of($$2), $$3, $$4, false, Optional.empty(), 128, PoolAliasLookup.EMPTY, JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS);
        if ($$11.isPresent()) {
            StructurePiecesBuilder $$12 = $$11.get().getPiecesBuilder();
            for (StructurePiece $$13 : $$12.build().pieces()) {
                if (!($$13 instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece $$14 = (PoolElementStructurePiece)$$13;
                $$14.place($$02, $$8, $$6, $$9, BoundingBox.infinite(), $$4, $$5);
            }
            return true;
        }
        return false;
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final SequencedPriorityIterator<PieceState> placing = new SequencedPriorityIterator();

        Placer(Registry<StructureTemplatePool> $$0, int $$1, ChunkGenerator $$2, StructureTemplateManager $$3, List<? super PoolElementStructurePiece> $$4, RandomSource $$5) {
            this.pools = $$0;
            this.maxDepth = $$1;
            this.chunkGenerator = $$2;
            this.structureTemplateManager = $$3;
            this.pieces = $$4;
            this.random = $$5;
        }

        void tryPlacingChildren(PoolElementStructurePiece $$02, MutableObject<VoxelShape> $$1, int $$22, boolean $$3, LevelHeightAccessor $$4, RandomState $$5, PoolAliasLookup $$6, LiquidSettings $$7) {
            StructurePoolElement $$8 = $$02.getElement();
            BlockPos $$9 = $$02.getPosition();
            Rotation $$10 = $$02.getRotation();
            StructureTemplatePool.Projection $$11 = $$8.getProjection();
            boolean $$12 = $$11 == StructureTemplatePool.Projection.RIGID;
            MutableObject $$13 = new MutableObject();
            BoundingBox $$14 = $$02.getBoundingBox();
            int $$15 = $$14.minY();
            block0: for (StructureTemplate.StructureBlockInfo $$16 : $$8.getShuffledJigsawBlocks(this.structureTemplateManager, $$9, $$10, this.random)) {
                StructurePoolElement $$31;
                MutableObject<VoxelShape> $$28;
                Direction $$17 = JigsawBlock.getFrontFacing($$16.state());
                BlockPos $$18 = $$16.pos();
                BlockPos $$19 = $$18.relative($$17);
                int $$20 = $$18.getY() - $$15;
                int $$21 = -1;
                ResourceKey<StructureTemplatePool> $$222 = Placer.readPoolKey($$16, $$6);
                Optional<Holder.Reference<StructureTemplatePool>> $$23 = this.pools.getHolder($$222);
                if ($$23.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)$$222.location());
                    continue;
                }
                Holder $$24 = $$23.get();
                if (((StructureTemplatePool)$$24.value()).size() == 0 && !$$24.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)$$222.location());
                    continue;
                }
                Holder<StructureTemplatePool> $$25 = ((StructureTemplatePool)$$24.value()).getFallback();
                if ($$25.value().size() == 0 && !$$25.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)$$25.unwrapKey().map($$0 -> $$0.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean $$26 = $$14.isInside($$19);
                if ($$26) {
                    MutableObject $$27 = $$13;
                    if ($$13.getValue() == null) {
                        $$13.setValue((Object)Shapes.create(AABB.of($$14)));
                    }
                } else {
                    $$28 = $$1;
                }
                ArrayList $$29 = Lists.newArrayList();
                if ($$22 != this.maxDepth) {
                    $$29.addAll(((StructureTemplatePool)$$24.value()).getShuffledTemplates(this.random));
                }
                $$29.addAll($$25.value().getShuffledTemplates(this.random));
                int $$30 = $$16.nbt() != null ? $$16.nbt().getInt("placement_priority") : 0;
                Iterator iterator = $$29.iterator();
                while (iterator.hasNext() && ($$31 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.INSTANCE) {
                    for (Rotation $$32 : Rotation.getShuffled(this.random)) {
                        int $$36;
                        List<StructureTemplate.StructureBlockInfo> $$33 = $$31.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, $$32, this.random);
                        BoundingBox $$34 = $$31.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, $$32);
                        if (!$$3 || $$34.getYSpan() > 16) {
                            boolean $$35 = false;
                        } else {
                            $$36 = $$33.stream().mapToInt($$2 -> {
                                if (!$$34.isInside($$2.pos().relative(JigsawBlock.getFrontFacing($$2.state())))) {
                                    return 0;
                                }
                                ResourceKey<StructureTemplatePool> $$3 = Placer.readPoolKey($$2, $$6);
                                Optional<Holder.Reference<StructureTemplatePool>> $$4 = this.pools.getHolder($$3);
                                Optional<Holder> $$5 = $$4.map($$0 -> ((StructureTemplatePool)$$0.value()).getFallback());
                                int $$6 = $$4.map($$0 -> ((StructureTemplatePool)$$0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                                int $$7 = $$5.map($$0 -> ((StructureTemplatePool)$$0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                                return Math.max($$6, $$7);
                            }).max().orElse(0);
                        }
                        for (StructureTemplate.StructureBlockInfo $$37 : $$33) {
                            int $$58;
                            int $$54;
                            int $$47;
                            if (!JigsawBlock.canAttach($$16, $$37)) continue;
                            BlockPos $$38 = $$37.pos();
                            BlockPos $$39 = $$19.subtract($$38);
                            BoundingBox $$40 = $$31.getBoundingBox(this.structureTemplateManager, $$39, $$32);
                            int $$41 = $$40.minY();
                            StructureTemplatePool.Projection $$42 = $$31.getProjection();
                            boolean $$43 = $$42 == StructureTemplatePool.Projection.RIGID;
                            int $$44 = $$38.getY();
                            int $$45 = $$20 - $$44 + JigsawBlock.getFrontFacing($$16.state()).getStepY();
                            if ($$12 && $$43) {
                                int $$46 = $$15 + $$45;
                            } else {
                                if ($$21 == -1) {
                                    $$21 = this.chunkGenerator.getFirstFreeHeight($$18.getX(), $$18.getZ(), Heightmap.Types.WORLD_SURFACE_WG, $$4, $$5);
                                }
                                $$47 = $$21 - $$44;
                            }
                            int $$48 = $$47 - $$41;
                            BoundingBox $$49 = $$40.moved(0, $$48, 0);
                            BlockPos $$50 = $$39.offset(0, $$48, 0);
                            if ($$36 > 0) {
                                int $$51 = Math.max($$36 + 1, $$49.maxY() - $$49.minY());
                                $$49.encapsulate(new BlockPos($$49.minX(), $$49.minY() + $$51, $$49.minZ()));
                            }
                            if (Shapes.joinIsNotEmpty((VoxelShape)$$28.getValue(), Shapes.create(AABB.of($$49).deflate(0.25)), BooleanOp.ONLY_SECOND)) continue;
                            $$28.setValue((Object)Shapes.joinUnoptimized((VoxelShape)$$28.getValue(), Shapes.create(AABB.of($$49)), BooleanOp.ONLY_FIRST));
                            int $$52 = $$02.getGroundLevelDelta();
                            if ($$43) {
                                int $$53 = $$52 - $$45;
                            } else {
                                $$54 = $$31.getGroundLevelDelta();
                            }
                            PoolElementStructurePiece $$55 = new PoolElementStructurePiece(this.structureTemplateManager, $$31, $$50, $$54, $$32, $$49, $$7);
                            if ($$12) {
                                int $$56 = $$15 + $$20;
                            } else if ($$43) {
                                int $$57 = $$47 + $$44;
                            } else {
                                if ($$21 == -1) {
                                    $$21 = this.chunkGenerator.getFirstFreeHeight($$18.getX(), $$18.getZ(), Heightmap.Types.WORLD_SURFACE_WG, $$4, $$5);
                                }
                                $$58 = $$21 + $$45 / 2;
                            }
                            $$02.addJunction(new JigsawJunction($$19.getX(), (int)($$58 - $$20 + $$52), $$19.getZ(), $$45, $$42));
                            $$55.addJunction(new JigsawJunction($$18.getX(), $$58 - $$44 + $$54, $$18.getZ(), -$$45, $$11));
                            this.pieces.add($$55);
                            if ($$22 + 1 > this.maxDepth) continue block0;
                            PieceState $$59 = new PieceState($$55, $$28, $$22 + 1);
                            this.placing.add($$59, $$30);
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolKey(StructureTemplate.StructureBlockInfo $$0, PoolAliasLookup $$1) {
            CompoundTag $$2 = Objects.requireNonNull($$0.nbt(), () -> String.valueOf($$0) + " nbt was null");
            ResourceKey<StructureTemplatePool> $$3 = Pools.parseKey($$2.getString("pool"));
            return $$1.lookup($$3);
        }
    }

    record PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth) {
    }
}

