/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class DimensionDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, SavedData> cache = Maps.newHashMap();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final File dataFolder;

    public DimensionDataStorage(File $$0, DataFixer $$1, HolderLookup.Provider $$2) {
        this.fixerUpper = $$1;
        this.dataFolder = $$0;
        this.registries = $$2;
    }

    private File getDataFile(String $$0) {
        return new File(this.dataFolder, $$0 + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedData.Factory<T> $$0, String $$1) {
        T $$2 = this.get($$0, $$1);
        if ($$2 != null) {
            return $$2;
        }
        SavedData $$3 = (SavedData)$$0.constructor().get();
        this.set($$1, $$3);
        return (T)$$3;
    }

    @Nullable
    public <T extends SavedData> T get(SavedData.Factory<T> $$0, String $$1) {
        SavedData $$2 = this.cache.get($$1);
        if ($$2 == null && !this.cache.containsKey($$1)) {
            $$2 = this.readSavedData($$0.deserializer(), $$0.type(), $$1);
            this.cache.put($$1, $$2);
        }
        return (T)$$2;
    }

    @Nullable
    private <T extends SavedData> T readSavedData(BiFunction<CompoundTag, HolderLookup.Provider, T> $$0, DataFixTypes $$1, String $$2) {
        try {
            File $$3 = this.getDataFile($$2);
            if ($$3.exists()) {
                CompoundTag $$4 = this.readTagFromDisk($$2, $$1, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                return (T)((SavedData)$$0.apply($$4.getCompound("data"), this.registries));
            }
        }
        catch (Exception $$5) {
            LOGGER.error("Error loading saved data: {}", (Object)$$2, (Object)$$5);
        }
        return null;
    }

    public void set(String $$0, SavedData $$1) {
        this.cache.put($$0, $$1);
    }

    /*
     * WARNING - void declaration
     */
    public CompoundTag readTagFromDisk(String $$0, DataFixTypes $$1, int $$2) throws IOException {
        File $$3 = this.getDataFile($$0);
        try (FileInputStream $$4 = new FileInputStream($$3);){
            CompoundTag compoundTag;
            try (PushbackInputStream $$5 = new PushbackInputStream(new FastBufferedInputStream($$4), 2);){
                void $$9;
                if (this.isGzip($$5)) {
                    CompoundTag $$6 = NbtIo.readCompressed($$5, NbtAccounter.unlimitedHeap());
                } else {
                    try (DataInputStream $$7 = new DataInputStream($$5);){
                        CompoundTag $$8 = NbtIo.read($$7);
                    }
                }
                int $$10 = NbtUtils.getDataVersion((CompoundTag)$$9, 1343);
                compoundTag = $$1.update(this.fixerUpper, (CompoundTag)$$9, $$10, $$2);
            }
            return compoundTag;
        }
    }

    private boolean isGzip(PushbackInputStream $$0) throws IOException {
        int $$4;
        byte[] $$1 = new byte[2];
        boolean $$2 = false;
        int $$3 = $$0.read($$1, 0, 2);
        if ($$3 == 2 && ($$4 = ($$1[1] & 0xFF) << 8 | $$1[0] & 0xFF) == 35615) {
            $$2 = true;
        }
        if ($$3 != 0) {
            $$0.unread($$1, 0, $$3);
        }
        return $$2;
    }

    public void save() {
        this.cache.forEach(($$0, $$1) -> {
            if ($$1 != null) {
                $$1.save(this.getDataFile((String)$$0), this.registries);
            }
        });
    }
}

