/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;

public class PlayerDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess $$0, DataFixer $$1) {
        this.fixerUpper = $$1;
        this.playerDir = $$0.getLevelPath(LevelResource.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(Player $$0) {
        try {
            CompoundTag $$1 = $$0.saveWithoutId(new CompoundTag());
            Path $$2 = this.playerDir.toPath();
            Path $$3 = Files.createTempFile($$2, $$0.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            NbtIo.writeCompressed($$1, $$3);
            Path $$4 = $$2.resolve($$0.getStringUUID() + ".dat");
            Path $$5 = $$2.resolve($$0.getStringUUID() + ".dat_old");
            Util.safeReplaceFile($$4, $$3, $$5);
        }
        catch (Exception $$6) {
            LOGGER.warn("Failed to save player data for {}", (Object)$$0.getName().getString());
        }
    }

    private void backup(Player $$0, String $$1) {
        Path $$2 = this.playerDir.toPath();
        Path $$3 = $$2.resolve($$0.getStringUUID() + $$1);
        Path $$4 = $$2.resolve($$0.getStringUUID() + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + $$1);
        if (!Files.isRegularFile($$3, new LinkOption[0])) {
            return;
        }
        try {
            Files.copy($$3, $$4, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Exception $$5) {
            LOGGER.warn("Failed to copy the player.dat file for {}", (Object)$$0.getName().getString(), (Object)$$5);
        }
    }

    private Optional<CompoundTag> load(Player $$0, String $$1) {
        File $$2 = new File(this.playerDir, $$0.getStringUUID() + $$1);
        if ($$2.exists() && $$2.isFile()) {
            try {
                return Optional.of(NbtIo.readCompressed($$2.toPath(), NbtAccounter.unlimitedHeap()));
            }
            catch (Exception $$3) {
                LOGGER.warn("Failed to load player data for {}", (Object)$$0.getName().getString());
            }
        }
        return Optional.empty();
    }

    public Optional<CompoundTag> load(Player $$0) {
        Optional<CompoundTag> $$12 = this.load($$0, ".dat");
        if ($$12.isEmpty()) {
            this.backup($$0, ".dat");
        }
        return $$12.or(() -> this.load($$0, ".dat_old")).map($$1 -> {
            int $$2 = NbtUtils.getDataVersion($$1, -1);
            $$1 = DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, (CompoundTag)$$1, $$2);
            $$0.load((CompoundTag)$$1);
            return $$1;
        });
    }
}

