/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;

public class LootParams {
    private final ServerLevel level;
    private final Map<LootContextParam<?>, Object> params;
    private final Map<ResourceLocation, DynamicDrop> dynamicDrops;
    private final float luck;

    public LootParams(ServerLevel $$0, Map<LootContextParam<?>, Object> $$1, Map<ResourceLocation, DynamicDrop> $$2, float $$3) {
        this.level = $$0;
        this.params = $$1;
        this.dynamicDrops = $$2;
        this.luck = $$3;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public boolean hasParam(LootContextParam<?> $$0) {
        return this.params.containsKey($$0);
    }

    public <T> T getParameter(LootContextParam<T> $$0) {
        Object $$1 = this.params.get($$0);
        if ($$1 == null) {
            throw new NoSuchElementException($$0.getName().toString());
        }
        return (T)$$1;
    }

    @Nullable
    public <T> T getOptionalParameter(LootContextParam<T> $$0) {
        return (T)this.params.get($$0);
    }

    @Nullable
    public <T> T getParamOrNull(LootContextParam<T> $$0) {
        return (T)this.params.get($$0);
    }

    public void addDynamicDrops(ResourceLocation $$0, Consumer<ItemStack> $$1) {
        DynamicDrop $$2 = this.dynamicDrops.get($$0);
        if ($$2 != null) {
            $$2.add($$1);
        }
    }

    public float getLuck() {
        return this.luck;
    }

    @FunctionalInterface
    public static interface DynamicDrop {
        public void add(Consumer<ItemStack> var1);
    }

    public static class Builder {
        private final ServerLevel level;
        private final Map<LootContextParam<?>, Object> params = Maps.newIdentityHashMap();
        private final Map<ResourceLocation, DynamicDrop> dynamicDrops = Maps.newHashMap();
        private float luck;

        public Builder(ServerLevel $$0) {
            this.level = $$0;
        }

        public ServerLevel getLevel() {
            return this.level;
        }

        public <T> Builder withParameter(LootContextParam<T> $$0, T $$1) {
            this.params.put($$0, $$1);
            return this;
        }

        public <T> Builder withOptionalParameter(LootContextParam<T> $$0, @Nullable T $$1) {
            if ($$1 == null) {
                this.params.remove($$0);
            } else {
                this.params.put($$0, $$1);
            }
            return this;
        }

        public <T> T getParameter(LootContextParam<T> $$0) {
            Object $$1 = this.params.get($$0);
            if ($$1 == null) {
                throw new NoSuchElementException($$0.getName().toString());
            }
            return (T)$$1;
        }

        @Nullable
        public <T> T getOptionalParameter(LootContextParam<T> $$0) {
            return (T)this.params.get($$0);
        }

        public Builder withDynamicDrop(ResourceLocation $$0, DynamicDrop $$1) {
            DynamicDrop $$2 = this.dynamicDrops.put($$0, $$1);
            if ($$2 != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + String.valueOf(this.dynamicDrops) + "'");
            }
            return this;
        }

        public Builder withLuck(float $$0) {
            this.luck = $$0;
            return this;
        }

        public LootParams create(LootContextParamSet $$0) {
            Sets.SetView $$1 = Sets.difference(this.params.keySet(), $$0.getAllowed());
            if (!$$1.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + String.valueOf($$1));
            }
            Sets.SetView $$2 = Sets.difference($$0.getRequired(), this.params.keySet());
            if (!$$2.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.valueOf($$2));
            }
            return new LootParams(this.level, this.params, this.dynamicDrops, this.luck);
        }
    }
}

