/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;

public class ValidationContext {
    private final ProblemReporter reporter;
    private final LootContextParamSet params;
    private final Optional<HolderGetter.Provider> resolver;
    private final Set<ResourceKey<?>> visitedElements;

    public ValidationContext(ProblemReporter $$0, LootContextParamSet $$1, HolderGetter.Provider $$2) {
        this($$0, $$1, Optional.of($$2), Set.of());
    }

    public ValidationContext(ProblemReporter $$0, LootContextParamSet $$1) {
        this($$0, $$1, Optional.empty(), Set.of());
    }

    private ValidationContext(ProblemReporter $$0, LootContextParamSet $$1, Optional<HolderGetter.Provider> $$2, Set<ResourceKey<?>> $$3) {
        this.reporter = $$0;
        this.params = $$1;
        this.resolver = $$2;
        this.visitedElements = $$3;
    }

    public ValidationContext forChild(String $$0) {
        return new ValidationContext(this.reporter.forChild($$0), this.params, this.resolver, this.visitedElements);
    }

    public ValidationContext enterElement(String $$0, ResourceKey<?> $$1) {
        ImmutableSet $$2 = ImmutableSet.builder().addAll(this.visitedElements).add($$1).build();
        return new ValidationContext(this.reporter.forChild($$0), this.params, this.resolver, (Set<ResourceKey<?>>)$$2);
    }

    public boolean hasVisitedElement(ResourceKey<?> $$0) {
        return this.visitedElements.contains($$0);
    }

    public void reportProblem(String $$0) {
        this.reporter.report($$0);
    }

    public void validateUser(LootContextUser $$0) {
        this.params.validateUser(this, $$0);
    }

    public HolderGetter.Provider resolver() {
        return this.resolver.orElseThrow(() -> new UnsupportedOperationException("References not allowed"));
    }

    public boolean allowsReferences() {
        return this.resolver.isPresent();
    }

    public ValidationContext setParams(LootContextParamSet $$0) {
        return new ValidationContext(this.reporter, $$0, this.resolver, this.visitedElements);
    }

    public ProblemReporter reporter() {
        return this.reporter;
    }
}

