/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.INameMappingService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

class NameMappingServiceHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, INameMappingService> allKnown = new HashMap<String, INameMappingService>();
    private final Map<String, INameMappingService> active = new HashMap<String, INameMappingService>();

    public NameMappingServiceHandler(ModuleLayerHandler layerHandler) {
        ServiceLoader<INameMappingService> services = ServiceLoader.load(layerHandler.getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow(), INameMappingService.class);
        Iterator<INameMappingService> itr = services.iterator();
        while (itr.hasNext()) {
            try {
                INameMappingService srvc = itr.next();
                this.allKnown.put(srvc.mappingName(), srvc);
            }
            catch (ServiceConfigurationError sce) {
                LOGGER.fatal("Encountered serious error loading naming service, expect problems", (Throwable)sce);
            }
        }
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found naming services : [{}]", new Supplier[]{() -> String.join((CharSequence)", ", this.allKnown.keySet())});
    }

    public Optional<BiFunction<INameMappingService.Domain, String, String>> findNameTranslator(String targetNaming) {
        INameMappingService ret = this.active.get(targetNaming);
        if (ret == null) {
            return Optional.empty();
        }
        return Optional.of(ret.namingFunction());
    }

    public void bindNamingServices(String currentNaming) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Current naming domain is '{}'", (Object)currentNaming);
        this.active.clear();
        for (INameMappingService service : this.allKnown.values()) {
            if (!Objects.equals(service.understanding().getValue(), currentNaming)) continue;
            this.active.put(service.understanding().getKey(), service);
        }
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Identified name mapping providers {}", this.active);
    }
}

