/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.loading;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.Mth;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.earlydisplay.DisplayWindow;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL30C;

public class ForgeLoadingOverlay
extends LoadingOverlay {
    private final Minecraft minecraft;
    private final ReloadInstance reload;
    private final DisplayWindow displayWindow;
    private final ProgressMeter progress;

    public ForgeLoadingOverlay(Minecraft mc, ReloadInstance reloader, Consumer<Optional<Throwable>> errorConsumer, DisplayWindow displayWindow) {
        super(mc, reloader, errorConsumer, false);
        this.minecraft = mc;
        this.reload = reloader;
        this.displayWindow = displayWindow;
        displayWindow.addMojangTexture(mc.getTextureManager().getTexture(MOJANG_STUDIOS_LOGO_LOCATION).getId());
        this.progress = StartupMessageManager.prependProgressBar((String)"Minecraft Progress", (int)100);
    }

    public static Supplier<LoadingOverlay> newInstance(Supplier<Minecraft> mc, Supplier<ReloadInstance> ri, Consumer<Optional<Throwable>> handler, DisplayWindow window) {
        return () -> new ForgeLoadingOverlay((Minecraft)mc.get(), (ReloadInstance)ri.get(), handler, window);
    }

    protected boolean renderContents(GuiGraphics gui, float fade) {
        this.progress.setAbsolute(Mth.clamp((int)((int)(this.reload.getActualProgress() * 100.0f)), (int)0, (int)100));
        int alpha = (int)(fade * 255.0f);
        this.displayWindow.render(alpha);
        int width = gui.guiWidth();
        int height = gui.guiHeight();
        int fbWidth = this.minecraft.getWindow().getWidth();
        int fbHeight = this.minecraft.getWindow().getHeight();
        GL30C.glViewport((int)0, (int)0, (int)fbWidth, (int)fbHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)fade);
        Matrix4f pos = gui.pose().last().pose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX_COLOR);
        RenderSystem.setShaderTexture((int)0, (int)this.displayWindow.getFramebufferTextureId());
        GL30C.glTexParameterIi((int)3553, (int)10241, (int)9728);
        GL30C.glTexParameterIi((int)3553, (int)10240, (int)9728);
        BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buf.addVertex(pos, 0.0f, 0.0f, 0.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, fade);
        buf.addVertex(pos, 0.0f, (float)height, 0.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, fade);
        buf.addVertex(pos, (float)width, (float)height, 0.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, fade);
        buf.addVertex(pos, (float)width, 0.0f, 0.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, fade);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        VertexConsumer logo = gui.getBufferSource().getBuffer(RenderType.mojangLogo());
        logo.addVertex(pos, 0.0f, 0.0f, 0.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, fade);
        logo.addVertex(pos, 0.0f, 0.0f, 0.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, fade);
        logo.addVertex(pos, 0.0f, 0.0f, 0.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, fade);
        logo.addVertex(pos, 0.0f, 0.0f, 0.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, fade);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return false;
    }
}

