/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.jetbrains.annotations.Nullable;

public class ForgeSpawnEggItem
extends SpawnEggItem {
    private static final List<ForgeSpawnEggItem> MOD_EGGS = new ArrayList<ForgeSpawnEggItem>();
    private static final Map<EntityType<? extends Mob>, ForgeSpawnEggItem> TYPE_MAP = new IdentityHashMap<EntityType<? extends Mob>, ForgeSpawnEggItem>();
    private final Supplier<? extends EntityType<? extends Mob>> typeSupplier;
    private static final DispenseItemBehavior DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        Direction face = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        EntityType type = ((SpawnEggItem)stack.getItem()).getType(stack);
        try {
            type.spawn(source.level(), stack, null, source.pos().relative(face), EntitySpawnReason.DISPENSER, face != Direction.UP, false);
        }
        catch (Exception exception) {
            DispenseItemBehavior.LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.pos(), (Object)exception);
            return ItemStack.EMPTY;
        }
        stack.shrink(1);
        source.level().gameEvent((Holder)GameEvent.ENTITY_PLACE, source.pos(), GameEvent.Context.of((BlockState)source.state()));
        return stack;
    };

    public ForgeSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor, Item.Properties props) {
        super((EntityType)null, backgroundColor, highlightColor, props);
        this.typeSupplier = type;
        MOD_EGGS.add(this);
    }

    @Nullable
    protected DispenseItemBehavior createDispenseBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Nullable
    public static SpawnEggItem fromEntityType(@Nullable EntityType<?> type) {
        SpawnEggItem ret = TYPE_MAP.get(type);
        return ret != null ? ret : SpawnEggItem.byId(type);
    }

    protected EntityType<?> getDefaultType() {
        return this.typeSupplier.get();
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="forge", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ColorRegisterHandler {
        private ColorRegisterHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerSpawnEggColors(RegisterColorHandlersEvent.Item event) {
            for (ForgeSpawnEggItem egg : MOD_EGGS) {
                event.register((stack, layer) -> {
                    int color = egg.getColor(layer);
                    if (ARGB.alpha((int)color) == 0) {
                        color = ARGB.opaque((int)color);
                    }
                    return color;
                }, new ItemLike[]{egg});
            }
        }
    }

    @Mod.EventBusSubscriber(modid="forge", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class CommonHandler {
        private CommonHandler() {
        }

        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            MOD_EGGS.forEach(egg -> {
                DispenseItemBehavior dispenseBehavior = egg.createDispenseBehavior();
                if (dispenseBehavior != null) {
                    DispenserBlock.registerBehavior((ItemLike)egg, (DispenseItemBehavior)dispenseBehavior);
                }
                TYPE_MAP.put(egg.typeSupplier.get(), (ForgeSpawnEggItem)((Object)egg));
            });
        }
    }
}

