/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class DifferenceIngredient
extends AbstractIngredient {
    private final Ingredient base;
    private final Ingredient subtracted;
    private List<Holder<Item>> items = null;
    public static final MapCodec<DifferenceIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("base").forGetter(i -> i.base), (App)Ingredient.CODEC.fieldOf("subtracted").forGetter(i -> i.subtracted)).apply((Applicative)builder, DifferenceIngredient::new));
    public static final IIngredientSerializer<DifferenceIngredient> SERIALIZER = new IIngredientSerializer<DifferenceIngredient>(){

        @Override
        public MapCodec<? extends DifferenceIngredient> codec() {
            return CODEC;
        }

        @Override
        public DifferenceIngredient read(RegistryFriendlyByteBuf buffer) {
            Ingredient base = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient without = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            return new DifferenceIngredient(base, without);
        }

        @Override
        public void write(RegistryFriendlyByteBuf buffer, DifferenceIngredient ingredient) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient.subtracted);
        }
    };

    public static DifferenceIngredient of(Ingredient base, Ingredient subtracted) {
        return new DifferenceIngredient(base, subtracted);
    }

    private DifferenceIngredient(Ingredient base, Ingredient subtracted) {
        this.base = base;
        this.subtracted = subtracted;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return this.base.test(stack) && !this.subtracted.test(stack);
    }

    public List<Holder<Item>> items() {
        if (this.items == null) {
            ArrayList<Holder> tmp = new ArrayList<Holder>();
            for (Holder base : this.base.items()) {
                boolean match = false;
                for (Holder item : this.subtracted.items()) {
                    if (!base.is(item)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                tmp.add(base);
            }
            this.items = Collections.unmodifiableList(tmp);
        }
        return this.items;
    }

    @Override
    public boolean isSimple() {
        return this.base.isSimple() && this.subtracted.isSimple();
    }

    public IIngredientSerializer<DifferenceIngredient> serializer() {
        return SERIALIZER;
    }
}

