/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.common.collect.BiMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;

public interface IForgeBlock {
    private Block self() {
        return (Block)this;
    }

    default public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.self().getFriction();
    }

    default public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getLightEmission();
    }

    default public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return state.is(BlockTags.CLIMBABLE);
    }

    default public boolean makesOpenTrapdoorAboveClimbable(BlockState state, LevelReader level, BlockPos pos, BlockState trapdoorState) {
        return state.getBlock() instanceof LadderBlock && state.getValue((Property)LadderBlock.FACING) == trapdoorState.getValue((Property)TrapDoorBlock.FACING);
    }

    default public boolean isBurning(BlockState state, BlockGetter level, BlockPos pos) {
        return this == Blocks.FIRE || this == Blocks.LAVA;
    }

    default public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return ForgeHooks.isCorrectToolForDrops(state, player);
    }

    default public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.self().playerWillDestroy(level, pos, state, player);
        return level.setBlock(pos, fluid.createLegacyBlock(), level.isClientSide ? 11 : 3);
    }

    default public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return this.self() instanceof BedBlock;
    }

    default public Optional<Vec3> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader levelReader, BlockPos pos, float orientation, @Nullable LivingEntity entity) {
        Level level;
        if (this.isBed(state, (BlockGetter)levelReader, pos, (Entity)entity) && levelReader instanceof Level && BedBlock.canSetSpawn((Level)(level = (Level)levelReader))) {
            return BedBlock.findStandUpPosition(type, (CollisionGetter)levelReader, (BlockPos)pos, (Direction)((Direction)state.getValue((Property)BedBlock.FACING)), (float)orientation);
        }
        return Optional.empty();
    }

    default public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacementType type, EntityType<?> entityType) {
        return state.isValidSpawn(level, pos, entityType);
    }

    default public void setBedOccupied(BlockState state, Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        level.setBlock(pos, (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    default public Direction getBedDirection(BlockState state, LevelReader level, BlockPos pos) {
        return (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
    }

    default public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.self().getExplosionResistance();
    }

    default public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.self().getCloneItemStack(level, pos, state);
    }

    default public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return false;
    }

    default public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean canSustainPlant(BlockState var1, BlockGetter var2, BlockPos var3, Direction var4, IPlantable var5);

    default public boolean onTreeGrow(BlockState state, LevelReader level, BiConsumer<BlockPos, BlockState> placeFunction, RandomSource randomSource, BlockPos pos, TreeConfiguration config) {
        return false;
    }

    default public boolean isFertile(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.is(Blocks.FARMLAND)) {
            return (Integer)state.getValue((Property)FarmBlock.MOISTURE) > 0;
        }
        return false;
    }

    default public boolean isConduitFrame(BlockState state, LevelReader level, BlockPos pos, BlockPos conduit) {
        return state.getBlock() == Blocks.PRISMARINE || state.getBlock() == Blocks.PRISMARINE_BRICKS || state.getBlock() == Blocks.SEA_LANTERN || state.getBlock() == Blocks.DARK_PRISMARINE;
    }

    default public boolean isPortalFrame(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(Blocks.OBSIDIAN);
    }

    default public int getExpDrop(BlockState state, LevelReader level, RandomSource randomSource, BlockPos pos, int fortuneLevel, int silkTouchLevel) {
        return 0;
    }

    default public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return state.rotate(direction);
    }

    default public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return state.is(BlockTags.ENCHANTMENT_POWER_PROVIDER) ? 1.0f : 0.0f;
    }

    default public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
    }

    default public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return state.isRedstoneConductor((BlockGetter)level, pos);
    }

    default public boolean getWeakChanges(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    public SoundType getSoundType(BlockState var1, LevelReader var2, BlockPos var3, @Nullable Entity var4);

    @Nullable
    default public int getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        Block block = this.self();
        if (block instanceof BeaconBeamBlock) {
            BeaconBeamBlock beam = (BeaconBeamBlock)block;
            return beam.getColor().getTextureDiffuseColor();
        }
        return -1;
    }

    default public BlockState getStateAtViewpoint(BlockState state, BlockGetter level, BlockPos pos, Vec3 viewpoint) {
        return state;
    }

    @Nullable
    default public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return state.getBlock() == Blocks.LAVA ? PathType.LAVA : (state.isBurning(level, pos) ? PathType.DAMAGE_FIRE : null);
    }

    @Nullable
    default public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        if (state.is(Blocks.SWEET_BERRY_BUSH)) {
            return PathType.DANGER_OTHER;
        }
        if (WalkNodeEvaluator.isBurningBlock((BlockState)state)) {
            return PathType.DANGER_FIRE;
        }
        return null;
    }

    default public boolean isSlimeBlock(BlockState state) {
        return state.getBlock() == Blocks.SLIME_BLOCK;
    }

    default public boolean isStickyBlock(BlockState state) {
        return state.getBlock() == Blocks.SLIME_BLOCK || state.getBlock() == Blocks.HONEY_BLOCK;
    }

    default public boolean canStickTo(BlockState state, BlockState other) {
        if (state.getBlock() == Blocks.HONEY_BLOCK && other.getBlock() == Blocks.SLIME_BLOCK) {
            return false;
        }
        if (state.getBlock() == Blocks.SLIME_BLOCK && other.getBlock() == Blocks.HONEY_BLOCK) {
            return false;
        }
        return state.isStickyBlock() || other.isStickyBlock();
    }

    default public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return ((FireBlock)Blocks.FIRE).getBurnOdds(state);
    }

    default public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.getFlammability(level, pos, direction) > 0;
    }

    default public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction direction, @Nullable LivingEntity igniter) {
    }

    default public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return ((FireBlock)Blocks.FIRE).getIgniteOdds(state);
    }

    default public boolean isFireSource(BlockState state, LevelReader level, BlockPos pos, Direction direction) {
        return state.is(level.dimensionType().infiniburn());
    }

    default public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        if (entity instanceof EnderDragon) {
            return !this.self().defaultBlockState().is(BlockTags.DRAGON_IMMUNE);
        }
        if (entity instanceof WitherBoss || entity instanceof WitherSkull) {
            return state.isAir() || WitherBoss.canDestroy((BlockState)state);
        }
        return true;
    }

    default public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return state.getBlock().dropFromExplosion(explosion);
    }

    default public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        this.self().wasExploded(level, pos, explosion);
    }

    default public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return state.is(BlockTags.FENCES) || state.is(BlockTags.WALLS) || this.self() instanceof FenceGateBlock;
    }

    default public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return state.getBlock() instanceof HalfTransparentBlock || state.getBlock() instanceof LeavesBlock;
    }

    @Nullable
    default public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        ItemStack itemStack = context.getItemInHand();
        if (!itemStack.canPerformAction(toolAction)) {
            return null;
        }
        if (ToolActions.AXE_STRIP == toolAction) {
            return AxeItem.getAxeStrippingState((BlockState)state);
        }
        if (ToolActions.AXE_SCRAPE == toolAction) {
            return WeatheringCopper.getPrevious((BlockState)state).orElse(null);
        }
        if (ToolActions.AXE_WAX_OFF == toolAction) {
            return Optional.ofNullable((Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state)).orElse(null);
        }
        if (ToolActions.SHOVEL_FLATTEN == toolAction) {
            return ShovelItem.getShovelPathingState((BlockState)state);
        }
        if (ToolActions.HOE_TILL == toolAction) {
            Block block2 = state.getBlock();
            if (block2 == Blocks.ROOTED_DIRT) {
                if (!simulate && !context.getLevel().isClientSide) {
                    Block.popResourceFromFace((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (ItemStack)new ItemStack((ItemLike)Items.HANGING_ROOTS));
                }
                return Blocks.DIRT.defaultBlockState();
            }
            if ((block2 == Blocks.GRASS_BLOCK || block2 == Blocks.DIRT_PATH || block2 == Blocks.DIRT || block2 == Blocks.COARSE_DIRT) && context.getLevel().getBlockState(context.getClickedPos().above()).isAir()) {
                return block2 == Blocks.COARSE_DIRT ? Blocks.DIRT.defaultBlockState() : Blocks.FARMLAND.defaultBlockState();
            }
        }
        return null;
    }

    default public boolean isScaffolding(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return state.is(Blocks.SCAFFOLDING);
    }

    default public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        if (state.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (state.is(Blocks.REPEATER)) {
            Direction facing = (Direction)state.getValue((Property)RepeaterBlock.FACING);
            return facing == direction || facing.getOpposite() == direction;
        }
        if (state.is(Blocks.OBSERVER)) {
            return direction == state.getValue((Property)ObserverBlock.FACING);
        }
        return state.isSignalSource() && direction != null;
    }

    default public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return false;
    }

    default public boolean supportsExternalFaceHiding(BlockState state) {
        if (FMLEnvironment.dist.isClient()) {
            return !ForgeHooksClient.isBlockInSolidLayer(state);
        }
        return true;
    }

    default public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
    }

    default public boolean canBeHydrated(BlockState state, BlockGetter getter, BlockPos pos, FluidState fluid, BlockPos fluidPos) {
        return fluid.canHydrate(getter, fluidPos, state, pos);
    }

    default public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return defaultColor;
    }

    default public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return state;
    }

    @Nullable
    default public PushReaction getPistonPushReaction(BlockState state) {
        return null;
    }
}

