/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.bootstrap;

import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import net.minecraftforge.bootstrap.Bootstrap;

public class ForgeBootstrap
extends Bootstrap {
    private static final String MODS_TOML = "META-INF/mods.toml";
    private static final String MINECRAFT = "net/minecraft/client/main/Main.class";
    private static final Attributes.Name MOD_TYPE = new Attributes.Name("FMLModType");

    public static void main(String[] args) throws Exception {
        new ForgeBootstrap().start(args);
    }

    @Override
    protected List<SecureJar> selectRuntimeModules(List<Path[]> classpath) {
        ArrayList<SecureJar> jars = new ArrayList<SecureJar>(classpath.size());
        for (Path[] paths : classpath) {
            jars.add(this.secureJar(paths));
        }
        ArrayList<SecureJar> ret = new ArrayList<SecureJar>();
        ModuleLayer bootlayer = this.getClass().getModule().getLayer();
        int width = jars.stream().mapToInt(j -> j.moduleDataProvider().name().length()).max().orElse(0) + 1;
        if (DEBUG) {
            ForgeBootstrap.log("Found classpath:");
        }
        for (int x = 0; x < classpath.size(); ++x) {
            SecureJar jar = (SecureJar)jars.get(x);
            String name = jar.moduleDataProvider().name();
            Path[] paths = classpath.get(x);
            if (bootlayer.findModule(name).isPresent()) {
                ForgeBootstrap.log("  Bootstrap: ", width, name, paths);
                continue;
            }
            SecureJar.ModuleDataProvider meta = jar.moduleDataProvider();
            if (meta.findFile(MODS_TOML).isPresent() || meta.findFile(MINECRAFT).isPresent() || meta.getManifest().getMainAttributes().getValue(MOD_TYPE) != null) {
                ForgeBootstrap.log("  ModFile:   ", width, name, paths);
                continue;
            }
            ForgeBootstrap.log("  Module:    ", width, name, paths);
            ret.add(jar);
        }
        return ret;
    }
}

