/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModStateTransitionHelper;
import net.minecraftforge.fml.ThreadSelector;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import org.jetbrains.annotations.Nullable;

public interface IModStateTransition {
    public static final BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<Void>> NULL_HOOK = (e, g) -> CompletableFuture.completedFuture(null);

    public static IModStateTransition buildNoopTransition() {
        return ModStateTransitionHelper.NOOP;
    }

    default public CompletableFuture<Void> build(String name, Executor syncExecutor, Executor parallelExecutor, ProgressMeter progressBar, Function<Executor, CompletableFuture<Void>> preSyncTask, Function<Executor, CompletableFuture<Void>> postSyncTask) {
        return ModStateTransitionHelper.build(this, name, syncExecutor, parallelExecutor, progressBar, preSyncTask, postSyncTask);
    }

    default public BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextModLoadingStage() {
        return ModLoadingStage::nextState;
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    default public Supplier<Stream<EventGenerator<?>>> eventFunctionStream() {
        return () -> Stream.ofNullable(this.eventFunction());
    }

    @Nullable
    default public <T extends Event> EventGenerator<T> eventFunction() {
        return null;
    }

    public ThreadSelector threadSelector();

    public BiFunction<Executor, CompletableFuture<Void>, CompletableFuture<Void>> finalActivityGenerator();

    @Deprecated(since="1.21.3", forRemoval=true)
    default public BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<Void>> preDispatchHook() {
        return NULL_HOOK;
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    default public BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<Void>> postDispatchHook() {
        return NULL_HOOK;
    }

    public static interface EventGenerator<T extends Event>
    extends Function<ModContainer, T> {
        public static <FN extends Event> EventGenerator<FN> fromFunction(Function<ModContainer, FN> fn) {
            return fn::apply;
        }
    }
}

