/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.INameMappingService;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraftforge.accesstransformer.service.AccessTransformerService;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import net.minecraftforge.fml.loading.LanguageLoadingProvider;
import net.minecraftforge.fml.loading.LauncherVersion;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.RuntimeDistCleaner;
import net.minecraftforge.fml.loading.VersionInfo;
import net.minecraftforge.fml.loading.moddiscovery.BackgroundScanHandler;
import net.minecraftforge.fml.loading.moddiscovery.ModDiscoverer;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModValidator;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.coremod.ICoreModProvider;
import org.slf4j.Logger;

public class FMLLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static AccessTransformerService accessTransformer;
    private static ICoreModProvider coreModProvider;
    private static LanguageLoadingProvider languageLoadingProvider;
    private static Dist dist;
    private static String naming;
    private static LoadingModList loadingModList;
    private static RuntimeDistCleaner runtimeDistCleaner;
    private static Path gamePath;
    private static final VersionInfo versionInfo;
    private static String launchHandlerName;
    private static CommonLaunchHandler commonLaunchHandler;
    public static Runnable progressWindowTick;
    private static ModValidator modValidator;
    public static BackgroundScanHandler backgroundScanHandler;
    private static boolean production;
    private static IModuleLayerManager moduleLayerManager;

    static void onInitialLoad(IEnvironment env, Set<String> otherServices) throws IncompatibleEnvironmentException {
        LOGGER.debug(LogMarkers.CORE, "Detected version data : {}", (Object)versionInfo);
        LOGGER.debug(LogMarkers.CORE, "FML {} loading", (Object)LauncherVersion.getVersion());
        FMLLoader.checkPackage(ITransformationService.class, "4.0", "ModLauncher");
        accessTransformer = (AccessTransformerService)FMLLoader.getPlugin(env, "accesstransformer", "1.0", "AccessTransformer");
        FMLLoader.getPlugin(env, "eventbus", "1.0", "EventBus");
        runtimeDistCleaner = (RuntimeDistCleaner)FMLLoader.getPlugin(env, "runtimedistcleaner", "1.0", "RuntimeDistCleaner");
        coreModProvider = FMLLoader.getSingleService(ICoreModProvider.class, "CoreMod");
        LOGGER.debug(LogMarkers.CORE, "FML found CoreMod version : {}", (Object)JarVersionLookupHandler.getInfo(coreModProvider.getClass()).impl().version().orElse("MISSING"));
        FMLLoader.checkPackage(Environment.class, "2.0", "ForgeSPI");
        try {
            Class.forName("com.electronwill.nightconfig.core.Config", false, env.getClass().getClassLoader());
            Class.forName("com.electronwill.nightconfig.toml.TomlFormat", false, env.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(LogMarkers.CORE, "Failed to load NightConfig");
            throw new IncompatibleEnvironmentException("Missing NightConfig");
        }
    }

    private static <T> T getPlugin(IEnvironment env, String id, String version, String name) throws IncompatibleEnvironmentException {
        ILaunchPluginService plugin = env.findLaunchPlugin(id).orElse(null);
        if (plugin == null) {
            LOGGER.error(LogMarkers.CORE, "{} library is missing, we need this to run", (Object)name);
            throw new IncompatibleEnvironmentException("Missing " + name + ", cannot run");
        }
        FMLLoader.checkPackage(plugin.getClass(), version, name);
        return (T)plugin;
    }

    private static void checkPackage(Class<?> cls, String version, String name) throws IncompatibleEnvironmentException {
        Package pkg = cls.getPackage();
        JarVersionLookupHandler.Info info = JarVersionLookupHandler.getInfo(pkg);
        LOGGER.debug(LogMarkers.CORE, "Found {} version: {}", (Object)name, (Object)info.impl().version().orElse("MISSING"));
        if (!pkg.isCompatibleWith(version)) {
            LOGGER.error(LogMarkers.CORE, "Found incompatible {} specification: {}, version {} from {}", new Object[]{name, info.spec().version().orElse("MISSING"), info.impl().version().orElse("MISSING"), info.impl().vendor().orElse("MISSING")});
            throw new IncompatibleEnvironmentException("Incompatible " + name + " found " + info.spec().version().orElse("MISSING"));
        }
    }

    private static <T> T getSingleService(Class<T> clazz, String name) throws IncompatibleEnvironmentException {
        ArrayList<T> providers = new ArrayList<T>();
        Iterator<T> itr = ServiceLoader.load(FMLLoader.class.getModule().getLayer(), clazz).iterator();
        while (itr.hasNext()) {
            try {
                providers.add(itr.next());
            }
            catch (ServiceConfigurationError e) {
                LOGGER.error(LogMarkers.CORE, "Failed to load a " + name + " library, expect problems", (Throwable)e);
            }
        }
        if (providers.isEmpty()) {
            LOGGER.error(LogMarkers.CORE, "Found no {} provider. Cannot run", (Object)name);
            throw new IncompatibleEnvironmentException("No " + name + " library found");
        }
        if (providers.size() > 1) {
            LOGGER.error(LogMarkers.CORE, "Found multiple {} providers: {}. Cannot run", (Object)name, providers.stream().map(p -> p.getClass().getName()).toList());
            throw new IncompatibleEnvironmentException("Multiple " + name + " libraries found");
        }
        return (T)providers.get(0);
    }

    static void setupLaunchHandler(IEnvironment environment, Map<String, Object> arguments) {
        String launchTarget = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.LAUNCHTARGET.get()).orElse("MISSING");
        arguments.put("launchTarget", launchTarget);
        Optional launchHandler = environment.findLaunchHandler(launchTarget);
        LOGGER.debug(LogMarkers.CORE, "Using {} as launch service", (Object)launchTarget);
        if (launchHandler.isEmpty()) {
            LOGGER.error(LogMarkers.CORE, "Missing LaunchHandler {}, cannot continue", (Object)launchTarget);
            throw new RuntimeException("Missing launch handler: " + launchTarget);
        }
        if (!(launchHandler.get() instanceof CommonLaunchHandler)) {
            LOGGER.error(LogMarkers.CORE, "Incompatible Launch handler found - type {}, cannot continue", (Object)((ILaunchHandlerService)launchHandler.get()).getClass().getName());
            throw new RuntimeException("Incompatible launch handler found");
        }
        commonLaunchHandler = (CommonLaunchHandler)launchHandler.get();
        launchHandlerName = ((ILaunchHandlerService)launchHandler.get()).name();
        gamePath = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElse(Path.of(".", new String[0]).toAbsolutePath());
        naming = commonLaunchHandler.getNaming();
        dist = commonLaunchHandler.getDist();
        production = commonLaunchHandler.isProduction();
        accessTransformer.getExtension().accept(Map.entry(naming, "srg"));
        runtimeDistCleaner.getExtension().accept(dist);
    }

    public static List<ITransformationService.Resource> beginModScan(Map<String, ?> arguments) {
        LOGGER.debug(LogMarkers.SCAN, "Scanning for Mod Locators");
        ModDiscoverer modDiscoverer = new ModDiscoverer(arguments);
        modValidator = modDiscoverer.discoverMods();
        ITransformationService.Resource pluginResources = modValidator.getPluginResources();
        return List.of(pluginResources);
    }

    public static List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        moduleLayerManager = layerManager;
        languageLoadingProvider = new LanguageLoadingProvider();
        backgroundScanHandler = modValidator.stage2Validation();
        loadingModList = backgroundScanHandler.getLoadingModList();
        return List.of(modValidator.getModResources());
    }

    public static ICoreModProvider getCoreModProvider() {
        return coreModProvider;
    }

    public static LanguageLoadingProvider getLanguageLoadingProvider() {
        return languageLoadingProvider;
    }

    public static CommonLaunchHandler getLaunchHandler() {
        return commonLaunchHandler;
    }

    public static void addAccessTransformer(Path atPath, ModFile modName) {
        LOGGER.debug(LogMarkers.SCAN, "Adding Access Transformer in {}", (Object)modName.getFilePath());
        accessTransformer.offerResource(atPath, modName.getFileName());
    }

    public static Dist getDist() {
        return dist;
    }

    public static void beforeStart(ModuleLayer gameLayer) {
        ImmediateWindowHandler.acceptGameLayer(gameLayer);
        ImmediateWindowHandler.updateProgress("Launching minecraft");
        progressWindowTick.run();
    }

    public static LoadingModList getLoadingModList() {
        return loadingModList;
    }

    public static Path getGamePath() {
        return gamePath;
    }

    public static String getNaming() {
        return naming;
    }

    public static Optional<BiFunction<INameMappingService.Domain, String, String>> getNameFunction(String naming) {
        return Launcher.INSTANCE.environment().findNameMapping(naming);
    }

    public static String getLauncherInfo() {
        return Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.MLIMPL_VERSION.get()).orElse("MISSING");
    }

    public static List<Map<String, String>> modLauncherModList() {
        return Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.MODLIST.get()).orElse(List.of());
    }

    public static String launcherHandlerName() {
        return launchHandlerName;
    }

    public static boolean isProduction() {
        return production;
    }

    public static boolean isSecureJarEnabled() {
        return true;
    }

    public static ModuleLayer getGameLayer() {
        return (ModuleLayer)moduleLayerManager.getLayer(IModuleLayerManager.Layer.GAME).orElseThrow();
    }

    public static VersionInfo versionInfo() {
        return versionInfo;
    }

    static {
        versionInfo = VersionInfo.detect();
    }
}

