/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class DefaultBlockInteractionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer $$0, BlockPos $$12) {
        ServerLevel $$2 = $$0.serverLevel();
        BlockState $$3 = $$2.getBlockState($$12);
        LootParams $$4 = new LootParams.Builder($$2).withParameter(LootContextParams.ORIGIN, $$12.getCenter()).withParameter(LootContextParams.THIS_ENTITY, $$0).withParameter(LootContextParams.BLOCK_STATE, $$3).create(LootContextParamSets.BLOCK_USE);
        LootContext $$5 = new LootContext.Builder($$4).create(Optional.empty());
        this.trigger($$0, (T $$1) -> $$1.matches($$5));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)$$0, TriggerInstance::new));

        public boolean matches(LootContext $$0) {
            return this.location.isEmpty() || this.location.get().matches($$0);
        }

        @Override
        public void validate(CriterionValidator $$0) {
            SimpleCriterionTrigger.SimpleInstance.super.validate($$0);
            this.location.ifPresent($$1 -> $$0.validate((ContextAwarePredicate)$$1, LootContextParamSets.BLOCK_USE, ".location"));
        }
    }
}

