/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.SpecialModels;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import net.minecraftforge.client.model.geometry.BlockGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BlockModel
implements UnbakedModel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    @VisibleForTesting
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private static final char REFERENCE_CHAR = '#';
    public static final String PARTICLE_TEXTURE_REFERENCE = "particle";
    private static final boolean DEFAULT_AMBIENT_OCCLUSION = true;
    public static final Material MISSING_MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());
    private final List<BlockElement> elements;
    @Nullable
    private final GuiLight guiLight;
    @Nullable
    public final Boolean hasAmbientOcclusion;
    private final ItemTransforms transforms;
    private final List<ItemOverride> overrides;
    public String name = "";
    @VisibleForTesting
    public final Map<String, Either<Material, String>> textureMap;
    @Nullable
    public BlockModel parent;
    @Nullable
    protected ResourceLocation parentLocation;
    public final BlockGeometryBakingContext customData = new BlockGeometryBakingContext(this);

    public static BlockModel fromStream(Reader p_111462_) {
        return GsonHelper.fromJson(ExtendedBlockModelDeserializer.INSTANCE, p_111462_, BlockModel.class);
    }

    public BlockModel(@Nullable ResourceLocation p_273263_, List<BlockElement> p_272668_, Map<String, Either<Material, String>> p_272821_, @Nullable Boolean p_272676_, @Nullable GuiLight p_273072_, ItemTransforms p_273480_, List<ItemOverride> p_273099_) {
        this.elements = p_272668_;
        this.hasAmbientOcclusion = p_272676_;
        this.guiLight = p_273072_;
        this.textureMap = p_272821_;
        this.parentLocation = p_273263_;
        this.transforms = p_273480_;
        this.overrides = p_273099_;
    }

    @Deprecated
    public List<BlockElement> getElements() {
        if (this.customData.hasCustomGeometry()) {
            return Collections.emptyList();
        }
        return this.elements.isEmpty() && this.parent != null ? this.parent.getElements() : this.elements;
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.parentLocation;
    }

    public boolean hasAmbientOcclusion() {
        if (this.hasAmbientOcclusion != null) {
            return this.hasAmbientOcclusion;
        }
        return this.parent != null ? this.parent.hasAmbientOcclusion() : true;
    }

    public GuiLight getGuiLight() {
        if (this.guiLight != null) {
            return this.guiLight;
        }
        return this.parent != null ? this.parent.getGuiLight() : GuiLight.SIDE;
    }

    public boolean isResolved() {
        return this.parentLocation == null || this.parent != null && this.parent.isResolved();
    }

    public List<ItemOverride> getOverrides() {
        return this.overrides;
    }

    public void resolveDependencies(UnbakedModel.Resolver p_365651_) {
        if (this.parentLocation != null) {
            UnbakedModel unbakedModel = p_365651_.resolve(this.parentLocation);
            if (!(unbakedModel instanceof BlockModel)) {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
            BlockModel blockmodel = (BlockModel)unbakedModel;
            if (this.customData.hasCustomGeometry()) {
                this.customData.getCustomGeometry().resolveDependencies(p_365651_, (IGeometryBakingContext)this.customData);
            }
            this.parent = blockmodel;
        }
    }

    public BakedModel bake(ModelBaker p_252120_, Function<Material, TextureAtlasSprite> p_250023_, ModelState p_251130_) {
        if (this.customData.getCustomGeometry() != null) {
            return this.customData.getCustomGeometry().bake((IGeometryBakingContext)this.customData, p_252120_, p_250023_, p_251130_);
        }
        return this.bake(p_250023_, p_251130_, true);
    }

    public BakedModel bake(Function<Material, TextureAtlasSprite> p_111452_, ModelState p_111453_, boolean p_111455_) {
        TextureAtlasSprite textureatlassprite = p_111452_.apply(this.getMaterial(PARTICLE_TEXTURE_REFERENCE));
        if (this.getRootModel() == SpecialModels.BLOCK_ENTITY_MARKER) {
            return new BuiltInModel(this.getTransforms(), textureatlassprite, this.getGuiLight().lightLikeBlock());
        }
        SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(this, p_111455_).particle(textureatlassprite);
        for (BlockElement blockelement : this.getElements()) {
            for (Direction direction : blockelement.faces.keySet()) {
                BlockElementFace blockelementface = (BlockElementFace)blockelement.faces.get(direction);
                TextureAtlasSprite textureatlassprite1 = p_111452_.apply(this.getMaterial(blockelementface.texture()));
                if (blockelementface.cullForDirection() == null) {
                    simplebakedmodel$builder.addUnculledFace(BlockModel.bakeFace(blockelement, blockelementface, textureatlassprite1, direction, p_111453_));
                    continue;
                }
                simplebakedmodel$builder.addCulledFace(Direction.rotate(p_111453_.getRotation().getMatrix(), blockelementface.cullForDirection()), BlockModel.bakeFace(blockelement, blockelementface, textureatlassprite1, direction, p_111453_));
            }
        }
        return simplebakedmodel$builder.build();
    }

    public static BakedQuad bakeFace(BlockElement p_111438_, BlockElementFace p_111439_, TextureAtlasSprite p_111440_, Direction p_111441_, ModelState p_111442_) {
        return FACE_BAKERY.bakeQuad(p_111438_.from, p_111438_.to, p_111439_, p_111440_, p_111441_, p_111442_, p_111438_.rotation, p_111438_.shade, p_111438_.lightEmission);
    }

    public boolean hasTexture(String p_111478_) {
        return !MissingTextureAtlasSprite.getLocation().equals(this.getMaterial(p_111478_).texture());
    }

    public Material getMaterial(String p_111481_) {
        if (BlockModel.isTextureReference(p_111481_)) {
            p_111481_ = p_111481_.substring(1);
        }
        ArrayList list = Lists.newArrayList();
        Either<Material, String> either;
        Optional optional;
        while (!(optional = (either = this.findTextureEntry(p_111481_)).left()).isPresent()) {
            p_111481_ = (String)either.right().get();
            if (list.contains(p_111481_)) {
                LOGGER.warn("Unable to resolve texture due to reference chain {}->{} in {}", new Object[]{Joiner.on((String)"->").join((Iterable)list), p_111481_, this.name});
                return MISSING_MATERIAL;
            }
            list.add(p_111481_);
        }
        return (Material)optional.get();
    }

    private Either<Material, String> findTextureEntry(String p_111486_) {
        BlockModel blockmodel = this;
        while (blockmodel != null) {
            Either<Material, String> either = blockmodel.textureMap.get(p_111486_);
            if (either != null) {
                return either;
            }
            blockmodel = blockmodel.parent;
        }
        return Either.left((Object)MISSING_MATERIAL);
    }

    static boolean isTextureReference(String p_111489_) {
        return p_111489_.charAt(0) == '#';
    }

    public BlockModel getRootModel() {
        return this.parent == null ? this : this.parent.getRootModel();
    }

    public ItemTransforms getTransforms() {
        ItemTransform itemtransform = this.getTransform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
        ItemTransform itemtransform1 = this.getTransform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
        ItemTransform itemtransform2 = this.getTransform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
        ItemTransform itemtransform3 = this.getTransform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
        ItemTransform itemtransform4 = this.getTransform(ItemDisplayContext.HEAD);
        ItemTransform itemtransform5 = this.getTransform(ItemDisplayContext.GUI);
        ItemTransform itemtransform6 = this.getTransform(ItemDisplayContext.GROUND);
        ItemTransform itemtransform7 = this.getTransform(ItemDisplayContext.FIXED);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemDisplayContext type : ItemDisplayContext.values()) {
            ItemTransform transform;
            if (!type.isModded() || (transform = this.getTransform(type)) == ItemTransform.NO_TRANSFORM) continue;
            builder.put((Object)type, (Object)transform);
        }
        return new ItemTransforms(itemtransform, itemtransform1, itemtransform2, itemtransform3, itemtransform4, itemtransform5, itemtransform6, itemtransform7, (ImmutableMap<ItemDisplayContext, ItemTransform>)builder.build());
    }

    private ItemTransform getTransform(ItemDisplayContext p_270662_) {
        return this.parent != null && !this.transforms.hasTransform(p_270662_) ? this.parent.getTransform(p_270662_) : this.transforms.getTransform(p_270662_);
    }

    public String toString() {
        return this.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum GuiLight {
        FRONT("front"),
        SIDE("side");

        private final String name;

        private GuiLight(String p_111525_) {
            this.name = p_111525_;
        }

        public static GuiLight getByName(String p_111528_) {
            for (GuiLight blockmodel$guilight : GuiLight.values()) {
                if (!blockmodel$guilight.name.equals(p_111528_)) continue;
                return blockmodel$guilight;
            }
            throw new IllegalArgumentException("Invalid gui light: " + p_111528_);
        }

        public boolean lightLikeBlock() {
            return this == SIDE;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        public BlockModel deserialize(JsonElement p_111498_, Type p_111499_, JsonDeserializationContext p_111500_) throws JsonParseException {
            JsonObject jsonobject = p_111498_.getAsJsonObject();
            List<BlockElement> list = this.getElements(p_111500_, jsonobject);
            String s = this.getParentName(jsonobject);
            Map<String, Either<Material, String>> map = this.getTextureMap(jsonobject);
            Boolean obool = this.getAmbientOcclusion(jsonobject);
            ItemTransforms itemtransforms = ItemTransforms.NO_TRANSFORMS;
            if (jsonobject.has("display")) {
                JsonObject jsonobject1 = GsonHelper.getAsJsonObject(jsonobject, "display");
                itemtransforms = (ItemTransforms)p_111500_.deserialize((JsonElement)jsonobject1, ItemTransforms.class);
            }
            List<ItemOverride> list1 = this.getOverrides(p_111500_, jsonobject);
            GuiLight blockmodel$guilight = null;
            if (jsonobject.has("gui_light")) {
                blockmodel$guilight = GuiLight.getByName(GsonHelper.getAsString(jsonobject, "gui_light"));
            }
            ResourceLocation resourcelocation = s.isEmpty() ? null : ResourceLocation.parse(s);
            return new BlockModel(resourcelocation, list, map, obool, blockmodel$guilight, itemtransforms, list1);
        }

        protected List<ItemOverride> getOverrides(JsonDeserializationContext p_111495_, JsonObject p_111496_) {
            ArrayList list = Lists.newArrayList();
            if (p_111496_.has("overrides")) {
                for (JsonElement jsonelement : GsonHelper.getAsJsonArray(p_111496_, "overrides")) {
                    list.add((ItemOverride)p_111495_.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        private Map<String, Either<Material, String>> getTextureMap(JsonObject p_111510_) {
            ResourceLocation resourcelocation = TextureAtlas.LOCATION_BLOCKS;
            HashMap map = Maps.newHashMap();
            if (p_111510_.has("textures")) {
                JsonObject jsonobject = GsonHelper.getAsJsonObject(p_111510_, "textures");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put((String)entry.getKey(), Deserializer.parseTextureLocationOrReference(resourcelocation, ((JsonElement)entry.getValue()).getAsString()));
                }
            }
            return map;
        }

        private static Either<Material, String> parseTextureLocationOrReference(ResourceLocation p_111504_, String p_111505_) {
            if (BlockModel.isTextureReference(p_111505_)) {
                return Either.right((Object)p_111505_.substring(1));
            }
            ResourceLocation resourcelocation = ResourceLocation.tryParse(p_111505_);
            if (resourcelocation == null) {
                throw new JsonParseException(p_111505_ + " is not valid resource location");
            }
            return Either.left((Object)new Material(p_111504_, resourcelocation));
        }

        private String getParentName(JsonObject p_111512_) {
            return GsonHelper.getAsString(p_111512_, "parent", "");
        }

        @Nullable
        protected Boolean getAmbientOcclusion(JsonObject p_273052_) {
            return p_273052_.has("ambientocclusion") ? Boolean.valueOf(GsonHelper.getAsBoolean(p_273052_, "ambientocclusion")) : null;
        }

        protected List<BlockElement> getElements(JsonDeserializationContext p_111507_, JsonObject p_111508_) {
            ArrayList list = Lists.newArrayList();
            if (p_111508_.has("elements")) {
                for (JsonElement jsonelement : GsonHelper.getAsJsonArray(p_111508_, "elements")) {
                    list.add((BlockElement)p_111507_.deserialize(jsonelement, BlockElement.class));
                }
            }
            return list;
        }
    }
}

