/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SpecialModels;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakery {
    public static final Material FIRE_0 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_0"));
    public static final Material FIRE_1 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_1"));
    public static final Material LAVA_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/lava_flow"));
    public static final Material WATER_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_flow"));
    public static final Material WATER_OVERLAY = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_overlay"));
    public static final Material BANNER_BASE = new Material(Sheets.BANNER_SHEET, ResourceLocation.withDefaultNamespace("entity/banner_base"));
    public static final Material SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base"));
    public static final Material NO_PATTERN_SHIELD = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base_nopattern"));
    public static final int DESTROY_STAGE_COUNT = 10;
    public static final List<ResourceLocation> DESTROY_STAGES = IntStream.range(0, 10).mapToObj(p_340955_ -> ResourceLocation.withDefaultNamespace("block/destroy_stage_" + p_340955_)).collect(Collectors.toList());
    public static final List<ResourceLocation> BREAKING_LOCATIONS = DESTROY_STAGES.stream().map(p_340960_ -> p_340960_.withPath(p_340956_ -> "textures/" + p_340956_ + ".png")).collect(Collectors.toList());
    public static final List<RenderType> DESTROY_TYPES = BREAKING_LOCATIONS.stream().map(RenderType::crumbling).collect(Collectors.toList());
    static final Logger LOGGER = LogUtils.getLogger();
    public static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    final Map<BakedCacheKey, BakedModel> bakedCache = new HashMap<BakedCacheKey, BakedModel>();
    private final Map<ModelResourceLocation, BakedModel> bakedTopLevelModels = new HashMap<ModelResourceLocation, BakedModel>();
    private final Map<ModelResourceLocation, UnbakedModel> topModels;
    final Map<ResourceLocation, UnbakedModel> unbakedModels;
    final UnbakedModel missingModel;

    public ModelBakery(Map<ModelResourceLocation, UnbakedModel> p_251087_, Map<ResourceLocation, UnbakedModel> p_250416_, UnbakedModel p_361482_) {
        this.topModels = p_251087_;
        this.unbakedModels = p_250416_;
        this.missingModel = p_361482_;
    }

    public void bakeModels(TextureGetter p_343407_) {
        this.topModels.forEach((p_340958_, p_340959_) -> {
            BakedModel bakedmodel = null;
            try {
                bakedmodel = new ModelBakerImpl(p_343407_, (ModelResourceLocation)p_340958_).bakeUncached((UnbakedModel)p_340959_, (ModelState)BlockModelRotation.X0_Y0);
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to bake model: '{}': {}", p_340958_, (Object)exception);
            }
            if (bakedmodel != null) {
                this.bakedTopLevelModels.put((ModelResourceLocation)p_340958_, bakedmodel);
            }
        });
    }

    public Map<ModelResourceLocation, BakedModel> getBakedTopLevelModels() {
        return this.bakedTopLevelModels;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface TextureGetter {
        public TextureAtlasSprite get(ModelResourceLocation var1, Material var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    class ModelBakerImpl
    implements ModelBaker {
        private final Function<Material, TextureAtlasSprite> modelTextureGetter = p_340963_ -> p_342310_.get(p_344289_, (Material)p_340963_);

        ModelBakerImpl(TextureGetter p_342310_, ModelResourceLocation p_344289_) {
        }

        private UnbakedModel getModel(ResourceLocation p_248568_) {
            UnbakedModel unbakedmodel = ModelBakery.this.unbakedModels.get(p_248568_);
            if (unbakedmodel == null) {
                LOGGER.warn("Requested a model that was not discovered previously: {}", (Object)p_248568_);
                return ModelBakery.this.missingModel;
            }
            return unbakedmodel;
        }

        public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
            return this.modelTextureGetter;
        }

        @Override
        public BakedModel bake(ResourceLocation p_252176_, ModelState p_249765_) {
            return this.bake(p_252176_, p_249765_, this.modelTextureGetter);
        }

        public BakedModel bake(ResourceLocation p_252176_, ModelState p_249765_, Function<Material, TextureAtlasSprite> sprites) {
            BakedCacheKey modelbakery$bakedcachekey = new BakedCacheKey(p_252176_, p_249765_.getRotation(), p_249765_.isUvLocked());
            BakedModel bakedmodel = ModelBakery.this.bakedCache.get(modelbakery$bakedcachekey);
            if (bakedmodel != null) {
                return bakedmodel;
            }
            UnbakedModel unbakedmodel = this.getModel(p_252176_);
            BakedModel bakedmodel1 = this.bakeUncached(unbakedmodel, p_249765_, sprites);
            ModelBakery.this.bakedCache.put(modelbakery$bakedcachekey, bakedmodel1);
            return bakedmodel1;
        }

        BakedModel bakeUncached(UnbakedModel p_343761_, ModelState p_342939_) {
            return this.bakeUncached(p_343761_, p_342939_, this.modelTextureGetter);
        }

        BakedModel bakeUncached(UnbakedModel p_343761_, ModelState p_342939_, Function<Material, TextureAtlasSprite> sprites) {
            BlockModel blockmodel;
            if (p_343761_ instanceof BlockModel && (blockmodel = (BlockModel)p_343761_).getRootModel() == SpecialModels.GENERATED_MARKER) {
                return ITEM_MODEL_GENERATOR.generateBlockModel(sprites, blockmodel).bake(sprites, p_342939_, false);
            }
            return p_343761_.bake((ModelBaker)this, sprites, p_342939_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record BakedCacheKey(ResourceLocation id, Transformation transformation, boolean isUvLocked) {
    }
}

