/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<RegistryStub<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.RegistryLookup<T> p_255625_) {
        return new EmptyTagLookup<T>(p_255625_){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255765_) {
                return p_255625_.get(p_255765_);
            }
        };
    }

    static <T> HolderLookup.RegistryLookup<T> lookupFromMap(final ResourceKey<? extends Registry<? extends T>> p_311196_, final Lifecycle p_311352_, HolderOwner<T> p_335968_, final Map<ResourceKey<T>, Holder.Reference<T>> p_311458_) {
        return new EmptyTagRegistryLookup<T>(p_335968_){

            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return p_311196_;
            }

            @Override
            public Lifecycle registryLifecycle() {
                return p_311352_;
            }

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_310975_) {
                return Optional.ofNullable((Holder.Reference)p_311458_.get(p_310975_));
            }

            @Override
            public Stream<Holder.Reference<T>> listElements() {
                return p_311458_.values().stream();
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> p_256446_, Lifecycle p_256394_, RegistryBootstrap<T> p_256638_) {
        this.entries.add(new RegistryStub<T>(p_256446_, p_256394_, p_256638_));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> p_256261_, RegistryBootstrap<T> p_256010_) {
        return this.add(p_256261_, Lifecycle.stable(), p_256010_);
    }

    public List<? extends ResourceKey<? extends Registry<?>>> getEntryKeys() {
        return this.entries.stream().map(RegistryStub::key).toList();
    }

    private BuildState createState(RegistryAccess p_256400_) {
        BuildState registrysetbuilder$buildstate = BuildState.create(p_256400_, this.entries.stream().map(RegistryStub::key));
        this.entries.forEach(p_255629_ -> p_255629_.apply(registrysetbuilder$buildstate));
        return registrysetbuilder$buildstate;
    }

    private static HolderLookup.Provider buildProviderWithContext(UniversalOwner p_328219_, RegistryAccess p_311176_, Stream<HolderLookup.RegistryLookup<?>> p_311668_) {
        record Entry<T>(HolderLookup.RegistryLookup<T> lookup, RegistryOps.RegistryInfo<T> opsInfo) {
            public static <T> Entry<T> createForContextRegistry(HolderLookup.RegistryLookup<T> p_332859_) {
                return new Entry<T>(new EmptyTagLookupWrapper<T>(p_332859_, p_332859_), RegistryOps.RegistryInfo.fromRegistryLookup(p_332859_));
            }

            public static <T> Entry<T> createForNewRegistry(UniversalOwner p_329338_, HolderLookup.RegistryLookup<T> p_334381_) {
                return new Entry(new EmptyTagLookupWrapper(p_329338_.cast(), p_334381_), new RegistryOps.RegistryInfo(p_329338_.cast(), p_334381_, p_334381_.registryLifecycle()));
            }
        }
        final HashMap map = new HashMap();
        p_311176_.registries().forEach(p_358096_ -> map.put(p_358096_.key(), Entry.createForContextRegistry(p_358096_.value())));
        p_311668_.forEach(p_325692_ -> map.put(p_325692_.key(), Entry.createForNewRegistry(p_328219_, p_325692_)));
        return new HolderLookup.Provider(){

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return map.keySet().stream();
            }

            <T> Optional<Entry<T>> getEntry(ResourceKey<? extends Registry<? extends T>> p_332279_) {
                return Optional.ofNullable((Entry)map.get(p_332279_));
            }

            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_328757_) {
                return this.getEntry(p_328757_).map(Entry::lookup);
            }

            @Override
            public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> p_334886_) {
                return RegistryOps.create(p_334886_, new RegistryOps.RegistryInfoLookup(){

                    @Override
                    public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_331561_) {
                        return this.getEntry(p_331561_).map(Entry::opsInfo);
                    }
                });
            }
        };
    }

    public HolderLookup.Provider build(RegistryAccess p_256112_) {
        BuildState registrysetbuilder$buildstate = this.createState(p_256112_);
        Stream<HolderLookup.RegistryLookup<?>> stream = this.entries.stream().map(p_325689_ -> p_325689_.collectRegisteredValues(registrysetbuilder$buildstate).buildAsLookup(registrysetbuilder$buildstate.owner));
        HolderLookup.Provider holderlookup$provider = RegistrySetBuilder.buildProviderWithContext(registrysetbuilder$buildstate.owner, p_256112_, stream);
        registrysetbuilder$buildstate.reportNotCollectedHolders();
        registrysetbuilder$buildstate.reportUnclaimedRegisteredValues();
        registrysetbuilder$buildstate.throwOnError();
        return holderlookup$provider;
    }

    private HolderLookup.Provider createLazyFullPatchedRegistries(RegistryAccess p_312999_, HolderLookup.Provider p_309815_, Cloner.Factory p_311992_, Map<ResourceKey<? extends Registry<?>>, RegistryContents<?>> p_309672_, HolderLookup.Provider p_312434_) {
        UniversalOwner registrysetbuilder$universalowner = new UniversalOwner();
        MutableObject mutableobject = new MutableObject();
        List list = p_309672_.keySet().stream().map(p_308443_ -> this.createLazyFullPatchedRegistries(registrysetbuilder$universalowner, p_311992_, (ResourceKey)p_308443_, p_312434_, p_309815_, (MutableObject<HolderLookup.Provider>)mutableobject)).collect(Collectors.toUnmodifiableList());
        HolderLookup.Provider holderlookup$provider = RegistrySetBuilder.buildProviderWithContext(registrysetbuilder$universalowner, p_312999_, list.stream());
        mutableobject.setValue((Object)holderlookup$provider);
        return holderlookup$provider;
    }

    private <T> HolderLookup.RegistryLookup<T> createLazyFullPatchedRegistries(HolderOwner<T> p_312548_, Cloner.Factory p_312934_, ResourceKey<? extends Registry<? extends T>> p_313093_, HolderLookup.Provider p_311682_, HolderLookup.Provider p_313198_, MutableObject<HolderLookup.Provider> p_311605_) {
        Cloner cloner = p_312934_.cloner(p_313093_);
        if (cloner == null) {
            throw new NullPointerException("No cloner for " + String.valueOf(p_313093_.location()));
        }
        HashMap map = new HashMap();
        HolderLookup.RegistryLookup registrylookup = p_311682_.lookup(p_313093_).orElse(null);
        registrylookup.listElements().forEach(p_308453_ -> {
            ResourceKey resourcekey = p_308453_.key();
            LazyHolder lazyholder = new LazyHolder(p_312548_, resourcekey);
            lazyholder.supplier = () -> cloner.clone(p_308453_.value(), p_311682_, (HolderLookup.Provider)p_311605_.getValue());
            map.put(resourcekey, lazyholder);
        });
        HolderLookup.RegistryLookup registrylookup1 = p_313198_.lookup(p_313093_).orElse(null);
        Lifecycle lifecycle = registrylookup.registryLifecycle();
        if (registrylookup1 != null) {
            registrylookup1.listElements().forEach(p_308430_ -> {
                ResourceKey resourcekey = p_308430_.key();
                map.computeIfAbsent(resourcekey, p_308437_ -> {
                    LazyHolder lazyholder = new LazyHolder(p_312548_, resourcekey);
                    lazyholder.supplier = () -> cloner.clone(p_308430_.value(), p_313198_, (HolderLookup.Provider)p_311605_.getValue());
                    return lazyholder;
                });
            });
            lifecycle = registrylookup.registryLifecycle().add(registrylookup1.registryLifecycle());
        }
        return RegistrySetBuilder.lookupFromMap(p_313093_, lifecycle, p_312548_, map);
    }

    public PatchedRegistries buildPatch(RegistryAccess p_255676_, HolderLookup.Provider p_255900_, Cloner.Factory p_310265_) {
        BuildState registrysetbuilder$buildstate = this.createState(p_255676_);
        HashMap map = new HashMap();
        this.entries.stream().map(p_308447_ -> p_308447_.collectRegisteredValues(registrysetbuilder$buildstate)).forEach(p_272339_ -> map.put((ResourceKey<Registry<?>>)p_272339_.key, (RegistryContents<?>)p_272339_));
        Set set = p_255676_.listRegistryKeys().collect(Collectors.toUnmodifiableSet());
        p_255900_.listRegistryKeys().filter(p_308455_ -> !set.contains(p_308455_)).forEach(p_308463_ -> map.putIfAbsent((ResourceKey<Registry<?>>)p_308463_, new RegistryContents(p_308463_, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.RegistryLookup<?>> stream = map.values().stream().map(p_325694_ -> p_325694_.buildAsLookup(registrysetbuilder$buildstate.owner));
        HolderLookup.Provider holderlookup$provider = RegistrySetBuilder.buildProviderWithContext(registrysetbuilder$buildstate.owner, p_255676_, stream);
        registrysetbuilder$buildstate.reportUnclaimedRegisteredValues();
        registrysetbuilder$buildstate.throwOnError();
        HolderLookup.Provider holderlookup$provider1 = this.createLazyFullPatchedRegistries(p_255676_, p_255900_, p_310265_, map, holderlookup$provider);
        return new PatchedRegistries(holderlookup$provider1, holderlookup$provider);
    }

    record RegistryStub<T>(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, RegistryBootstrap<T> bootstrap) {
        void apply(BuildState p_256272_) {
            this.bootstrap.run(p_256272_.bootstrapContext());
        }

        public RegistryContents<T> collectRegisteredValues(BuildState p_256416_) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, RegisteredValue<?>>> iterator = p_256416_.registeredValues.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, RegisteredValue<?>> entry = iterator.next();
                ResourceKey<?> resourcekey = entry.getKey();
                if (!resourcekey.isFor(this.key)) continue;
                RegisteredValue<?> registeredvalue = entry.getValue();
                Holder.Reference<Object> reference = p_256416_.lookup.holders.remove(resourcekey);
                map.put(resourcekey, new ValueAndHolder(registeredvalue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new RegistryContents(this.key, this.lifecycle, map);
        }
    }

    @FunctionalInterface
    public static interface RegistryBootstrap<T> {
        public void run(BootstrapContext<T> var1);
    }

    record BuildState(UniversalOwner owner, UniversalLookup lookup, Map<ResourceLocation, HolderGetter<?>> registries, Map<ResourceKey<?>, RegisteredValue<?>> registeredValues, List<RuntimeException> errors) {
        public static BuildState create(RegistryAccess p_255995_, Stream<ResourceKey<? extends Registry<?>>> p_256495_) {
            UniversalOwner registrysetbuilder$universalowner = new UniversalOwner();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            UniversalLookup registrysetbuilder$universallookup = new UniversalLookup(registrysetbuilder$universalowner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            p_255995_.registries().forEach(p_358098_ -> builder.put((Object)p_358098_.key().location(), RegistrySetBuilder.wrapContextLookup(p_358098_.value())));
            p_256495_.forEach(p_256603_ -> builder.put((Object)p_256603_.location(), (Object)registrysetbuilder$universallookup));
            return new BuildState(registrysetbuilder$universalowner, registrysetbuilder$universallookup, (Map<ResourceLocation, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstrapContext<T> bootstrapContext() {
            return new BootstrapContext<T>(){

                @Override
                public Holder.Reference<T> register(ResourceKey<T> p_256176_, T p_256422_, Lifecycle p_255924_) {
                    RegisteredValue registeredvalue = registeredValues.put(p_256176_, new RegisteredValue(p_256422_, p_255924_));
                    if (registeredvalue != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + String.valueOf(p_256176_) + ", new=" + String.valueOf(p_256422_) + ", old=" + String.valueOf(registeredvalue.value)));
                    }
                    return lookup.getOrCreate(p_256176_);
                }

                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> p_255961_) {
                    return registries.getOrDefault(p_255961_.location(), lookup);
                }

                @Override
                public <S> Optional<HolderLookup.RegistryLookup<S>> registryLookup(ResourceKey<? extends Registry<? extends S>> registry) {
                    return Optional.ofNullable((HolderLookup.RegistryLookup)registries.get(registry.location()));
                }
            };
        }

        public void reportUnclaimedRegisteredValues() {
            this.registeredValues.forEach((p_325695_, p_325696_) -> this.errors.add(new IllegalStateException("Orpaned value " + String.valueOf(p_325696_.value) + " for key " + String.valueOf(p_325695_))));
        }

        public void reportNotCollectedHolders() {
            for (ResourceKey<Object> resourcekey : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + String.valueOf(resourcekey)));
            }
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException illegalstateexception = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeexception : this.errors) {
                    illegalstateexception.addSuppressed(runtimeexception);
                }
                throw illegalstateexception;
            }
        }
    }

    static class UniversalOwner
    implements HolderOwner<Object> {
        UniversalOwner() {
        }

        public <T> HolderOwner<T> cast() {
            return this;
        }
    }

    public record PatchedRegistries(HolderLookup.Provider full, HolderLookup.Provider patches) {
    }

    record RegistryContents<T>(ResourceKey<? extends Registry<? extends T>> key, Lifecycle lifecycle, Map<ResourceKey<T>, ValueAndHolder<T>> values) {
        public HolderLookup.RegistryLookup<T> buildAsLookup(UniversalOwner p_333021_) {
            Map map = this.values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, p_311794_ -> {
                ValueAndHolder valueandholder = (ValueAndHolder)p_311794_.getValue();
                Holder.Reference reference = valueandholder.holder().orElseGet(() -> Holder.Reference.createStandAlone(p_333021_.cast(), (ResourceKey)p_311794_.getKey()));
                reference.bindValue(valueandholder.value().value());
                return reference;
            }));
            return RegistrySetBuilder.lookupFromMap(this.key, this.lifecycle, p_333021_.cast(), map);
        }
    }

    static class LazyHolder<T>
    extends Holder.Reference<T> {
        @Nullable
        Supplier<T> supplier;

        protected LazyHolder(HolderOwner<T> p_311720_, @Nullable ResourceKey<T> p_312254_) {
            super(Holder.Reference.Type.STAND_ALONE, p_311720_, p_312254_, null);
        }

        @Override
        public void bindValue(T p_309503_) {
            super.bindValue(p_309503_);
            this.supplier = null;
        }

        @Override
        public T value() {
            if (this.supplier != null) {
                this.bindValue(this.supplier.get());
            }
            return super.value();
        }
    }

    record ValueAndHolder<T>(RegisteredValue<T> value, Optional<Holder.Reference<T>> holder) {
    }

    static class UniversalLookup
    extends EmptyTagLookup<Object> {
        final Map<ResourceKey<Object>, Holder.Reference<Object>> holders = new HashMap<ResourceKey<Object>, Holder.Reference<Object>>();

        public UniversalLookup(HolderOwner<Object> p_256629_) {
            super(p_256629_);
        }

        @Override
        public Optional<Holder.Reference<Object>> get(ResourceKey<Object> p_256303_) {
            return Optional.of(this.getOrCreate(p_256303_));
        }

        <T> Holder.Reference<T> getOrCreate(ResourceKey<T> p_256298_) {
            return (Holder.Reference)this.holders.computeIfAbsent(p_256298_, p_256154_ -> Holder.Reference.createStandAlone(this.owner, (ResourceKey)p_256154_));
        }
    }

    record RegisteredValue<T>(T value, Lifecycle lifecycle) {
    }

    static abstract class EmptyTagRegistryLookup<T>
    extends EmptyTagLookup<T>
    implements HolderLookup.RegistryLookup<T> {
        protected EmptyTagRegistryLookup(HolderOwner<T> p_334522_) {
            super(p_334522_);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            throw new UnsupportedOperationException("Tags are not available in datagen");
        }
    }

    static class EmptyTagLookupWrapper<T>
    extends EmptyTagRegistryLookup<T>
    implements HolderLookup.RegistryLookup.Delegate<T> {
        private final HolderLookup.RegistryLookup<T> parent;

        EmptyTagLookupWrapper(HolderOwner<T> p_327736_, HolderLookup.RegistryLookup<T> p_328715_) {
            super(p_327736_);
            this.parent = p_328715_;
        }

        @Override
        public HolderLookup.RegistryLookup<T> parent() {
            return this.parent;
        }
    }

    static abstract class EmptyTagLookup<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected EmptyTagLookup(HolderOwner<T> p_256166_) {
            this.owner = p_256166_;
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> p_256664_) {
            return Optional.of(HolderSet.emptyNamed(this.owner, p_256664_));
        }
    }
}

