/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;

public abstract class PackDetector<T> {
    private final DirectoryValidator validator;

    protected PackDetector(DirectoryValidator p_300595_) {
        this.validator = p_300595_;
    }

    @Nullable
    public T detectPackResources(Path p_298083_, List<ForbiddenSymlinkInfo> p_297322_) throws IOException {
        return this.detectPackResources(p_298083_, p_297322_, true);
    }

    @Nullable
    public T detectPackResources(Path p_298083_, List<ForbiddenSymlinkInfo> p_297322_, boolean requireMeta) throws IOException {
        BasicFileAttributes basicfileattributes;
        Path path = p_298083_;
        try {
            basicfileattributes = Files.readAttributes(p_298083_, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (NoSuchFileException nosuchfileexception) {
            return null;
        }
        if (basicfileattributes.isSymbolicLink()) {
            this.validator.validateSymlink(p_298083_, p_297322_);
            if (!p_297322_.isEmpty()) {
                return null;
            }
            path = Files.readSymbolicLink(p_298083_);
            basicfileattributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        if (basicfileattributes.isDirectory()) {
            this.validator.validateKnownDirectory(path, p_297322_);
            if (!p_297322_.isEmpty()) {
                return null;
            }
            return !Files.isRegularFile(path.resolve("pack.mcmeta"), new LinkOption[0]) && requireMeta ? null : (T)this.createDirectoryPack(path);
        }
        String name = path.getFileName().toString();
        return basicfileattributes.isRegularFile() && (name.endsWith(".zip") || name.endsWith(".jar")) ? (T)this.createZipPack(path) : null;
    }

    @Nullable
    protected abstract T createZipPack(Path var1) throws IOException;

    @Nullable
    protected abstract T createDirectoryPack(Path var1) throws IOException;
}

