/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;

public abstract class SimpleJsonResourceReloadListener<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DynamicOps<JsonElement> ops;
    private final Codec<T> codec;
    private final String directory;

    protected SimpleJsonResourceReloadListener(HolderLookup.Provider p_368426_, Codec<T> p_362926_, String p_364031_) {
        this(p_368426_.createSerializationContext(JsonOps.INSTANCE), p_362926_, p_364031_);
    }

    protected SimpleJsonResourceReloadListener(Codec<T> p_370137_, String p_10769_) {
        this((DynamicOps<JsonElement>)JsonOps.INSTANCE, p_370137_, p_10769_);
    }

    protected SimpleJsonResourceReloadListener(DynamicOps<JsonElement> p_362832_, Codec<T> p_361980_, String p_361491_) {
        this.ops = p_362832_;
        this.codec = p_361980_;
        this.directory = p_361491_;
    }

    @Override
    protected Map<ResourceLocation, T> prepare(ResourceManager p_10771_, ProfilerFiller p_10772_) {
        HashMap map = new HashMap();
        SimpleJsonResourceReloadListener.scanDirectory(p_10771_, this.directory, this.ops, this.codec, map);
        return map;
    }

    public static <T> void scanDirectory(ResourceManager p_279308_, String p_279131_, DynamicOps<JsonElement> p_369854_, Codec<T> p_368755_, Map<ResourceLocation, T> p_279404_) {
        FileToIdConverter filetoidconverter = FileToIdConverter.json(p_279131_);
        for (Map.Entry<ResourceLocation, Resource> entry : filetoidconverter.listMatchingResources(p_279308_).entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            ResourceLocation resourcelocation1 = filetoidconverter.fileToId(resourcelocation);
            try {
                BufferedReader reader = entry.getValue().openAsReader();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    json = ForgeHooks.readConditional(p_369854_, (JsonElement)json);
                    if (json == null) {
                        LOGGER.debug("Skipping loading {} as its conditions were not met", (Object)resourcelocation);
                        continue;
                    }
                    p_368755_.parse(p_369854_, (Object)json).ifSuccess(p_370131_ -> {
                        if ((p_370131_ = ForgeHooks.onJsonDataParsed((Codec)p_368755_, (ResourceLocation)resourcelocation1, (Object)p_370131_)) == null) {
                            return;
                        }
                        if (p_279404_.putIfAbsent(resourcelocation1, p_370131_) != null) {
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourcelocation1));
                        }
                    }).ifError(p_362245_ -> LOGGER.error("Couldn't parse data file '{}' from '{}': {}", new Object[]{resourcelocation1, resourcelocation, p_362245_}));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Couldn't parse data file '{}' from '{}'", new Object[]{resourcelocation1, resourcelocation, jsonparseexception});
            }
        }
    }

    protected ResourceLocation getPreparedPath(ResourceLocation rl) {
        return rl.withPath(this.directory + "/" + rl.getPath() + ".json");
    }
}

