/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface Container
extends Clearable {
    public static final float DEFAULT_DISTANCE_BUFFER = 4.0f;

    public int getContainerSize();

    public boolean isEmpty();

    public ItemStack getItem(int var1);

    public ItemStack removeItem(int var1, int var2);

    public ItemStack removeItemNoUpdate(int var1);

    public void setItem(int var1, ItemStack var2);

    default public int getMaxStackSize() {
        return 99;
    }

    default public int getMaxStackSize(ItemStack $$0) {
        return Math.min(this.getMaxStackSize(), $$0.getMaxStackSize());
    }

    public void setChanged();

    public boolean stillValid(Player var1);

    default public void startOpen(Player $$0) {
    }

    default public void stopOpen(Player $$0) {
    }

    default public boolean canPlaceItem(int $$0, ItemStack $$1) {
        return true;
    }

    default public boolean canTakeItem(Container $$0, int $$1, ItemStack $$2) {
        return true;
    }

    default public int countItem(Item $$0) {
        int $$1 = 0;
        for (int $$2 = 0; $$2 < this.getContainerSize(); ++$$2) {
            ItemStack $$3 = this.getItem($$2);
            if (!$$3.getItem().equals($$0)) continue;
            $$1 += $$3.getCount();
        }
        return $$1;
    }

    default public boolean hasAnyOf(Set<Item> $$0) {
        return this.hasAnyMatching($$1 -> !$$1.isEmpty() && $$0.contains($$1.getItem()));
    }

    default public boolean hasAnyMatching(Predicate<ItemStack> $$0) {
        for (int $$1 = 0; $$1 < this.getContainerSize(); ++$$1) {
            ItemStack $$2 = this.getItem($$1);
            if (!$$0.test($$2)) continue;
            return true;
        }
        return false;
    }

    public static boolean stillValidBlockEntity(BlockEntity $$0, Player $$1) {
        return Container.stillValidBlockEntity($$0, $$1, 4.0f);
    }

    public static boolean stillValidBlockEntity(BlockEntity $$0, Player $$1, float $$2) {
        Level $$3 = $$0.getLevel();
        BlockPos $$4 = $$0.getBlockPos();
        if ($$3 == null) {
            return false;
        }
        if ($$3.getBlockEntity($$4) != $$0) {
            return false;
        }
        return $$1.canInteractWithBlock($$4, $$2);
    }
}

