/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class Interaction
extends Entity
implements Attackable,
Targeting {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Float> DATA_WIDTH_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_RESPONSE_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.BOOLEAN);
    private static final String TAG_WIDTH = "width";
    private static final String TAG_HEIGHT = "height";
    private static final String TAG_ATTACK = "attack";
    private static final String TAG_INTERACTION = "interaction";
    private static final String TAG_RESPONSE = "response";
    @Nullable
    private PlayerAction attack;
    @Nullable
    private PlayerAction interaction;

    public Interaction(EntityType<?> $$0, Level $$1) {
        super($$0, $$1);
        this.noPhysics = true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder $$0) {
        $$0.define(DATA_WIDTH_ID, Float.valueOf(1.0f));
        $$0.define(DATA_HEIGHT_ID, Float.valueOf(1.0f));
        $$0.define(DATA_RESPONSE_ID, false);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag $$02) {
        if ($$02.contains(TAG_WIDTH, 99)) {
            this.setWidth($$02.getFloat(TAG_WIDTH));
        }
        if ($$02.contains(TAG_HEIGHT, 99)) {
            this.setHeight($$02.getFloat(TAG_HEIGHT));
        }
        if ($$02.contains(TAG_ATTACK)) {
            PlayerAction.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)$$02.get(TAG_ATTACK)).resultOrPartial(Util.prefix("Interaction entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent($$0 -> {
                this.attack = (PlayerAction)$$0.getFirst();
            });
        } else {
            this.attack = null;
        }
        if ($$02.contains(TAG_INTERACTION)) {
            PlayerAction.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)$$02.get(TAG_INTERACTION)).resultOrPartial(Util.prefix("Interaction entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent($$0 -> {
                this.interaction = (PlayerAction)$$0.getFirst();
            });
        } else {
            this.interaction = null;
        }
        this.setResponse($$02.getBoolean(TAG_RESPONSE));
        this.setBoundingBox(this.makeBoundingBox());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag $$0) {
        $$0.putFloat(TAG_WIDTH, this.getWidth());
        $$0.putFloat(TAG_HEIGHT, this.getHeight());
        if (this.attack != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.attack).ifSuccess($$1 -> $$0.put(TAG_ATTACK, (Tag)$$1));
        }
        if (this.interaction != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.interaction).ifSuccess($$1 -> $$0.put(TAG_INTERACTION, (Tag)$$1));
        }
        $$0.putBoolean(TAG_RESPONSE, this.getResponse());
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> $$0) {
        super.onSyncedDataUpdated($$0);
        if (DATA_HEIGHT_ID.equals($$0) || DATA_WIDTH_ID.equals($$0)) {
            this.refreshDimensions();
        }
    }

    @Override
    public boolean canBeHitByProjectile() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity $$0) {
        if ($$0 instanceof Player) {
            Player $$1 = (Player)$$0;
            this.attack = new PlayerAction($$1.getUUID(), this.level().getGameTime());
            if ($$1 instanceof ServerPlayer) {
                ServerPlayer $$2 = (ServerPlayer)$$1;
                CriteriaTriggers.PLAYER_HURT_ENTITY.trigger($$2, this, $$1.damageSources().generic(), 1.0f, 1.0f, false);
            }
            return !this.getResponse();
        }
        return false;
    }

    @Override
    public final boolean hurtServer(ServerLevel $$0, DamageSource $$1, float $$2) {
        return false;
    }

    @Override
    public InteractionResult interact(Player $$0, InteractionHand $$1) {
        if (this.level().isClientSide) {
            return this.getResponse() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        this.interaction = new PlayerAction($$0.getUUID(), this.level().getGameTime());
        return InteractionResult.CONSUME;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nullable
    public LivingEntity getLastAttacker() {
        if (this.attack != null) {
            return this.level().getPlayerByUUID(this.attack.player());
        }
        return null;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        if (this.interaction != null) {
            return this.level().getPlayerByUUID(this.interaction.player());
        }
        return null;
    }

    private void setWidth(float $$0) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf($$0));
    }

    private float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    private void setHeight(float $$0) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf($$0));
    }

    private float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    private void setResponse(boolean $$0) {
        this.entityData.set(DATA_RESPONSE_ID, $$0);
    }

    private boolean getResponse() {
        return this.entityData.get(DATA_RESPONSE_ID);
    }

    private EntityDimensions getDimensions() {
        return EntityDimensions.scalable(this.getWidth(), this.getHeight());
    }

    @Override
    public EntityDimensions getDimensions(Pose $$0) {
        return this.getDimensions();
    }

    @Override
    protected AABB makeBoundingBox() {
        return this.getDimensions().makeBoundingBox(this.position());
    }

    record PlayerAction(UUID player, long timestamp) {
        public static final Codec<PlayerAction> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)UUIDUtil.CODEC.fieldOf("player").forGetter(PlayerAction::player), (App)Codec.LONG.fieldOf("timestamp").forGetter(PlayerAction::timestamp)).apply((Applicative)$$0, PlayerAction::new));
    }
}

