/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;

public class RecipeManager
extends SimplePreparableReloadListener<RecipeMap>
implements RecipeAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceKey<RecipePropertySet>, IngredientExtractor> RECIPE_PROPERTY_SETS = Map.of(RecipePropertySet.SMITHING_ADDITION, p_359832_ -> {
        Optional<Object> optional;
        if (p_359832_ instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)p_359832_;
            optional = smithingrecipe.additionIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_BASE, p_359827_ -> {
        Optional<Object> optional;
        if (p_359827_ instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)p_359827_;
            optional = smithingrecipe.baseIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_TEMPLATE, p_359833_ -> {
        Optional<Object> optional;
        if (p_359833_ instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)p_359833_;
            optional = smithingrecipe.templateIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.SMELTING), RecipePropertySet.BLAST_FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.BLASTING), RecipePropertySet.SMOKER_INPUT, RecipeManager.forSingleInput(RecipeType.SMOKING), RecipePropertySet.CAMPFIRE_INPUT, RecipeManager.forSingleInput(RecipeType.CAMPFIRE_COOKING));
    private final HolderLookup.Provider registries;
    private RecipeMap recipes = RecipeMap.EMPTY;
    private Map<ResourceKey<RecipePropertySet>, RecipePropertySet> propertySets = Map.of();
    private SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes = SelectableRecipe.SingleInputSet.empty();
    private List<ServerDisplayInfo> allDisplays = List.of();
    private Map<ResourceKey<Recipe<?>>, List<ServerDisplayInfo>> recipeToDisplay = Map.of();
    private final ICondition.IContext context;

    public RecipeManager(HolderLookup.Provider p_330459_) {
        this(p_330459_, ICondition.IContext.EMPTY);
    }

    public RecipeManager(HolderLookup.Provider p_330459_, ICondition.IContext context) {
        this.registries = p_330459_;
        this.context = context;
    }

    @Override
    protected RecipeMap prepare(ResourceManager p_368640_, ProfilerFiller p_361102_) {
        TreeMap<ResourceLocation, Recipe> sortedmap = new TreeMap<ResourceLocation, Recipe>();
        SimpleJsonResourceReloadListener.scanDirectory(p_368640_, Registries.elementsDirPath(Registries.RECIPE), (DynamicOps<JsonElement>)((DynamicOps)this.registries.createSerializationContext(JsonOps.INSTANCE).withContext(ICondition.IContext.KEY, this.context)), Recipe.CODEC, sortedmap);
        ArrayList list = new ArrayList(sortedmap.size());
        sortedmap.forEach((p_359835_, p_359836_) -> {
            ResourceKey<Recipe<?>> resourcekey = ResourceKey.create(Registries.RECIPE, p_359835_);
            RecipeHolder<Recipe> recipeholder = new RecipeHolder<Recipe>(resourcekey, (Recipe)p_359836_);
            list.add(recipeholder);
        });
        return RecipeMap.create(list);
    }

    @Override
    protected void apply(RecipeMap p_369166_, ResourceManager p_44038_, ProfilerFiller p_44039_) {
        this.recipes = p_369166_;
        LOGGER.info("Loaded {} recipes", (Object)p_369166_.values().size());
    }

    public void finalizeRecipeLoading(FeatureFlagSet p_360842_) {
        ArrayList list = new ArrayList();
        List<IngredientCollector> list1 = RECIPE_PROPERTY_SETS.entrySet().stream().map(p_359831_ -> new IngredientCollector((ResourceKey)p_359831_.getKey(), (IngredientExtractor)p_359831_.getValue())).toList();
        this.recipes.values().forEach(p_359840_ -> {
            Object recipe = p_359840_.value();
            if (!recipe.isSpecial() && recipe.placementInfo().isImpossibleToPlace()) {
                LOGGER.warn("Recipe {} can't be placed due to empty ingredients and will be ignored", (Object)p_359840_.id().location());
            } else {
                StonecutterRecipe stonecutterrecipe;
                list1.forEach(p_359842_ -> p_359842_.accept((Recipe<?>)recipe));
                if (recipe instanceof StonecutterRecipe && RecipeManager.isIngredientEnabled(p_360842_, (stonecutterrecipe = (StonecutterRecipe)recipe).input()) && stonecutterrecipe.resultDisplay().isEnabled(p_360842_)) {
                    list.add(new SelectableRecipe.SingleInputEntry(stonecutterrecipe.input(), new SelectableRecipe(stonecutterrecipe.resultDisplay(), Optional.of(p_359840_))));
                }
            }
        });
        this.propertySets = list1.stream().collect(Collectors.toUnmodifiableMap(p_359830_ -> p_359830_.key, p_359826_ -> p_359826_.asPropertySet(p_360842_)));
        this.stonecutterRecipes = new SelectableRecipe.SingleInputSet(list);
        this.allDisplays = RecipeManager.unpackRecipeInfo(this.recipes.values(), p_360842_);
        this.recipeToDisplay = this.allDisplays.stream().collect(Collectors.groupingBy(p_359820_ -> p_359820_.parent.id(), IdentityHashMap::new, Collectors.toList()));
    }

    static List<Ingredient> filterDisabled(FeatureFlagSet p_369580_, List<Ingredient> p_367920_) {
        p_367920_.removeIf(p_359829_ -> !RecipeManager.isIngredientEnabled(p_369580_, p_359829_));
        return p_367920_;
    }

    private static boolean isIngredientEnabled(FeatureFlagSet p_361535_, Ingredient p_369900_) {
        return p_369900_.items().stream().allMatch(p_359822_ -> ((Item)p_359822_.value()).isEnabled(p_361535_));
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_220249_, I p_344518_, Level p_220251_, @Nullable ResourceKey<Recipe<?>> p_361142_) {
        RecipeHolder<T> recipeholder = p_361142_ != null ? this.byKeyTyped(p_220249_, p_361142_) : null;
        return this.getRecipeFor(p_220249_, p_344518_, p_220251_, recipeholder);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_343647_, I p_342793_, Level p_344483_, @Nullable RecipeHolder<T> p_345187_) {
        return p_345187_ != null && p_345187_.value().matches(p_342793_, p_344483_) ? Optional.of(p_345187_) : this.getRecipeFor(p_343647_, p_342793_, p_344483_);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_44016_, I p_344358_, Level p_44018_) {
        return this.recipes.getRecipesFor(p_44016_, p_344358_, p_44018_).findFirst();
    }

    public Optional<RecipeHolder<?>> byKey(ResourceKey<Recipe<?>> p_364678_) {
        return Optional.ofNullable(this.recipes.byKey(p_364678_));
    }

    @Nullable
    private <T extends Recipe<?>> RecipeHolder<T> byKeyTyped(RecipeType<T> p_332930_, ResourceKey<Recipe<?>> p_367936_) {
        RecipeHolder<?> recipeholder = this.recipes.byKey(p_367936_);
        return recipeholder != null && recipeholder.value().getType().equals(p_332930_) ? recipeholder : null;
    }

    public Map<ResourceKey<RecipePropertySet>, RecipePropertySet> getSynchronizedItemProperties() {
        return this.propertySets;
    }

    public SelectableRecipe.SingleInputSet<StonecutterRecipe> getSynchronizedStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    @Override
    public RecipePropertySet propertySet(ResourceKey<RecipePropertySet> p_367484_) {
        return this.propertySets.getOrDefault(p_367484_, RecipePropertySet.EMPTY);
    }

    @Override
    public SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.recipes.values();
    }

    @Nullable
    public ServerDisplayInfo getRecipeFromDisplay(RecipeDisplayId p_362633_) {
        return this.allDisplays.get(p_362633_.index());
    }

    public void listDisplaysForRecipe(ResourceKey<Recipe<?>> p_360782_, Consumer<RecipeDisplayEntry> p_368559_) {
        List<ServerDisplayInfo> list = this.recipeToDisplay.get(p_360782_);
        if (list != null) {
            list.forEach(p_359824_ -> p_368559_.accept(p_359824_.display));
        }
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceKey<Recipe<?>> p_366256_, JsonObject p_44047_, HolderLookup.Provider p_328308_) {
        Recipe recipe = (Recipe)Recipe.CODEC.parse(p_328308_.createSerializationContext(JsonOps.INSTANCE), (Object)p_44047_).getOrThrow(JsonParseException::new);
        return new RecipeHolder<Recipe>(p_366256_, recipe);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CachedCheck<I, T> createCheck(final RecipeType<T> p_220268_) {
        return new CachedCheck<I, T>(){
            @Nullable
            private ResourceKey<Recipe<?>> lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I p_343525_, ServerLevel p_364008_) {
                RecipeManager recipemanager = p_364008_.recipeAccess();
                Optional optional = recipemanager.getRecipeFor(p_220268_, p_343525_, (Level)p_364008_, this.lastRecipe);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.lastRecipe = recipeholder.id();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    private static List<ServerDisplayInfo> unpackRecipeInfo(Iterable<RecipeHolder<?>> p_361848_, FeatureFlagSet p_362319_) {
        ArrayList<ServerDisplayInfo> list = new ArrayList<ServerDisplayInfo>();
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (RecipeHolder<?> recipeholder : p_361848_) {
            Object recipe = recipeholder.value();
            OptionalInt optionalint = recipe.group().isEmpty() ? OptionalInt.empty() : OptionalInt.of(object2intmap.computeIfAbsent((Object)recipe.group(), arg_0 -> RecipeManager.lambda$unpackRecipeInfo$13((Object2IntMap)object2intmap, arg_0)));
            Optional<Object> optional = recipe.isSpecial() ? Optional.empty() : Optional.of(recipe.placementInfo().ingredients());
            for (RecipeDisplay recipedisplay : recipe.display()) {
                if (!recipedisplay.isEnabled(p_362319_)) continue;
                int i = list.size();
                RecipeDisplayId recipedisplayid = new RecipeDisplayId(i);
                RecipeDisplayEntry recipedisplayentry = new RecipeDisplayEntry(recipedisplayid, recipedisplay, optionalint, recipe.recipeBookCategory(), optional);
                list.add(new ServerDisplayInfo(recipedisplayentry, recipeholder));
            }
        }
        return list;
    }

    private static IngredientExtractor forSingleInput(RecipeType<? extends SingleItemRecipe> p_361054_) {
        return p_359846_ -> {
            Optional<Object> optional;
            if (p_359846_.getType() == p_361054_ && p_359846_ instanceof SingleItemRecipe) {
                SingleItemRecipe singleitemrecipe = (SingleItemRecipe)p_359846_;
                optional = Optional.of(singleitemrecipe.input());
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    private static /* synthetic */ int lambda$unpackRecipeInfo$13(Object2IntMap object2intmap, Object p_359844_) {
        return object2intmap.size();
    }

    public record ServerDisplayInfo(RecipeDisplayEntry display, RecipeHolder<?> parent) {
    }

    @FunctionalInterface
    public static interface IngredientExtractor {
        public Optional<Ingredient> apply(Recipe<?> var1);
    }

    public static class IngredientCollector
    implements Consumer<Recipe<?>> {
        final ResourceKey<RecipePropertySet> key;
        private final IngredientExtractor extractor;
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

        protected IngredientCollector(ResourceKey<RecipePropertySet> p_364661_, IngredientExtractor p_368104_) {
            this.key = p_364661_;
            this.extractor = p_368104_;
        }

        @Override
        public void accept(Recipe<?> p_361793_) {
            this.extractor.apply(p_361793_).ifPresent(this.ingredients::add);
        }

        public RecipePropertySet asPropertySet(FeatureFlagSet p_363031_) {
            return RecipePropertySet.create(RecipeManager.filterDisabled(p_363031_, this.ingredients));
        }
    }

    public static interface CachedCheck<I extends RecipeInput, T extends Recipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, ServerLevel var2);
    }
}

