/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;

public class ItemEnchantments
implements TooltipProvider {
    public static final ItemEnchantments EMPTY = new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap(), true);
    private static final Codec<Integer> LEVEL_CODEC = Codec.intRange((int)1, (int)255);
    private static final Codec<Object2IntOpenHashMap<Holder<Enchantment>>> LEVELS_CODEC = Codec.unboundedMap(Enchantment.CODEC, LEVEL_CODEC).xmap(Object2IntOpenHashMap::new, Function.identity());
    private static final Codec<ItemEnchantments> FULL_CODEC = RecordCodecBuilder.create($$02 -> $$02.group((App)LEVELS_CODEC.fieldOf("levels").forGetter($$0 -> $$0.enchantments), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter($$0 -> $$0.showInTooltip)).apply((Applicative)$$02, ItemEnchantments::new));
    public static final Codec<ItemEnchantments> CODEC = Codec.withAlternative(FULL_CODEC, LEVELS_CODEC, $$0 -> new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)$$0, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantments> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.map(Object2IntOpenHashMap::new, Enchantment.STREAM_CODEC, ByteBufCodecs.VAR_INT), $$0 -> $$0.enchantments, ByteBufCodecs.BOOL, $$0 -> $$0.showInTooltip, ItemEnchantments::new);
    final Object2IntOpenHashMap<Holder<Enchantment>> enchantments;
    final boolean showInTooltip;

    ItemEnchantments(Object2IntOpenHashMap<Holder<Enchantment>> $$0, boolean $$1) {
        this.enchantments = $$0;
        this.showInTooltip = $$1;
        for (Object2IntMap.Entry $$2 : $$0.object2IntEntrySet()) {
            int $$3 = $$2.getIntValue();
            if ($$3 >= 0 && $$3 <= 255) continue;
            throw new IllegalArgumentException("Enchantment " + String.valueOf($$2.getKey()) + " has invalid level " + $$3);
        }
    }

    public int getLevel(Holder<Enchantment> $$0) {
        return this.enchantments.getInt($$0);
    }

    @Override
    public void addToTooltip(Item.TooltipContext $$0, Consumer<Component> $$1, TooltipFlag $$2) {
        if (!this.showInTooltip) {
            return;
        }
        HolderLookup.Provider $$3 = $$0.registries();
        HolderSet<Enchantment> $$4 = ItemEnchantments.getTagOrEmpty($$3, Registries.ENCHANTMENT, EnchantmentTags.TOOLTIP_ORDER);
        for (Holder holder : $$4) {
            int $$6 = this.enchantments.getInt((Object)holder);
            if ($$6 <= 0) continue;
            $$1.accept(Enchantment.getFullname(holder, $$6));
        }
        for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
            Holder $$8 = (Holder)entry.getKey();
            if ($$4.contains($$8)) continue;
            $$1.accept(Enchantment.getFullname((Holder)entry.getKey(), entry.getIntValue()));
        }
    }

    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.Provider $$0, ResourceKey<Registry<T>> $$1, TagKey<T> $$2) {
        Optional<HolderSet.Named<T>> $$3;
        if ($$0 != null && ($$3 = $$0.lookupOrThrow($$1).get($$2)).isPresent()) {
            return $$3.get();
        }
        return HolderSet.direct(new Holder[0]);
    }

    public ItemEnchantments withTooltip(boolean $$0) {
        return new ItemEnchantments(this.enchantments, $$0);
    }

    public Set<Holder<Enchantment>> keySet() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<Enchantment>>> entrySet() {
        return Collections.unmodifiableSet(this.enchantments.object2IntEntrySet());
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    public boolean equals(Object $$0) {
        if (this == $$0) {
            return true;
        }
        if ($$0 instanceof ItemEnchantments) {
            ItemEnchantments $$1 = (ItemEnchantments)$$0;
            return this.showInTooltip == $$1.showInTooltip && this.enchantments.equals($$1.enchantments);
        }
        return false;
    }

    public int hashCode() {
        int $$0 = this.enchantments.hashCode();
        $$0 = 31 * $$0 + (this.showInTooltip ? 1 : 0);
        return $$0;
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + String.valueOf(this.enchantments) + ", showInTooltip=" + this.showInTooltip + "}";
    }

    public static class Mutable {
        private final Object2IntOpenHashMap<Holder<Enchantment>> enchantments = new Object2IntOpenHashMap();
        private final boolean showInTooltip;

        public Mutable(ItemEnchantments $$0) {
            this.enchantments.putAll($$0.enchantments);
            this.showInTooltip = $$0.showInTooltip;
        }

        public void set(Holder<Enchantment> $$0, int $$1) {
            if ($$1 <= 0) {
                this.enchantments.removeInt($$0);
            } else {
                this.enchantments.put($$0, Math.min($$1, 255));
            }
        }

        public void upgrade(Holder<Enchantment> $$0, int $$1) {
            if ($$1 > 0) {
                this.enchantments.merge($$0, Math.min($$1, 255), Integer::max);
            }
        }

        public void removeIf(Predicate<Holder<Enchantment>> $$0) {
            this.enchantments.keySet().removeIf($$0);
        }

        public int getLevel(Holder<Enchantment> $$0) {
            return this.enchantments.getOrDefault($$0, 0);
        }

        public Set<Holder<Enchantment>> keySet() {
            return this.enchantments.keySet();
        }

        public ItemEnchantments toImmutable() {
            return new ItemEnchantments(this.enchantments, this.showInTooltip);
        }
    }
}

