/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.Tag;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class ContextNbtProvider
implements NbtProvider {
    private static final String BLOCK_ENTITY_ID = "block_entity";
    private static final Getter BLOCK_ENTITY_PROVIDER = new Getter(){

        @Override
        public Tag get(LootContext p_165582_) {
            BlockEntity blockentity = p_165582_.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
            return blockentity != null ? blockentity.saveWithFullMetadata(blockentity.getLevel().registryAccess()) : null;
        }

        @Override
        public String getId() {
            return ContextNbtProvider.BLOCK_ENTITY_ID;
        }

        @Override
        public Set<ContextKey<?>> getReferencedContextParams() {
            return Set.of(LootContextParams.BLOCK_ENTITY);
        }
    };
    public static final ContextNbtProvider BLOCK_ENTITY = new ContextNbtProvider(BLOCK_ENTITY_PROVIDER);
    private static final Codec<Getter> GETTER_CODEC = Codec.STRING.xmap(p_298021_ -> {
        if (p_298021_.equals(BLOCK_ENTITY_ID)) {
            return BLOCK_ENTITY_PROVIDER;
        }
        LootContext.EntityTarget lootcontext$entitytarget = LootContext.EntityTarget.getByName(p_298021_);
        return ContextNbtProvider.forEntity(lootcontext$entitytarget);
    }, Getter::getId);
    public static final MapCodec<ContextNbtProvider> CODEC = RecordCodecBuilder.mapCodec(p_300408_ -> p_300408_.group((App)GETTER_CODEC.fieldOf("target").forGetter(p_300339_ -> p_300339_.getter)).apply((Applicative)p_300408_, ContextNbtProvider::new));
    public static final Codec<ContextNbtProvider> INLINE_CODEC = GETTER_CODEC.xmap(ContextNbtProvider::new, p_298349_ -> p_298349_.getter);
    private final Getter getter;

    private static Getter forEntity(final LootContext.EntityTarget p_165578_) {
        return new Getter(){

            @Override
            @Nullable
            public Tag get(LootContext p_165589_) {
                Entity entity = p_165589_.getOptionalParameter(p_165578_.getParam());
                return entity != null ? NbtPredicate.getEntityTagToCompare(entity) : null;
            }

            @Override
            public String getId() {
                return p_165578_.getSerializedName();
            }

            @Override
            public Set<ContextKey<?>> getReferencedContextParams() {
                return Set.of(p_165578_.getParam());
            }
        };
    }

    private ContextNbtProvider(Getter p_165568_) {
        this.getter = p_165568_;
    }

    @Override
    public LootNbtProviderType getType() {
        return NbtProviders.CONTEXT;
    }

    @Override
    @Nullable
    public Tag get(LootContext p_165573_) {
        return this.getter.get(p_165573_);
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.getter.getReferencedContextParams();
    }

    public static NbtProvider forContextEntity(LootContext.EntityTarget p_165571_) {
        return new ContextNbtProvider(ContextNbtProvider.forEntity(p_165571_));
    }

    static interface Getter {
        @Nullable
        public Tag get(LootContext var1);

        public String getId();

        public Set<ContextKey<?>> getReferencedContextParams();
    }
}

