/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public record NbtPredicate(CompoundTag tag) {
    public static final Codec<NbtPredicate> CODEC = TagParser.LENIENT_CODEC.xmap(NbtPredicate::new, NbtPredicate::tag);
    public static final StreamCodec<ByteBuf, NbtPredicate> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(NbtPredicate::new, NbtPredicate::tag);

    public boolean matches(ItemStack $$0) {
        CustomData $$1 = $$0.getOrDefault(DataComponents.CUSTOM_DATA, CustomData.EMPTY);
        return $$1.matchedBy(this.tag);
    }

    public boolean matches(Entity $$0) {
        return this.matches(NbtPredicate.getEntityTagToCompare($$0));
    }

    public boolean matches(@Nullable Tag $$0) {
        return $$0 != null && NbtUtils.compareNbt(this.tag, $$0, true);
    }

    public static CompoundTag getEntityTagToCompare(Entity $$0) {
        ItemStack $$2;
        CompoundTag $$1 = $$0.saveWithoutId(new CompoundTag());
        if ($$0 instanceof Player && !($$2 = ((Player)$$0).getInventory().getSelected()).isEmpty()) {
            $$1.put("SelectedItem", $$2.save($$0.registryAccess()));
        }
        return $$1;
    }
}

