/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ParticleArgument
implements ArgumentType<ParticleOptions> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "particle{foo:bar}");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_PARTICLE = new DynamicCommandExceptionType($$0 -> Component.translatableEscape("particle.notFound", $$0));
    public static final DynamicCommandExceptionType ERROR_INVALID_OPTIONS = new DynamicCommandExceptionType($$0 -> Component.translatableEscape("particle.invalidOptions", $$0));
    private final HolderLookup.Provider registries;

    public ParticleArgument(CommandBuildContext $$0) {
        this.registries = $$0;
    }

    public static ParticleArgument particle(CommandBuildContext $$0) {
        return new ParticleArgument($$0);
    }

    public static ParticleOptions getParticle(CommandContext<CommandSourceStack> $$0, String $$1) {
        return (ParticleOptions)$$0.getArgument($$1, ParticleOptions.class);
    }

    public ParticleOptions parse(StringReader $$0) throws CommandSyntaxException {
        return ParticleArgument.readParticle($$0, this.registries);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static ParticleOptions readParticle(StringReader $$0, HolderLookup.Provider $$1) throws CommandSyntaxException {
        ParticleType<?> $$2 = ParticleArgument.readParticleType($$0, $$1.lookupOrThrow(Registries.PARTICLE_TYPE));
        return ParticleArgument.readParticle($$0, $$2, $$1);
    }

    private static ParticleType<?> readParticleType(StringReader $$0, HolderLookup<ParticleType<?>> $$1) throws CommandSyntaxException {
        ResourceLocation $$2 = ResourceLocation.read($$0);
        ResourceKey<ParticleType<?>> $$3 = ResourceKey.create(Registries.PARTICLE_TYPE, $$2);
        return $$1.get($$3).orElseThrow(() -> ERROR_UNKNOWN_PARTICLE.createWithContext((ImmutableStringReader)$$0, (Object)$$2)).value();
    }

    private static <T extends ParticleOptions> T readParticle(StringReader $$0, ParticleType<T> $$1, HolderLookup.Provider $$2) throws CommandSyntaxException {
        CompoundTag $$4;
        if ($$0.canRead() && $$0.peek() == '{') {
            CompoundTag $$3 = new TagParser($$0).readStruct();
        } else {
            $$4 = new CompoundTag();
        }
        return (T)((ParticleOptions)$$1.codec().codec().parse($$2.createSerializationContext(NbtOps.INSTANCE), (Object)$$4).getOrThrow(arg_0 -> ((DynamicCommandExceptionType)ERROR_INVALID_OPTIONS).create(arg_0)));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> $$0, SuggestionsBuilder $$1) {
        HolderGetter $$2 = this.registries.lookupOrThrow(Registries.PARTICLE_TYPE);
        return SharedSuggestionProvider.suggestResource($$2.listElementIds().map(ResourceKey::location), $$1);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

