/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerLevel;

public class GameTestBatchFactory {
    private static final int MAX_TESTS_PER_BATCH = 50;

    public static Collection<GameTestBatch> fromTestFunction(Collection<TestFunction> $$0, ServerLevel $$12) {
        Map<String, List<TestFunction>> $$2 = $$0.stream().collect(Collectors.groupingBy(TestFunction::batchName));
        return $$2.entrySet().stream().flatMap($$1 -> {
            String $$22 = (String)$$1.getKey();
            List $$32 = (List)$$1.getValue();
            return Streams.mapWithIndex(Lists.partition((List)$$32, (int)50).stream(), ($$2, $$3) -> GameTestBatchFactory.toGameTestBatch($$2.stream().map($$1 -> GameTestBatchFactory.toGameTestInfo($$1, 0, $$12)).toList(), $$22, $$3));
        }).toList();
    }

    public static GameTestInfo toGameTestInfo(TestFunction $$0, int $$1, ServerLevel $$2) {
        return new GameTestInfo($$0, StructureUtils.getRotationForRotationSteps($$1), $$2, RetryOptions.noRetries());
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo() {
        return GameTestBatchFactory.fromGameTestInfo(50);
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo(int $$0) {
        return $$1 -> {
            Map<String, List<GameTestInfo>> $$2 = $$1.stream().filter(Objects::nonNull).collect(Collectors.groupingBy($$0 -> $$0.getTestFunction().batchName()));
            return $$2.entrySet().stream().flatMap($$12 -> {
                String $$22 = (String)$$12.getKey();
                List $$3 = (List)$$12.getValue();
                return Streams.mapWithIndex(Lists.partition((List)$$3, (int)$$0).stream(), ($$1, $$2) -> GameTestBatchFactory.toGameTestBatch(List.copyOf($$1), $$22, $$2));
            }).toList();
        };
    }

    public static GameTestBatch toGameTestBatch(Collection<GameTestInfo> $$0, String $$1, long $$2) {
        Consumer<ServerLevel> $$3 = GameTestRegistry.getBeforeBatchFunction($$1);
        Consumer<ServerLevel> $$4 = GameTestRegistry.getAfterBatchFunction($$1);
        return new GameTestBatch($$1 + ":" + $$2, $$0, $$3, $$4);
    }
}

