/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class SimpleJsonResourceReloadListener<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DynamicOps<JsonElement> ops;
    private final Codec<T> codec;
    private final String directory;

    protected SimpleJsonResourceReloadListener(HolderLookup.Provider $$0, Codec<T> $$1, String $$2) {
        this($$0.createSerializationContext(JsonOps.INSTANCE), $$1, $$2);
    }

    protected SimpleJsonResourceReloadListener(Codec<T> $$0, String $$1) {
        this((DynamicOps<JsonElement>)JsonOps.INSTANCE, $$0, $$1);
    }

    private SimpleJsonResourceReloadListener(DynamicOps<JsonElement> $$0, Codec<T> $$1, String $$2) {
        this.ops = $$0;
        this.codec = $$1;
        this.directory = $$2;
    }

    @Override
    protected Map<ResourceLocation, T> prepare(ResourceManager $$0, ProfilerFiller $$1) {
        HashMap $$2 = new HashMap();
        SimpleJsonResourceReloadListener.scanDirectory($$0, this.directory, this.ops, this.codec, $$2);
        return $$2;
    }

    public static <T> void scanDirectory(ResourceManager $$0, String $$1, DynamicOps<JsonElement> $$22, Codec<T> $$3, Map<ResourceLocation, T> $$4) {
        FileToIdConverter $$5 = FileToIdConverter.json($$1);
        for (Map.Entry<ResourceLocation, Resource> $$6 : $$5.listMatchingResources($$0).entrySet()) {
            ResourceLocation $$7 = $$6.getKey();
            ResourceLocation $$8 = $$5.fileToId($$7);
            try {
                BufferedReader $$9 = $$6.getValue().openAsReader();
                try {
                    $$3.parse($$22, (Object)JsonParser.parseReader((Reader)$$9)).ifSuccess($$2 -> {
                        if ($$4.putIfAbsent($$8, $$2) != null) {
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf($$8));
                        }
                    }).ifError($$2 -> LOGGER.error("Couldn't parse data file '{}' from '{}': {}", new Object[]{$$8, $$7, $$2}));
                }
                finally {
                    if ($$9 == null) continue;
                    ((Reader)$$9).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException $$10) {
                LOGGER.error("Couldn't parse data file '{}' from '{}'", new Object[]{$$8, $$7, $$10});
            }
        }
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.prepare(resourceManager, profilerFiller);
    }
}

