/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<FriendlyByteBuf, RecipeBookSettings> STREAM_CODEC = StreamCodec.ofMember(RecipeBookSettings::write, RecipeBookSettings::read);
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, TypeSettings> states;

    private RecipeBookSettings(Map<RecipeBookType, TypeSettings> $$0) {
        this.states = $$0;
    }

    public RecipeBookSettings() {
        this(new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class));
    }

    private TypeSettings getSettings(RecipeBookType $$0) {
        return this.states.getOrDefault((Object)$$0, TypeSettings.DEFAULT);
    }

    private void updateSettings(RecipeBookType $$0, UnaryOperator<TypeSettings> $$12) {
        this.states.compute($$0, ($$1, $$2) -> {
            if ($$2 == null) {
                $$2 = TypeSettings.DEFAULT;
            }
            if (($$2 = (TypeSettings)$$12.apply((TypeSettings)$$2)).equals(TypeSettings.DEFAULT)) {
                $$2 = null;
            }
            return $$2;
        });
    }

    public boolean isOpen(RecipeBookType $$0) {
        return this.getSettings((RecipeBookType)$$0).open;
    }

    public void setOpen(RecipeBookType $$0, boolean $$12) {
        this.updateSettings($$0, $$1 -> $$1.setOpen($$12));
    }

    public boolean isFiltering(RecipeBookType $$0) {
        return this.getSettings((RecipeBookType)$$0).filtering;
    }

    public void setFiltering(RecipeBookType $$0, boolean $$12) {
        this.updateSettings($$0, $$1 -> $$1.setFiltering($$12));
    }

    private static RecipeBookSettings read(FriendlyByteBuf $$0) {
        EnumMap<RecipeBookType, TypeSettings> $$1 = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        for (RecipeBookType $$2 : RecipeBookType.values()) {
            boolean $$3 = $$0.readBoolean();
            boolean $$4 = $$0.readBoolean();
            if (!$$3 && !$$4) continue;
            $$1.put($$2, new TypeSettings($$3, $$4));
        }
        return new RecipeBookSettings($$1);
    }

    private void write(FriendlyByteBuf $$0) {
        for (RecipeBookType $$1 : RecipeBookType.values()) {
            TypeSettings $$2 = this.states.getOrDefault((Object)$$1, TypeSettings.DEFAULT);
            $$0.writeBoolean($$2.open);
            $$0.writeBoolean($$2.filtering);
        }
    }

    public static RecipeBookSettings read(CompoundTag $$0) {
        EnumMap<RecipeBookType, TypeSettings> $$1 = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        TAG_FIELDS.forEach(($$2, $$3) -> {
            boolean $$4 = $$0.getBoolean((String)$$3.getFirst());
            boolean $$5 = $$0.getBoolean((String)$$3.getSecond());
            if ($$4 || $$5) {
                $$1.put((RecipeBookType)((Object)$$2), new TypeSettings($$4, $$5));
            }
        });
        return new RecipeBookSettings($$1);
    }

    public void write(CompoundTag $$0) {
        TAG_FIELDS.forEach(($$1, $$2) -> {
            TypeSettings $$3 = this.states.getOrDefault($$1, TypeSettings.DEFAULT);
            $$0.putBoolean((String)$$2.getFirst(), $$3.open);
            $$0.putBoolean((String)$$2.getSecond(), $$3.filtering);
        });
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(new EnumMap<RecipeBookType, TypeSettings>(this.states));
    }

    public void replaceFrom(RecipeBookSettings $$0) {
        this.states.clear();
        this.states.putAll($$0.states);
    }

    public boolean equals(Object $$0) {
        return this == $$0 || $$0 instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)$$0).states);
    }

    public int hashCode() {
        return this.states.hashCode();
    }

    record TypeSettings(boolean open, boolean filtering) {
        public static final TypeSettings DEFAULT = new TypeSettings(false, false);

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public TypeSettings setOpen(boolean $$0) {
            return new TypeSettings($$0, this.filtering);
        }

        public TypeSettings setFiltering(boolean $$0) {
            return new TypeSettings(this.open, $$0);
        }
    }
}

