/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CreakingTransient
extends Creaking {
    public static final int INVULNERABILITY_ANIMATION_DURATION = 8;
    private int invulnerabilityAnimationRemainingTicks;
    @Nullable
    BlockPos homePos;

    public CreakingTransient(EntityType<? extends Creaking> $$0, Level $$1) {
        super($$0, $$1);
    }

    public void bindToCreakingHeart(BlockPos $$0) {
        this.homePos = $$0;
    }

    @Override
    public boolean hurtServer(ServerLevel $$0, DamageSource $$1, float $$2) {
        CreakingHeartBlockEntity $$3;
        if (this.level().isClientSide) {
            return super.hurtServer($$0, $$1, $$2);
        }
        if ($$1.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurtServer($$0, $$1, $$2);
        }
        if (this.isInvulnerableTo($$0, $$1) || this.invulnerabilityAnimationRemainingTicks > 0) {
            return false;
        }
        this.invulnerabilityAnimationRemainingTicks = 8;
        this.level().broadcastEntityEvent(this, (byte)66);
        BlockEntity blockEntity = this.level().getBlockEntity(this.homePos);
        if (blockEntity instanceof CreakingHeartBlockEntity && ($$3 = (CreakingHeartBlockEntity)blockEntity).isProtector(this)) {
            if ($$1.getEntity() instanceof Player) {
                $$3.creakingHurt();
            }
            this.playHurtSound($$1);
        }
        return true;
    }

    @Override
    public void aiStep() {
        if (this.invulnerabilityAnimationRemainingTicks > 0) {
            --this.invulnerabilityAnimationRemainingTicks;
        }
        super.aiStep();
    }

    @Override
    public void tick() {
        CreakingHeartBlockEntity $$0;
        BlockEntity blockEntity;
        if (!(this.level().isClientSide || this.homePos != null && (blockEntity = this.level().getBlockEntity(this.homePos)) instanceof CreakingHeartBlockEntity && ($$0 = (CreakingHeartBlockEntity)blockEntity).isProtector(this))) {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
            return;
        }
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void handleEntityEvent(byte $$0) {
        if ($$0 == 66) {
            this.invulnerabilityAnimationRemainingTicks = 8;
            this.playHurtSound(this.damageSources().generic());
        } else {
            super.handleEntityEvent($$0);
        }
    }

    private void setupAnimationStates() {
        this.invulnerabilityAnimationState.animateWhen(this.invulnerabilityAnimationRemainingTicks > 0, this.tickCount);
    }

    public void tearDown(@Nullable DamageSource $$0) {
        Object object = this.level();
        if (object instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)object;
            AABB $$2 = this.getBoundingBox();
            Vec3 $$3 = $$2.getCenter();
            double $$4 = $$2.getXsize() * 0.3;
            double $$5 = $$2.getYsize() * 0.3;
            double $$6 = $$2.getZsize() * 0.3;
            $$1.sendParticles(new BlockParticleOption(ParticleTypes.BLOCK_CRUMBLE, Blocks.PALE_OAK_WOOD.defaultBlockState()), $$3.x, $$3.y, $$3.z, 100, $$4, $$5, $$6, 0.0);
            $$1.sendParticles(new BlockParticleOption(ParticleTypes.BLOCK_CRUMBLE, (BlockState)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.ACTIVE)), $$3.x, $$3.y, $$3.z, 10, $$4, $$5, $$6, 0.0);
        }
        this.makeSound(this.getDeathSound());
        if (this.deathScore >= 0 && $$0 != null && (object = $$0.getEntity()) instanceof LivingEntity) {
            LivingEntity $$7 = (LivingEntity)object;
            $$7.awardKillScore(this, this.deathScore, $$0);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    protected boolean canAddPassenger(Entity $$0) {
        return false;
    }

    @Override
    protected boolean couldAcceptPassenger() {
        return false;
    }

    @Override
    protected void addPassenger(Entity $$0) {
        throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
    }

    @Override
    public boolean canUsePortal(boolean $$0) {
        return false;
    }

    @Override
    protected PathNavigation createNavigation(Level $$0) {
        return new CreakingPathNavigation(this, $$0);
    }

    class CreakingPathNavigation
    extends GroundPathNavigation {
        CreakingPathNavigation(Creaking $$0, Level $$1) {
            super($$0, $$1);
        }

        @Override
        public void tick() {
            if (CreakingTransient.this.canMove()) {
                super.tick();
            }
        }

        @Override
        protected PathFinder createPathFinder(int $$0) {
            this.nodeEvaluator = new HomeNodeEvaluator();
            return new PathFinder(this.nodeEvaluator, $$0);
        }
    }

    class HomeNodeEvaluator
    extends WalkNodeEvaluator {
        private static final int MAX_DISTANCE_TO_HOME_SQ = 1024;

        HomeNodeEvaluator() {
        }

        @Override
        public PathType getPathType(PathfindingContext $$0, int $$1, int $$2, int $$3) {
            BlockPos $$4 = CreakingTransient.this.homePos;
            if ($$4 == null) {
                return super.getPathType($$0, $$1, $$2, $$3);
            }
            double $$5 = $$4.distSqr(new Vec3i($$1, $$2, $$3));
            if ($$5 > 1024.0 && $$5 >= $$4.distSqr($$0.mobPosition())) {
                return PathType.BLOCKED;
            }
            return super.getPathType($$0, $$1, $$2, $$3);
        }
    }
}

