/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.TargetColorParticleOption;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.creaking.CreakingTransient;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class CreakingHeartBlockEntity
extends BlockEntity {
    private static final int PLAYER_DETECTION_RANGE = 32;
    public static final int CREAKING_ROAMING_RADIUS = 32;
    private static final int DISTANCE_CREAKING_TOO_FAR = 34;
    private static final int SPAWN_RANGE_XZ = 16;
    private static final int SPAWN_RANGE_Y = 8;
    private static final int ATTEMPTS_PER_SPAWN = 5;
    private static final int UPDATE_TICKS = 20;
    private static final int HURT_CALL_TOTAL_TICKS = 100;
    private static final int NUMBER_OF_HURT_CALLS = 10;
    private static final int HURT_CALL_INTERVAL = 10;
    private static final int HURT_CALL_PARTICLE_TICKS = 50;
    @Nullable
    private CreakingTransient creaking;
    private int ticker;
    private int emitter;
    @Nullable
    private Vec3 emitterTarget;
    private int outputSignal;

    public CreakingHeartBlockEntity(BlockPos $$0, BlockState $$1) {
        super(BlockEntityType.CREAKING_HEART, $$0, $$1);
    }

    public static void serverTick(Level $$0, BlockPos $$1, BlockState $$2, CreakingHeartBlockEntity $$3) {
        ServerLevel $$11;
        int $$4 = $$3.computeAnalogOutputSignal();
        if ($$3.outputSignal != $$4) {
            $$3.outputSignal = $$4;
            $$0.updateNeighbourForOutputSignal($$1, Blocks.CREAKING_HEART);
        }
        if ($$3.emitter > 0) {
            if ($$3.emitter > 50) {
                $$3.emitParticles((ServerLevel)$$0, 1, true);
                $$3.emitParticles((ServerLevel)$$0, 1, false);
            }
            if ($$3.emitter % 10 == 0 && $$0 instanceof ServerLevel) {
                ServerLevel $$5 = (ServerLevel)$$0;
                if ($$3.emitterTarget != null) {
                    if ($$3.creaking != null) {
                        $$3.emitterTarget = $$3.creaking.getBoundingBox().getCenter();
                    }
                    Vec3 $$6 = Vec3.atCenterOf($$1);
                    float $$7 = 0.2f + 0.8f * (float)(100 - $$3.emitter) / 100.0f;
                    Vec3 $$8 = $$6.subtract($$3.emitterTarget).scale($$7).add($$3.emitterTarget);
                    BlockPos $$9 = BlockPos.containing($$8);
                    float $$10 = (float)$$3.emitter / 2.0f / 100.0f + 0.5f;
                    $$5.playSound(null, $$9, SoundEvents.CREAKING_HEART_HURT, SoundSource.BLOCKS, $$10, 1.0f);
                }
            }
            --$$3.emitter;
        }
        if ($$3.ticker-- >= 0) {
            return;
        }
        $$3.ticker = 20;
        if ($$3.creaking != null) {
            if (!CreakingHeartBlock.canSummonCreaking($$0) || $$3.distanceToCreaking() > 34.0) {
                $$3.removeProtector(null);
                return;
            }
            if ($$3.creaking.isRemoved()) {
                $$3.creaking = null;
            }
            if (!CreakingHeartBlock.hasRequiredLogs($$2, $$0, $$1) && $$3.creaking == null) {
                $$0.setBlock($$1, (BlockState)$$2.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DISABLED), 3);
            }
            return;
        }
        if (!CreakingHeartBlock.hasRequiredLogs($$2, $$0, $$1)) {
            $$0.setBlock($$1, (BlockState)$$2.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DISABLED), 3);
            return;
        }
        if (!CreakingHeartBlock.canSummonCreaking($$0)) {
            if ($$2.getValue(CreakingHeartBlock.CREAKING) == CreakingHeartBlock.CreakingHeartState.ACTIVE) {
                $$0.setBlock($$1, (BlockState)$$2.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DORMANT), 3);
                return;
            }
        } else if ($$2.getValue(CreakingHeartBlock.CREAKING) == CreakingHeartBlock.CreakingHeartState.DORMANT) {
            $$0.setBlock($$1, (BlockState)$$2.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.ACTIVE), 3);
            return;
        }
        if ($$2.getValue(CreakingHeartBlock.CREAKING) != CreakingHeartBlock.CreakingHeartState.ACTIVE) {
            return;
        }
        if ($$0.getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        if ($$0 instanceof ServerLevel && !($$11 = (ServerLevel)$$0).getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return;
        }
        Player $$12 = $$0.getNearestPlayer((double)$$1.getX(), (double)$$1.getY(), (double)$$1.getZ(), 32.0, false);
        if ($$12 != null) {
            $$3.creaking = CreakingHeartBlockEntity.spawnProtector((ServerLevel)$$0, $$3);
            if ($$3.creaking != null) {
                $$3.creaking.makeSound(SoundEvents.CREAKING_SPAWN);
                $$0.playSound(null, $$3.getBlockPos(), SoundEvents.CREAKING_HEART_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private double distanceToCreaking() {
        if (this.creaking == null) {
            return 0.0;
        }
        return Math.sqrt(this.creaking.distanceToSqr(Vec3.atBottomCenterOf(this.getBlockPos())));
    }

    @Nullable
    private static CreakingTransient spawnProtector(ServerLevel $$0, CreakingHeartBlockEntity $$1) {
        BlockPos $$2 = $$1.getBlockPos();
        Optional<CreakingTransient> $$3 = SpawnUtil.trySpawnMob(EntityType.CREAKING_TRANSIENT, EntitySpawnReason.SPAWNER, $$0, $$2, 5, 16, 8, SpawnUtil.Strategy.ON_TOP_OF_COLLIDER_NO_LEAVES);
        if ($$3.isEmpty()) {
            return null;
        }
        CreakingTransient $$4 = $$3.get();
        $$0.gameEvent((Entity)$$4, GameEvent.ENTITY_PLACE, $$4.position());
        $$0.broadcastEntityEvent($$4, (byte)60);
        $$4.bindToCreakingHeart($$2);
        return $$4;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider $$0) {
        return this.saveCustomOnly($$0);
    }

    /*
     * WARNING - void declaration
     */
    public void creakingHurt() {
        void $$1;
        if (this.creaking == null) {
            return;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$0 = (ServerLevel)level;
        this.emitParticles((ServerLevel)$$1, 20, false);
        this.emitter = 100;
        this.emitterTarget = this.creaking.getBoundingBox().getCenter();
    }

    private void emitParticles(ServerLevel $$0, int $$1, boolean $$2) {
        if (this.creaking == null) {
            return;
        }
        int $$3 = $$2 ? 16545810 : 0x5F5F5F;
        RandomSource $$4 = $$0.random;
        for (double $$5 = 0.0; $$5 < (double)$$1; $$5 += 1.0) {
            Vec3 $$6 = this.creaking.getBoundingBox().getMinPosition().add($$4.nextDouble() * this.creaking.getBoundingBox().getXsize(), $$4.nextDouble() * this.creaking.getBoundingBox().getYsize(), $$4.nextDouble() * this.creaking.getBoundingBox().getZsize());
            Vec3 $$7 = Vec3.atLowerCornerOf(this.getBlockPos()).add($$4.nextDouble(), $$4.nextDouble(), $$4.nextDouble());
            if ($$2) {
                Vec3 $$8 = $$6;
                $$6 = $$7;
                $$7 = $$8;
            }
            TargetColorParticleOption $$9 = new TargetColorParticleOption($$7, $$3);
            $$0.sendParticles($$9, $$6.x, $$6.y, $$6.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void removeProtector(@Nullable DamageSource $$0) {
        if (this.creaking != null) {
            this.creaking.tearDown($$0);
            this.creaking = null;
        }
    }

    public boolean isProtector(Creaking $$0) {
        return this.creaking == $$0;
    }

    public int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    public int computeAnalogOutputSignal() {
        if (this.creaking == null) {
            return 0;
        }
        double $$0 = this.distanceToCreaking();
        double $$1 = Math.clamp($$0, 0.0, 32.0) / 32.0;
        return 15 - (int)Math.floor($$1 * 15.0);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

