/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.launch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.VirtualJar;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.spongepowered.asm.launch.MixinTransformationServiceAbstract;
import org.spongepowered.asm.service.MixinService;

public class MixinTransformationService
extends MixinTransformationServiceAbstract {
    private static final String VIRTUAL_JAR_CLASS = "cpw.mods.jarhandling.VirtualJar";

    public List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        try {
            Path codeSource = Path.of(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            if (this.detectVirtualJar(layerManager)) {
                try {
                    return ImmutableList.of((Object)this.createVirtualJar(codeSource));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return ImmutableList.of((Object)this.createShim(codeSource));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            return super.completeScan(layerManager);
        }
    }

    private boolean detectVirtualJar(IModuleLayerManager layerManager) {
        try {
            MixinService.getService().getClassProvider().findClass(VIRTUAL_JAR_CLASS, false);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private ITransformationService.Resource createVirtualJar(Path codeSource) throws URISyntaxException {
        VirtualJar jar = new VirtualJar("mixin_synthetic", codeSource, new String[]{"org.spongepowered.asm.synthetic", "org.spongepowered.asm.synthetic.args"});
        return new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, (List)ImmutableList.of((Object)jar));
    }

    private ITransformationService.Resource createShim(Path codeSource) throws URISyntaxException {
        Path path = codeSource.resolve("mixin_synthetic");
        ImmutableSet packages = ImmutableSet.of((Object)"org.spongepowered.asm.synthetic", (Object)"org.spongepowered.asm.synthetic.args");
        SecureJar jar = SecureJar.from(arg_0 -> MixinTransformationService.lambda$createShim$0(path, (Set)packages, arg_0), (Path[])new Path[]{codeSource});
        return new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, (List)ImmutableList.of((Object)jar));
    }

    private static /* synthetic */ JarMetadata lambda$createShim$0(Path path, Set packages, SecureJar sj) {
        return JarMetadata.fromFileName((Path)path, (Set)packages, (List)ImmutableList.of());
    }
}

