/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.Node;
import alternate.current.wire.WireConnection;
import alternate.current.wire.WireHandler;
import alternate.current.wire.WireNode;
import java.util.Arrays;
import java.util.function.Consumer;

public class WireConnectionManager {
    final WireNode owner;
    private final WireConnection[] heads;
    private WireConnection head;
    private WireConnection tail;
    int total;
    private int flowTotal;
    int iFlowDir;

    WireConnectionManager(WireNode owner) {
        this.owner = owner;
        this.heads = new WireConnection[WireHandler.Directions.HORIZONTAL.length];
        this.total = 0;
        this.flowTotal = 0;
        this.iFlowDir = -1;
    }

    void set(WireHandler.NodeProvider nodes) {
        if (this.total > 0) {
            this.clear();
        }
        boolean belowIsConductor = nodes.getNeighbor(this.owner, 4).isConductor();
        boolean aboveIsConductor = nodes.getNeighbor(this.owner, 5).isConductor();
        for (int iDir = 0; iDir < WireHandler.Directions.HORIZONTAL.length; ++iDir) {
            Node node;
            Node neighbor = nodes.getNeighbor(this.owner, iDir);
            if (neighbor.isWire()) {
                this.add(neighbor.asWire(), iDir, true, true);
                continue;
            }
            boolean sideIsConductor = neighbor.isConductor();
            if (!sideIsConductor && (node = nodes.getNeighbor(neighbor, 4)).isWire()) {
                this.add(node.asWire(), iDir, belowIsConductor, true);
            }
            if (aboveIsConductor || !(node = nodes.getNeighbor(neighbor, 5)).isWire()) continue;
            this.add(node.asWire(), iDir, true, sideIsConductor);
        }
        if (this.total > 0) {
            this.iFlowDir = WireHandler.FLOW_IN_TO_FLOW_OUT[this.flowTotal];
        }
    }

    private void clear() {
        Arrays.fill(this.heads, null);
        this.head = null;
        this.tail = null;
        this.total = 0;
        this.flowTotal = 0;
        this.iFlowDir = -1;
    }

    private void add(WireNode wire, int iDir, boolean offer, boolean accept) {
        this.add(new WireConnection(wire, iDir, offer, accept));
    }

    private void add(WireConnection connection) {
        if (this.head == null) {
            this.head = connection;
            this.tail = connection;
        } else {
            this.tail.next = connection;
            this.tail = connection;
        }
        ++this.total;
        if (this.heads[connection.iDir] == null) {
            this.heads[connection.iDir] = connection;
            this.flowTotal |= 1 << connection.iDir;
        }
    }

    void forEach(Consumer<WireConnection> consumer) {
        WireConnection c2 = this.head;
        while (c2 != null) {
            consumer.accept(c2);
            c2 = c2.next;
        }
    }

    void forEach(Consumer<WireConnection> consumer, int iFlowDir) {
        for (int iDir : WireHandler.CARDINAL_UPDATE_ORDERS[iFlowDir]) {
            WireConnection c2 = this.heads[iDir];
            while (c2 != null && c2.iDir == iDir) {
                consumer.accept(c2);
                c2 = c2.next;
            }
        }
    }
}

