/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.collection;

import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.Validate;
import java.lang.invoke.VarHandle;
import java.util.ConcurrentModificationException;

public class SRSWLinkedQueue<E> {
    protected LinkedNode<E> head;
    protected LinkedNode<E> tail;

    public SRSWLinkedQueue() {
        LinkedNode dummy = new LinkedNode(null, null);
        this.tail = dummy;
        this.head = this.tail;
    }

    public E peekFirst() {
        LinkedNode<E> head = this.head;
        E ret = head.getElementPlain();
        if (ret == null) {
            if ((head = head.getNextAcquire()) == null) {
                return null;
            }
            this.head = head;
            ret = head.getElementPlain();
            if (ret == null) {
                throw new ConcurrentModificationException("Multiple reader threads");
            }
        }
        return ret;
    }

    public E poll() {
        LinkedNode<E> head = this.head;
        E ret = head.getElementPlain();
        if (ret == null) {
            if ((head = head.getNextAcquire()) == null) {
                return null;
            }
            ret = head.getElementPlain();
            if (ret == null) {
                throw new ConcurrentModificationException("Multiple reader threads");
            }
        }
        head.setElementPlain(null);
        LinkedNode<E> next = head.getNextAcquire();
        this.head = next == null ? head : next;
        return ret;
    }

    public void addLast(E element) {
        Validate.notNull(element, "Provided element cannot be null");
        LinkedNode append = new LinkedNode(element, null);
        this.tail.setNextRelease(append);
        this.tail = append;
    }

    protected static final class LinkedNode<E> {
        protected volatile Object element;
        protected volatile LinkedNode<E> next;
        protected static final VarHandle ELEMENT_HANDLE = ConcurrentUtil.getVarHandle(LinkedNode.class, "element", Object.class);
        protected static final VarHandle NEXT_HANDLE = ConcurrentUtil.getVarHandle(LinkedNode.class, "next", LinkedNode.class);

        protected LinkedNode(Object element, LinkedNode<E> next) {
            ELEMENT_HANDLE.set(this, element);
            NEXT_HANDLE.set(this, next);
        }

        protected final E getElementPlain() {
            return (E)ELEMENT_HANDLE.get(this);
        }

        protected final void setElementPlain(E update) {
            ELEMENT_HANDLE.set(this, update);
        }

        protected final LinkedNode<E> getNextPlain() {
            return NEXT_HANDLE.get(this);
        }

        protected final LinkedNode<E> getNextAcquire() {
            return NEXT_HANDLE.getAcquire(this);
        }

        protected final void setNextPlain(LinkedNode<E> next) {
            NEXT_HANDLE.set(this, next);
        }

        protected final void setNextRelease(LinkedNode<E> next) {
            NEXT_HANDLE.setRelease(this, next);
        }
    }
}

