/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V2202 {
    protected static final int VERSION = 2202;

    private V2202() {
    }

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2202){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                int n2;
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                int[] oldBiomes = level.getInts("Biomes");
                if (oldBiomes == null || oldBiomes.length != 256) {
                    return null;
                }
                int[] newBiomes = new int[1024];
                level.setInts("Biomes", newBiomes);
                for (n2 = 0; n2 < 4; ++n2) {
                    for (int j2 = 0; j2 < 4; ++j2) {
                        int k2 = (j2 << 2) + 2;
                        int l2 = (n2 << 2) + 2;
                        int m2 = l2 << 4 | k2;
                        newBiomes[n2 << 2 | j2] = oldBiomes[m2];
                    }
                }
                for (n2 = 1; n2 < 64; ++n2) {
                    System.arraycopy(newBiomes, 0, newBiomes, n2 * 16, 16);
                }
                return null;
            }
        });
    }
}

