/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.io;

import com.destroystokyo.paper.io.IOUtil;
import com.destroystokyo.paper.io.PrioritizedTaskQueue;
import com.mojang.logging.LogUtils;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;

@Deprecated(forRemoval=true)
public class QueueExecutorThread<T extends PrioritizedTaskQueue.PrioritizedTask>
extends Thread {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final PrioritizedTaskQueue<T> queue;
    protected final long spinWaitTime;
    protected volatile boolean closed;
    protected final AtomicBoolean parked = new AtomicBoolean();
    protected volatile ConcurrentLinkedQueue<Thread> flushQueue = new ConcurrentLinkedQueue();
    protected volatile long flushCycles;
    protected int lowestPriorityToPoll = 5;

    public int getLowestPriorityToPoll() {
        return this.lowestPriorityToPoll;
    }

    public void setLowestPriorityToPoll(int lowestPriorityToPoll) {
        if (this.isAlive()) {
            throw new IllegalStateException("Cannot set after starting");
        }
        this.lowestPriorityToPoll = lowestPriorityToPoll;
    }

    public QueueExecutorThread(PrioritizedTaskQueue<T> queue) {
        this(queue, 1000000L);
    }

    public QueueExecutorThread(PrioritizedTaskQueue<T> queue, long spinWaitTime) {
        this.queue = queue;
        this.spinWaitTime = spinWaitTime;
    }

    @Override
    public void run() {
        long spinWaitTime = this.spinWaitTime;
        block0: while (true) {
            this.pollTasks(true);
            long start = System.nanoTime();
            do {
                Thread.interrupted();
                LockSupport.parkNanos("Spinwaiting on tasks", 1000L);
                if (this.pollTasks(true)) continue block0;
                if (!this.handleClose()) continue;
                return;
            } while (System.nanoTime() - start < spinWaitTime);
            if (this.handleClose()) {
                return;
            }
            this.parked.set(true);
            if (this.pollTasks(true)) {
                this.parked.set(false);
                continue;
            }
            if (this.handleClose()) {
                return;
            }
            do {
                Thread.interrupted();
                LockSupport.park("Waiting on tasks");
            } while (this.parked.get());
        }
    }

    protected boolean handleClose() {
        if (this.closed) {
            this.pollTasks(true);
            this.handleFlushThreads(true);
            return true;
        }
        return false;
    }

    protected boolean pollTasks(boolean flushTasks) {
        Runnable task;
        boolean ret = false;
        while ((task = (Runnable)this.queue.poll(this.lowestPriorityToPoll)) != null) {
            ret = true;
            try {
                task.run();
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                LOGGER.error("Exception thrown from prioritized runnable task in thread '" + this.getName() + "': " + IOUtil.genericToString(task), throwable);
            }
        }
        if (flushTasks) {
            this.handleFlushThreads(false);
        }
        return ret;
    }

    protected void handleFlushThreads(boolean shutdown) {
        Thread parking;
        ConcurrentLinkedQueue<Thread> flushQueue = this.flushQueue;
        do {
            ++this.flushCycles;
            while ((parking = flushQueue.poll()) != null) {
                LockSupport.unpark(parking);
            }
        } while (this.pollTasks(false));
        if (shutdown) {
            this.flushQueue = null;
            while ((parking = flushQueue.poll()) != null) {
                LockSupport.unpark(parking);
            }
        }
    }

    public boolean notifyTasks() {
        if (this.parked.get() && this.parked.getAndSet(false)) {
            LockSupport.unpark(this);
            return true;
        }
        return false;
    }

    protected void queueTask(T task) {
        this.queue.add(task);
        this.notifyTasks();
    }

    public void flush() {
        Thread currentThread = Thread.currentThread();
        if (currentThread == this) {
            throw new IllegalStateException("Cannot flush the queue executor thread while on the queue executor thread");
        }
        int successes = 0;
        long lastCycle = -1L;
        do {
            ConcurrentLinkedQueue<Thread> flushQueue;
            if ((flushQueue = this.flushQueue) == null) {
                return;
            }
            flushQueue.add(currentThread);
            if (this.flushQueue == null) {
                return;
            }
            long currentCycle = this.flushCycles;
            if (currentCycle == lastCycle) {
                Thread.yield();
                continue;
            }
            this.parked.set(false);
            LockSupport.unpark(this);
            LockSupport.park("flushing queue executor thread");
            if (this.queue.hasTasks()) {
                successes = 0;
                continue;
            }
            ++successes;
        } while (successes != 2);
    }

    public boolean close(boolean wait, boolean killQueue) {
        boolean ret = !killQueue ? false : this.queue.shutdown();
        this.closed = true;
        this.parked.set(false);
        LockSupport.unpark(this);
        if (wait) {
            this.flush();
        }
        return ret;
    }
}

