/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import com.google.common.collect.Collections2;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Set;
import java.util.function.Function;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.BossBarImplementation;
import net.kyori.adventure.bossbar.BossBarViewer;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.BossBattle;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public final class BossBarImplementationImpl
implements BossBar.Listener,
BossBarImplementation {
    private final BossBar bar;
    private BossBattleServer vanilla;

    public BossBarImplementationImpl(BossBar bar) {
        this.bar = bar;
    }

    public void playerShow(CraftPlayer player) {
        if (this.vanilla == null) {
            this.vanilla = new BossBattleServer(PaperAdventure.asVanilla(this.bar.name()), PaperAdventure.asVanilla(this.bar.color()), PaperAdventure.asVanilla(this.bar.overlay()));
            this.vanilla.adventure = this.bar;
            this.bar.addListener((BossBar.Listener)this);
        }
        this.vanilla.a(player.getHandle());
    }

    public void playerHide(CraftPlayer player) {
        if (this.vanilla != null) {
            this.vanilla.b(player.getHandle());
            if (this.vanilla.h().isEmpty()) {
                this.bar.removeListener((BossBar.Listener)this);
                this.vanilla = null;
            }
        }
    }

    public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        this.maybeBroadcast(PacketPlayOutBoss::c);
    }

    public void bossBarProgressChanged(@NonNull BossBar bar, float oldProgress, float newProgress) {
        this.maybeBroadcast(PacketPlayOutBoss::b);
    }

    public void bossBarColorChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color newColor) {
        this.maybeBroadcast(PacketPlayOutBoss::d);
    }

    public void bossBarOverlayChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay newOverlay) {
        this.maybeBroadcast(PacketPlayOutBoss::d);
    }

    public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsAdded, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsRemoved) {
        this.maybeBroadcast(PacketPlayOutBoss::e);
    }

    @NotNull
    public Iterable<? extends BossBarViewer> viewers() {
        return this.vanilla == null ? Set.of() : Collections2.transform(this.vanilla.h(), EntityPlayer::getBukkitEntity);
    }

    private void maybeBroadcast(Function<BossBattle, PacketPlayOutBoss> fn) {
        if (this.vanilla != null) {
            this.vanilla.a(fn);
        }
    }
}

