/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.AsyncChatCommandDecorateEvent;
import io.papermc.paper.event.player.AsyncChatDecorateEvent;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.Optionull;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.util.LazyPlayerSet;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerChatPreviewEvent;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ChatDecorationProcessor {
    private static final String DISPLAY_NAME_TAG = "---paper_dn---";
    private static final Pattern DISPLAY_NAME_PATTERN = Pattern.compile("%(1\\$)?s");
    private static final String CONTENT_TAG = "---paper_content---";
    private static final Pattern CONTENT_PATTERN = Pattern.compile("%(2\\$)?s");
    final MinecraftServer server;
    final @Nullable EntityPlayer player;
    final @Nullable CommandListenerWrapper commandSourceStack;
    final Component originalMessage;

    public ChatDecorationProcessor(MinecraftServer server, @Nullable EntityPlayer player, @Nullable CommandListenerWrapper commandSourceStack, IChatBaseComponent originalMessage) {
        this.server = server;
        this.player = player;
        this.commandSourceStack = commandSourceStack;
        this.originalMessage = PaperAdventure.asAdventure(originalMessage);
    }

    public CompletableFuture<ChatDecorator.Result> process() {
        return CompletableFuture.supplyAsync(() -> {
            ChatDecorator.Result result = new ChatDecorator.ModernResult(this.originalMessage, true, false);
            if (ChatDecorationProcessor.listenToLegacy()) {
                result = this.processLegacy(result);
            }
            return this.processModern(result);
        }, this.server.chatExecutor);
    }

    private static boolean listenToLegacy() {
        return ChatProcessor.canYouHearMe(AsyncPlayerChatPreviewEvent.getHandlerList());
    }

    private ChatDecorator.Result processLegacy(ChatDecorator.Result input) {
        if (this.player != null) {
            CraftPlayer player = this.player.getBukkitEntity();
            String originalMessage = LegacyComponentSerializer.legacySection().serialize(this.originalMessage);
            AsyncPlayerChatPreviewEvent event = new AsyncPlayerChatPreviewEvent(true, (Player)player, originalMessage, (Set)new LazyPlayerSet(this.server));
            this.post((Event)event);
            boolean isDefaultFormat = "<%1$s> %2$s".equals(event.getFormat());
            if (event.isCancelled() || isDefaultFormat && originalMessage.equals(event.getMessage())) {
                return input;
            }
            TextComponent message = LegacyComponentSerializer.legacySection().deserialize(event.getMessage());
            TextComponent component = isDefaultFormat ? message : ChatDecorationProcessor.legacyFormat(event.getFormat(), (CraftPlayer)event.getPlayer(), (Component)LegacyComponentSerializer.legacySection().deserialize(event.getMessage()));
            return ChatDecorationProcessor.legacy((Component)component, event.getFormat(), new ChatDecorator.MessagePair((Component)message, event.getMessage()), isDefaultFormat);
        }
        return input;
    }

    private ChatDecorator.Result processModern(ChatDecorator.Result input) {
        @Nullable CraftPlayer player = Optionull.a(this.player, EntityPlayer::getBukkitEntity);
        Component initialResult = input.message().component();
        Object event = this.commandSourceStack != null ? new AsyncChatCommandDecorateEvent(true, (Player)player, this.originalMessage, initialResult) : new AsyncChatDecorateEvent(true, (Player)player, this.originalMessage, initialResult);
        this.post((Event)event);
        if (!event.isCancelled() && !event.result().equals(initialResult)) {
            if (input instanceof ChatDecorator.LegacyResult) {
                ChatDecorator.LegacyResult legacyResult = (ChatDecorator.LegacyResult)input;
                if (legacyResult.hasNoFormatting()) {
                    return ChatDecorationProcessor.noFormatting(event.result(), legacyResult.format(), legacyResult.message().legacyMessage());
                }
                Component formatted = ChatDecorationProcessor.legacyFormat(legacyResult.format(), player, event.result());
                return ChatDecorationProcessor.withFormatting(formatted, legacyResult.format(), event.result(), legacyResult.message().legacyMessage());
            }
            return new ChatDecorator.ModernResult(event.result(), true, false);
        }
        return input;
    }

    private void post(Event event) {
        this.server.server.getPluginManager().callEvent(event);
    }

    private static Component legacyFormat(String format, @Nullable CraftPlayer player, Component message) {
        ArrayList<TagResolver.Single> args = new ArrayList<TagResolver.Single>(player != null ? 2 : 1);
        if (player != null) {
            args.add(Placeholder.component((String)DISPLAY_NAME_TAG, (ComponentLike)ChatProcessor.displayName(player)));
        }
        args.add(Placeholder.component((String)CONTENT_TAG, (ComponentLike)message));
        String miniMsg = (String)MiniMessage.miniMessage().serialize((Component)LegacyComponentSerializer.legacySection().deserialize(format));
        miniMsg = DISPLAY_NAME_PATTERN.matcher(miniMsg).replaceFirst("<---paper_dn--->");
        miniMsg = CONTENT_PATTERN.matcher(miniMsg).replaceFirst("<---paper_content--->");
        return MiniMessage.miniMessage().deserialize(miniMsg, TagResolver.resolver(args));
    }

    public static ChatDecorator.LegacyResult legacy(Component maybeFormatted, String format, ChatDecorator.MessagePair message, boolean hasNoFormatting) {
        return new ChatDecorator.LegacyResult(maybeFormatted, format, message, hasNoFormatting, false);
    }

    public static ChatDecorator.LegacyResult noFormatting(Component component, String format, String legacyMessage) {
        return new ChatDecorator.LegacyResult(component, format, new ChatDecorator.MessagePair(component, legacyMessage), true, true);
    }

    public static ChatDecorator.LegacyResult withFormatting(Component formatted, String format, Component message, String legacyMessage) {
        return new ChatDecorator.LegacyResult(formatted, format, new ChatDecorator.MessagePair(message, legacyMessage), false, true);
    }
}

