/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure.providers;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.util.Codec;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

final class NBTLegacyHoverEventSerializer
implements LegacyHoverEventSerializer {
    public static final NBTLegacyHoverEventSerializer INSTANCE = new NBTLegacyHoverEventSerializer();
    private static final Codec<NBTTagCompound, String, CommandSyntaxException, RuntimeException> SNBT_CODEC = Codec.codec(MojangsonParser::a, NBTBase::toString);
    static final String ITEM_TYPE = "id";
    static final String ITEM_COUNT = "Count";
    static final String ITEM_TAG = "tag";
    static final String ENTITY_NAME = "name";
    static final String ENTITY_TYPE = "type";
    static final String ENTITY_ID = "id";

    NBTLegacyHoverEventSerializer() {
    }

    public HoverEvent.ShowItem deserializeShowItem(Component input) throws IOException {
        String raw = PlainTextComponentSerializer.plainText().serialize(input);
        try {
            NBTTagCompound contents = (NBTTagCompound)SNBT_CODEC.decode((Object)raw);
            NBTTagCompound tag = contents.p(ITEM_TAG);
            return HoverEvent.ShowItem.of((Key)Key.key((String)contents.l("id")), (int)(contents.e(ITEM_COUNT) ? contents.f(ITEM_COUNT) : (byte)1), tag.g() ? null : BinaryTagHolder.encode((Object)tag, SNBT_CODEC));
        }
        catch (CommandSyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public HoverEvent.ShowEntity deserializeShowEntity(Component input, Codec.Decoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        String raw = PlainTextComponentSerializer.plainText().serialize(input);
        try {
            NBTTagCompound contents = (NBTTagCompound)SNBT_CODEC.decode((Object)raw);
            return HoverEvent.ShowEntity.of((Key)Key.key((String)contents.l(ENTITY_TYPE)), (UUID)UUID.fromString(contents.l("id")), (Component)((Component)componentCodec.decode((Object)contents.l(ENTITY_NAME))));
        }
        catch (CommandSyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public Component serializeShowItem(HoverEvent.ShowItem input) throws IOException {
        NBTTagCompound tag = new NBTTagCompound();
        tag.a("id", input.item().asString());
        tag.a(ITEM_COUNT, (byte)input.count());
        if (input.nbt() != null) {
            try {
                tag.a(ITEM_TAG, (NBTBase)input.nbt().get(SNBT_CODEC));
            }
            catch (CommandSyntaxException ex) {
                throw new IOException(ex);
            }
        }
        return Component.text((String)((String)SNBT_CODEC.encode((Object)tag)));
    }

    public Component serializeShowEntity(HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        NBTTagCompound tag = new NBTTagCompound();
        tag.a("id", input.id().toString());
        tag.a(ENTITY_TYPE, input.type().asString());
        if (input.name() != null) {
            tag.a(ENTITY_NAME, (String)componentCodec.encode((Object)input.name()));
        }
        return Component.text((String)((String)SNBT_CODEC.encode((Object)tag)));
    }
}

