/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.lock.ReentrantAreaLock;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.poi.PoiChunk;
import io.papermc.paper.chunk.system.scheduling.ChunkProgressionTask;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.GenericDataLoadTask;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import org.slf4j.Logger;

public final class ChunkLoadTask
extends ChunkProgressionTask {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private final NewChunkHolder chunkHolder;
    private final ChunkDataLoadTask loadTask;
    private volatile boolean cancelled;
    private NewChunkHolder.GenericDataLoadTaskCallback entityLoadTask;
    private NewChunkHolder.GenericDataLoadTaskCallback poiLoadTask;
    private GenericDataLoadTask.TaskResult<IChunkAccess, Throwable> loadResult;
    private final AtomicInteger taskCountToComplete = new AtomicInteger(3);
    private boolean scheduled;

    protected ChunkLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, NewChunkHolder chunkHolder, PrioritisedExecutor.Priority priority) {
        super(scheduler, world, chunkX, chunkZ);
        this.chunkHolder = chunkHolder;
        this.loadTask = new ChunkDataLoadTask(scheduler, world, chunkX, chunkZ, priority);
        this.loadTask.addCallback(result -> {
            this.loadResult = result;
            this.tryCompleteLoad();
        });
    }

    private void tryCompleteLoad() {
        if (this.taskCountToComplete.decrementAndGet() == 0) {
            GenericDataLoadTask.TaskResult<IChunkAccess, Throwable> result = this.cancelled ? null : this.loadResult;
            this.complete(result == null ? null : result.left(), result == null ? null : result.right());
        }
    }

    @Override
    public ChunkStatus getTargetStatus() {
        return ChunkStatus.c;
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule() {
        NewChunkHolder.GenericDataLoadTaskCallback poiLoadTask;
        NewChunkHolder.GenericDataLoadTaskCallback entityLoadTask;
        Consumer<GenericDataLoadTask.TaskResult<PoiChunk, Throwable>> scheduleLoadTask = result -> this.tryCompleteLoad();
        ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            if (this.scheduled) {
                throw new IllegalStateException("schedule() called twice");
            }
            this.scheduled = true;
            if (this.cancelled) {
                return;
            }
            if (!this.chunkHolder.isEntityChunkNBTLoaded()) {
                entityLoadTask = this.chunkHolder.getOrLoadEntityData(scheduleLoadTask);
            } else {
                entityLoadTask = null;
                this.taskCountToComplete.getAndDecrement();
            }
            if (!this.chunkHolder.isPoiChunkLoaded()) {
                poiLoadTask = this.chunkHolder.getOrLoadPoiData(scheduleLoadTask);
            } else {
                poiLoadTask = null;
                this.taskCountToComplete.getAndDecrement();
            }
            this.entityLoadTask = entityLoadTask;
            this.poiLoadTask = poiLoadTask;
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
        if (entityLoadTask != null) {
            entityLoadTask.schedule();
        }
        if (poiLoadTask != null) {
            poiLoadTask.schedule();
        }
        this.loadTask.schedule(false);
    }

    @Override
    public void cancel() {
        boolean scheduled;
        ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            scheduled = this.scheduled;
            this.cancelled = true;
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
        if (scheduled) {
            if (this.entityLoadTask != null && this.entityLoadTask.cancel()) {
                this.tryCompleteLoad();
            }
            if (this.poiLoadTask != null && this.poiLoadTask.cancel()) {
                this.tryCompleteLoad();
            }
        } else {
            this.tryCompleteLoad();
            this.tryCompleteLoad();
        }
        this.loadTask.cancel();
    }

    @Override
    public PrioritisedExecutor.Priority getPriority() {
        return this.loadTask.getPriority();
    }

    @Override
    public void lowerPriority(PrioritisedExecutor.Priority priority) {
        PoiDataLoadTask poiLoad;
        EntityDataLoadTask entityLoad = this.chunkHolder.getEntityDataLoadTask();
        if (entityLoad != null) {
            entityLoad.lowerPriority(priority);
        }
        if ((poiLoad = this.chunkHolder.getPoiDataLoadTask()) != null) {
            poiLoad.lowerPriority(priority);
        }
        this.loadTask.lowerPriority(priority);
    }

    @Override
    public void setPriority(PrioritisedExecutor.Priority priority) {
        PoiDataLoadTask poiLoad;
        EntityDataLoadTask entityLoad = this.chunkHolder.getEntityDataLoadTask();
        if (entityLoad != null) {
            entityLoad.setPriority(priority);
        }
        if ((poiLoad = this.chunkHolder.getPoiDataLoadTask()) != null) {
            poiLoad.setPriority(priority);
        }
        this.loadTask.setPriority(priority);
    }

    @Override
    public void raisePriority(PrioritisedExecutor.Priority priority) {
        PoiDataLoadTask poiLoad;
        EntityDataLoadTask entityLoad = this.chunkHolder.getEntityDataLoadTask();
        if (entityLoad != null) {
            entityLoad.raisePriority(priority);
        }
        if ((poiLoad = this.chunkHolder.getPoiDataLoadTask()) != null) {
            poiLoad.raisePriority(priority);
        }
        this.loadTask.raisePriority(priority);
    }

    public static final class ChunkDataLoadTask
    extends CallbackDataLoadTask<IChunkAccess, IChunkAccess> {
        protected ChunkDataLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, PrioritisedExecutor.Priority priority) {
            super(scheduler, world, chunkX, chunkZ, RegionFileIOThread.RegionFileType.CHUNK_DATA, priority);
        }

        @Override
        protected boolean hasOffMain() {
            return true;
        }

        @Override
        protected boolean hasOnMain() {
            return false;
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOffMain(Runnable run, PrioritisedExecutor.Priority priority) {
            return this.scheduler.loadExecutor.createTask(run, priority);
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOnMain(Runnable run, PrioritisedExecutor.Priority priority) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected GenericDataLoadTask.TaskResult<IChunkAccess, Throwable> completeOnMainOffMain(IChunkAccess data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        private ProtoChunk getEmptyChunk() {
            return new ProtoChunk(new ChunkCoordIntPair(this.chunkX, this.chunkZ), ChunkConverter.a, this.world, this.world.G_().d(Registries.ap), null);
        }

        @Override
        protected GenericDataLoadTask.TaskResult<IChunkAccess, Throwable> runOffMain(NBTTagCompound data, Throwable throwable) {
            if (throwable != null) {
                LOGGER.error("Failed to load chunk data for task: " + this.toString() + ", chunk data will be lost", throwable);
                return new GenericDataLoadTask.TaskResult<ProtoChunk, Object>(this.getEmptyChunk(), null);
            }
            if (data == null) {
                return new GenericDataLoadTask.TaskResult<ProtoChunk, Object>(this.getEmptyChunk(), null);
            }
            try {
                ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(this.chunkX, this.chunkZ);
                PlayerChunkMap chunkMap = this.world.k().a;
                NBTTagCompound converted = chunkMap.upgradeChunkTag(this.world.getTypeKey(), chunkMap.w, data, chunkMap.t.b(), chunkPos, this.world);
                ChunkRegionLoader.InProgressChunkHolder chunkHolder = ChunkRegionLoader.loadChunk(this.world, chunkMap.m(), chunkPos, converted, true);
                return new GenericDataLoadTask.TaskResult<ProtoChunk, Object>(chunkHolder.protoChunk, null);
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable thr2) {
                LOGGER.error("Failed to parse chunk data for task: " + this.toString() + ", chunk data will be lost", thr2);
                return new GenericDataLoadTask.TaskResult<ProtoChunk, Object>(this.getEmptyChunk(), null);
            }
        }

        @Override
        protected GenericDataLoadTask.TaskResult<IChunkAccess, Throwable> runOnMain(IChunkAccess data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class EntityDataLoadTask
    extends CallbackDataLoadTask<NBTTagCompound, NBTTagCompound> {
        public EntityDataLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, PrioritisedExecutor.Priority priority) {
            super(scheduler, world, chunkX, chunkZ, RegionFileIOThread.RegionFileType.ENTITY_DATA, priority);
        }

        @Override
        protected boolean hasOffMain() {
            return true;
        }

        @Override
        protected boolean hasOnMain() {
            return false;
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOffMain(Runnable run, PrioritisedExecutor.Priority priority) {
            return this.scheduler.loadExecutor.createTask(run, priority);
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOnMain(Runnable run, PrioritisedExecutor.Priority priority) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected GenericDataLoadTask.TaskResult<NBTTagCompound, Throwable> completeOnMainOffMain(NBTTagCompound data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected GenericDataLoadTask.TaskResult<NBTTagCompound, Throwable> runOffMain(NBTTagCompound data, Throwable throwable) {
            if (throwable != null) {
                LOGGER.error("Failed to load entity data for task: " + this.toString() + ", entity data will be lost", throwable);
                return new GenericDataLoadTask.TaskResult<Object, Object>(null, null);
            }
            if (data == null || data.g()) {
                return new GenericDataLoadTask.TaskResult<Object, Object>(null, null);
            }
            try {
                return new GenericDataLoadTask.TaskResult<NBTTagCompound, Object>(EntityStorage.b(data.h()), null);
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable thr2) {
                LOGGER.error("Failed to run converters for entity data for task: " + this.toString() + ", entity data will be lost", thr2);
                return new GenericDataLoadTask.TaskResult<Object, Throwable>(null, thr2);
            }
        }

        @Override
        protected GenericDataLoadTask.TaskResult<NBTTagCompound, Throwable> runOnMain(NBTTagCompound data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class PoiDataLoadTask
    extends CallbackDataLoadTask<PoiChunk, PoiChunk> {
        public PoiDataLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, PrioritisedExecutor.Priority priority) {
            super(scheduler, world, chunkX, chunkZ, RegionFileIOThread.RegionFileType.POI_DATA, priority);
        }

        @Override
        protected boolean hasOffMain() {
            return true;
        }

        @Override
        protected boolean hasOnMain() {
            return false;
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOffMain(Runnable run, PrioritisedExecutor.Priority priority) {
            return this.scheduler.loadExecutor.createTask(run, priority);
        }

        @Override
        protected PrioritisedExecutor.PrioritisedTask createOnMain(Runnable run, PrioritisedExecutor.Priority priority) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected GenericDataLoadTask.TaskResult<PoiChunk, Throwable> completeOnMainOffMain(PoiChunk data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected GenericDataLoadTask.TaskResult<PoiChunk, Throwable> runOffMain(NBTTagCompound data, Throwable throwable) {
            if (throwable != null) {
                LOGGER.error("Failed to load poi data for task: " + this.toString() + ", poi data will be lost", throwable);
                return new GenericDataLoadTask.TaskResult<PoiChunk, Object>(PoiChunk.empty(this.world, this.chunkX, this.chunkZ), null);
            }
            if (data == null || data.g()) {
                return new GenericDataLoadTask.TaskResult<PoiChunk, Object>(PoiChunk.empty(this.world, this.chunkX, this.chunkZ), null);
            }
            try {
                data = data.h();
                int dataVersion = !data.b("DataVersion", 99) ? 1945 : data.h("DataVersion");
                NBTTagCompound converted = MCDataConverter.convertTag(MCTypeRegistry.POI_CHUNK, data, dataVersion, SharedConstants.b().d().c());
                return new GenericDataLoadTask.TaskResult<PoiChunk, Object>(PoiChunk.parse(this.world, this.chunkX, this.chunkZ, converted), null);
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable thr2) {
                LOGGER.error("Failed to run parse poi data for task: " + this.toString() + ", poi data will be lost", thr2);
                return new GenericDataLoadTask.TaskResult<PoiChunk, Object>(PoiChunk.empty(this.world, this.chunkX, this.chunkZ), null);
            }
        }

        @Override
        protected GenericDataLoadTask.TaskResult<PoiChunk, Throwable> runOnMain(PoiChunk data, Throwable throwable) {
            throw new UnsupportedOperationException();
        }
    }

    protected static abstract class CallbackDataLoadTask<OnMain, FinalCompletion>
    extends GenericDataLoadTask<OnMain, FinalCompletion> {
        private GenericDataLoadTask.TaskResult<FinalCompletion, Throwable> result;
        private final MultiThreadedQueue<Consumer<GenericDataLoadTask.TaskResult<FinalCompletion, Throwable>>> waiters = new MultiThreadedQueue();
        protected volatile boolean completed;
        protected static final VarHandle COMPLETED_HANDLE = ConcurrentUtil.getVarHandle(CallbackDataLoadTask.class, "completed", Boolean.TYPE);

        protected CallbackDataLoadTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, RegionFileIOThread.RegionFileType type, PrioritisedExecutor.Priority priority) {
            super(scheduler, world, chunkX, chunkZ, type, priority);
        }

        public void addCallback(Consumer<GenericDataLoadTask.TaskResult<FinalCompletion, Throwable>> consumer) {
            block3: {
                if (!this.waiters.add(consumer)) {
                    try {
                        consumer.accept(this.result);
                    }
                    catch (Throwable throwable) {
                        this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Consumer", ChunkTaskScheduler.stringIfNull(consumer), "Completed throwable", ChunkTaskScheduler.stringIfNull(this.result.right())), throwable);
                        if (!(throwable instanceof ThreadDeath)) break block3;
                        throw (ThreadDeath)throwable;
                    }
                }
            }
        }

        @Override
        protected void onComplete(GenericDataLoadTask.TaskResult<FinalCompletion, Throwable> result) {
            Consumer<GenericDataLoadTask.TaskResult<FinalCompletion, Throwable>> consumer;
            if (COMPLETED_HANDLE.getAndSet(this, true)) {
                throw new IllegalStateException("Already completed");
            }
            this.result = result;
            while ((consumer = this.waiters.pollOrBlockAdds()) != null) {
                try {
                    consumer.accept(result);
                }
                catch (Throwable throwable) {
                    this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Consumer", ChunkTaskScheduler.stringIfNull(consumer), "Completed throwable", ChunkTaskScheduler.stringIfNull(result.right())), throwable);
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    return;
                }
            }
        }
    }
}

