/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.scheduling.ChunkProgressionTask;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import org.slf4j.Logger;

public final class ChunkUpgradeGenericStatusTask
extends ChunkProgressionTask
implements Runnable {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    protected final IChunkAccess fromChunk;
    protected final ChunkStatus fromStatus;
    protected final ChunkStatus toStatus;
    protected final List<IChunkAccess> neighbours;
    protected final PrioritisedExecutor.PrioritisedTask generateTask;
    protected volatile boolean scheduled;
    protected static final VarHandle SCHEDULED_HANDLE = ConcurrentUtil.getVarHandle(ChunkUpgradeGenericStatusTask.class, "scheduled", Boolean.TYPE);

    public ChunkUpgradeGenericStatusTask(ChunkTaskScheduler scheduler, WorldServer world, int chunkX, int chunkZ, IChunkAccess chunk, List<IChunkAccess> neighbours, ChunkStatus toStatus, PrioritisedExecutor.Priority priority) {
        super(scheduler, world, chunkX, chunkZ);
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + priority);
        }
        this.fromChunk = chunk;
        this.fromStatus = chunk.j();
        this.toStatus = toStatus;
        this.neighbours = neighbours;
        this.generateTask = this.toStatus.isParallelCapable ? this.scheduler.parallelGenExecutor.createTask(this, priority) : this.scheduler.radiusAwareScheduler.createTask(chunkX, chunkZ, this.toStatus.writeRadius, this, priority);
    }

    @Override
    public ChunkStatus getTargetStatus() {
        return this.toStatus;
    }

    private boolean isEmptyTask() {
        boolean generation = !this.fromStatus.b(this.toStatus);
        return generation && this.toStatus.isEmptyGenStatus() || !generation && this.toStatus.isEmptyLoadStatus();
    }

    @Override
    public void run() {
        IChunkAccess newChunk;
        Either<IChunkAccess, PlayerChunk.Failure> either2;
        CompletionStage<Either<IChunkAccess, PlayerChunk.Failure>> completeFuture;
        boolean generation;
        IChunkAccess chunk = this.fromChunk;
        ChunkProviderServer serverChunkCache = this.world.I;
        PlayerChunkMap chunkMap = serverChunkCache.a;
        boolean completing = false;
        try {
            boolean bl = generation = !chunk.j().b(this.toStatus);
            if (generation) {
                if (this.toStatus.isEmptyGenStatus()) {
                    if (chunk instanceof ProtoChunk) {
                        ((ProtoChunk)chunk).a(this.toStatus);
                    }
                    completing = true;
                    this.complete(chunk, null);
                    return;
                }
                completeFuture = this.toStatus.a(Runnable::run, this.world, chunkMap.t, chunkMap.H, serverChunkCache.a(), null, this.neighbours).whenComplete((either, throwable) -> {
                    IChunkAccess newChunk;
                    IChunkAccess iChunkAccess = newChunk = either == null ? null : (IChunkAccess)either.left().orElse(null);
                    if (newChunk instanceof ProtoChunk) {
                        ((ProtoChunk)newChunk).a(this.toStatus);
                    }
                });
            } else {
                if (this.toStatus.isEmptyLoadStatus()) {
                    completing = true;
                    this.complete(chunk, null);
                    return;
                }
                completeFuture = this.toStatus.a(this.world, chunkMap.H, serverChunkCache.a(), null, chunk);
            }
        }
        catch (Throwable throwable2) {
            if (!completing) {
                this.complete(null, throwable2);
                if (throwable2 instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable2;
                }
                return;
            }
            this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Target status", ChunkTaskScheduler.stringIfNull(this.toStatus), "From status", ChunkTaskScheduler.stringIfNull(this.fromStatus), "Generation task", this), throwable2);
            if (throwable2 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable2;
            }
            LOGGER.error("Failed to complete status for chunk: status:" + this.toStatus + ", chunk: (" + this.chunkX + "," + this.chunkZ + "), world: " + this.world.getWorld().getName(), throwable2);
            return;
        }
        if (!completeFuture.isDone() && !this.toStatus.warnedAboutNoImmediateComplete.getAndSet(true)) {
            LOGGER.warn("Future status not complete after scheduling: " + this.toStatus.toString() + ", generate: " + generation);
        }
        try {
            either2 = completeFuture.join();
            newChunk = either2 == null ? null : (IChunkAccess)either2.left().orElse(null);
        }
        catch (Throwable throwable3) {
            this.complete(null, throwable3);
            if (throwable3 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable3;
            }
            return;
        }
        if (newChunk == null) {
            this.complete(null, new IllegalStateException("Chunk for status: " + this.toStatus.toString() + ", generation: " + generation + " should not be null! Either: " + either2).fillInStackTrace());
            return;
        }
        this.complete(newChunk, null);
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public void schedule() {
        if (SCHEDULED_HANDLE.getAndSet(this, true)) {
            throw new IllegalStateException("Cannot double call schedule()");
        }
        if (this.isEmptyTask()) {
            if (this.generateTask.cancel()) {
                this.run();
            }
        } else {
            this.generateTask.queue();
        }
    }

    @Override
    public void cancel() {
        if (this.generateTask.cancel()) {
            this.complete(null, null);
        }
    }

    @Override
    public PrioritisedExecutor.Priority getPriority() {
        return this.generateTask.getPriority();
    }

    @Override
    public void lowerPriority(PrioritisedExecutor.Priority priority) {
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + priority);
        }
        this.generateTask.lowerPriority(priority);
    }

    @Override
    public void setPriority(PrioritisedExecutor.Priority priority) {
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + priority);
        }
        this.generateTask.setPriority(priority);
    }

    @Override
    public void raisePriority(PrioritisedExecutor.Priority priority) {
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + priority);
        }
        this.generateTask.raisePriority(priority);
    }
}

