/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.completable.Completable;
import ca.spottedleaf.concurrentutil.executor.Cancellable;
import ca.spottedleaf.concurrentutil.executor.standard.DelayedPrioritisedTask;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.lock.ReentrantAreaLock;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.poi.PoiChunk;
import io.papermc.paper.chunk.system.scheduling.ChunkHolderManager;
import io.papermc.paper.chunk.system.scheduling.ChunkLoadTask;
import io.papermc.paper.chunk.system.scheduling.ChunkProgressionTask;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.GenericDataLoadTask;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.WorldUtil;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import org.slf4j.Logger;

public final class NewChunkHolder {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    public static final Thread.UncaughtExceptionHandler CHUNKSYSTEM_UNCAUGHT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (!(throwable instanceof ThreadDeath)) {
                LOGGER.error("Uncaught exception in thread " + thread.getName(), throwable);
            }
        }
    };
    public final WorldServer world;
    public final int chunkX;
    public final int chunkZ;
    public final ChunkTaskScheduler scheduler;
    private ChunkEntitySlices entityChunk;
    private NBTTagCompound pendingEntityChunk;
    private static final NBTTagCompound EMPTY_ENTITY_CHUNK = new NBTTagCompound();
    private ChunkLoadTask.EntityDataLoadTask entityDataLoadTask;
    private List<GenericDataLoadTaskCallback> entityDataLoadTaskWaiters;
    private PoiChunk poiChunk;
    private ChunkLoadTask.PoiDataLoadTask poiDataLoadTask;
    private List<GenericDataLoadTaskCallback> poiDataLoadTaskWaiters;
    private IChunkAccess currentChunk;
    private ChunkStatus currentGenStatus;
    private volatile ChunkCompletion lastChunkCompletion;
    private ChunkStatus requestedGenStatus;
    private ChunkProgressionTask generationTask;
    private ChunkStatus generationTaskStatus;
    protected final ReferenceLinkedOpenHashSet<NewChunkHolder> neighboursBlockingGenTask = new ReferenceLinkedOpenHashSet(4);
    protected final Reference2ObjectLinkedOpenHashMap<NewChunkHolder, ChunkStatus> neighboursWaitingForUs = new Reference2ObjectLinkedOpenHashMap();
    private PrioritisedExecutor.Priority priority = PrioritisedExecutor.Priority.NORMAL;
    private boolean priorityLocked;
    private PrioritisedExecutor.Priority neighbourRequestedPriority = PrioritisedExecutor.Priority.IDLE;
    private ChunkStatus failedGenStatus;
    private Throwable genTaskException;
    private Thread genTaskFailedThread;
    private boolean failedLightUpdate;
    private int oldTicketLevel = ChunkLevel.a + 1;
    private int currentTicketLevel = ChunkLevel.a + 1;
    public final PlayerChunk vanillaChunkHolder;
    protected ProtoChunkExtension wrappedChunkForNeighbour;
    private int totalNeighboursUsingThisChunk = 0;
    boolean killed;
    private UnloadTask chunkDataUnload;
    private UnloadTask entityDataUnload;
    private UnloadTask poiDataUnload;
    private UnloadState unloadState;
    static final int NEIGHBOUR_RADIUS = 2;
    private long fullNeighbourChunksLoadedBitset;
    private volatile long chunkStatus;
    private static final long PENDING_STATUS_MASK = -4294967296L;
    private static final FullChunkStatus[] CHUNK_STATUS_BY_ID = FullChunkStatus.values();
    private static final VarHandle CHUNK_STATUS_HANDLE = ConcurrentUtil.getVarHandle(NewChunkHolder.class, "chunkStatus", Long.TYPE);
    private boolean processingFullStatus = false;
    private final Reference2ObjectOpenHashMap<ChunkStatus, List<Consumer<IChunkAccess>>> statusWaiters = new Reference2ObjectOpenHashMap();
    private final Reference2ObjectOpenHashMap<FullChunkStatus, List<Consumer<Chunk>>> fullStatusWaiters = new Reference2ObjectOpenHashMap();
    public long lastAutoSave;
    private boolean lastEntitySaveNull;
    private NBTTagCompound lastEntityUnload;
    private boolean lastPoiSaveNull;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChunkEntitySlices loadInEntityChunk(boolean transientChunk) {
        NBTTagCompound entityChunk;
        ChunkEntitySlices ret;
        TickThread.ensureTickThread(this.world, this.chunkX, this.chunkZ, "Cannot sync load entity data off-main");
        ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            if (this.entityChunk != null && (transientChunk || !this.entityChunk.isTransient())) {
                ChunkEntitySlices chunkEntitySlices = this.entityChunk;
                return chunkEntitySlices;
            }
            NBTTagCompound pendingEntityChunk = this.pendingEntityChunk;
            if (!transientChunk && pendingEntityChunk == null) {
                throw new IllegalStateException("Must load entity data from disk before loading in the entity chunk!");
            }
            if (this.entityChunk == null) {
                ret = this.entityChunk = new ChunkEntitySlices(this.world, this.chunkX, this.chunkZ, this.getChunkStatus(), WorldUtil.getMinSection(this.world), WorldUtil.getMaxSection(this.world));
                ret.setTransient(transientChunk);
                this.world.getEntityLookup().entitySectionLoad(this.chunkX, this.chunkZ, ret);
            } else {
                ret = this.entityChunk;
                this.entityChunk.setTransient(false);
            }
            if (!transientChunk) {
                this.pendingEntityChunk = null;
                entityChunk = pendingEntityChunk == EMPTY_ENTITY_CHUNK ? null : pendingEntityChunk;
            } else {
                entityChunk = null;
            }
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
        if (!transientChunk && entityChunk != null) {
            List<Entity> entities = EntityStorage.readEntities(this.world, entityChunk);
            this.world.getEntityLookup().addEntityChunkEntities(entities, new ChunkCoordIntPair(this.chunkX, this.chunkZ));
        }
        return ret;
    }

    public ChunkLoadTask.EntityDataLoadTask getEntityDataLoadTask() {
        return this.entityDataLoadTask;
    }

    public boolean isEntityChunkNBTLoaded() {
        return this.entityChunk != null && !this.entityChunk.isTransient() || this.pendingEntityChunk != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeEntityLoad(GenericDataLoadTask.TaskResult<NBTTagCompound, Throwable> result) {
        List<GenericDataLoadTaskCallback> completeWaiters;
        GenericDataLoadTask entityDataLoadTask = null;
        boolean scheduleEntityTask = false;
        ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            List<GenericDataLoadTaskCallback> waiters = this.entityDataLoadTaskWaiters;
            this.entityDataLoadTask = null;
            if (result != null) {
                this.entityDataLoadTaskWaiters = null;
                NBTTagCompound nBTTagCompound = this.pendingEntityChunk = result.left() == null ? EMPTY_ENTITY_CHUNK : result.left();
                if (result.right() != null) {
                    LOGGER.error("Unhandled entity data load exception, data data will be lost: ", result.right());
                }
                for (GenericDataLoadTaskCallback callback : waiters) {
                    callback.markCompleted();
                }
                completeWaiters = waiters;
            } else {
                completeWaiters = null;
                if (waiters.isEmpty()) {
                    this.entityDataLoadTaskWaiters = null;
                } else {
                    this.entityDataLoadTask = new ChunkLoadTask.EntityDataLoadTask(this.scheduler, this.world, this.chunkX, this.chunkZ, this.getEffectivePriority());
                    entityDataLoadTask = this.entityDataLoadTask;
                    ((ChunkLoadTask.EntityDataLoadTask)entityDataLoadTask).addCallback(this::completeEntityLoad);
                    for (GenericDataLoadTaskCallback callback : waiters) {
                        scheduleEntityTask |= entityDataLoadTask.schedule(true);
                    }
                }
            }
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
        if (scheduleEntityTask) {
            entityDataLoadTask.scheduleNow();
        }
        if (completeWaiters != null) {
            for (GenericDataLoadTaskCallback callback : completeWaiters) {
                callback.acceptCompleted(result);
            }
        }
        schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            this.checkUnload();
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
    }

    public GenericDataLoadTaskCallback getOrLoadEntityData(Consumer<GenericDataLoadTask.TaskResult<NBTTagCompound, Throwable>> consumer) {
        if (this.isEntityChunkNBTLoaded()) {
            throw new IllegalStateException("Cannot load entity data, it is already loaded");
        }
        if (!this.scheduler.schedulingLockArea.isHeldByCurrentThread(this.chunkX, this.chunkZ)) {
            throw new IllegalStateException("Must hold scheduling lock");
        }
        EntityDataLoadTaskCallback ret = new EntityDataLoadTaskCallback(consumer, this);
        if (this.entityDataLoadTask == null) {
            this.entityDataLoadTask = new ChunkLoadTask.EntityDataLoadTask(this.scheduler, this.world, this.chunkX, this.chunkZ, this.getEffectivePriority());
            this.entityDataLoadTask.addCallback(this::completeEntityLoad);
            this.entityDataLoadTaskWaiters = new ArrayList<GenericDataLoadTaskCallback>();
        }
        this.entityDataLoadTaskWaiters.add(ret);
        if (this.entityDataLoadTask.schedule(true)) {
            ret.schedule = this.entityDataLoadTask;
        }
        this.checkUnload();
        return ret;
    }

    public ChunkLoadTask.PoiDataLoadTask getPoiDataLoadTask() {
        return this.poiDataLoadTask;
    }

    public boolean isPoiChunkLoaded() {
        return this.poiChunk != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completePoiLoad(GenericDataLoadTask.TaskResult<PoiChunk, Throwable> result) {
        List<GenericDataLoadTaskCallback> completeWaiters;
        GenericDataLoadTask poiDataLoadTask = null;
        boolean schedulePoiTask = false;
        ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            List<GenericDataLoadTaskCallback> waiters = this.poiDataLoadTaskWaiters;
            this.poiDataLoadTask = null;
            if (result != null) {
                this.poiDataLoadTaskWaiters = null;
                this.poiChunk = result.left();
                if (result.right() != null) {
                    LOGGER.error("Unhandled poi load exception, poi data will be lost: ", result.right());
                }
                for (GenericDataLoadTaskCallback callback : waiters) {
                    callback.markCompleted();
                }
                completeWaiters = waiters;
            } else {
                completeWaiters = null;
                if (waiters.isEmpty()) {
                    this.poiDataLoadTaskWaiters = null;
                } else {
                    this.poiDataLoadTask = new ChunkLoadTask.PoiDataLoadTask(this.scheduler, this.world, this.chunkX, this.chunkZ, this.getEffectivePriority());
                    poiDataLoadTask = this.poiDataLoadTask;
                    ((ChunkLoadTask.PoiDataLoadTask)poiDataLoadTask).addCallback(this::completePoiLoad);
                    for (GenericDataLoadTaskCallback callback : waiters) {
                        schedulePoiTask |= poiDataLoadTask.schedule(true);
                    }
                }
            }
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
        if (schedulePoiTask) {
            poiDataLoadTask.scheduleNow();
        }
        if (completeWaiters != null) {
            for (GenericDataLoadTaskCallback callback : completeWaiters) {
                callback.acceptCompleted(result);
            }
        }
        schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            this.checkUnload();
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
    }

    public GenericDataLoadTaskCallback getOrLoadPoiData(Consumer<GenericDataLoadTask.TaskResult<PoiChunk, Throwable>> consumer) {
        if (this.isPoiChunkLoaded()) {
            throw new IllegalStateException("Cannot load poi data, it is already loaded");
        }
        if (!this.scheduler.schedulingLockArea.isHeldByCurrentThread(this.chunkX, this.chunkZ)) {
            throw new IllegalStateException("Must hold scheduling lock");
        }
        PoiDataLoadTaskCallback ret = new PoiDataLoadTaskCallback(consumer, this);
        if (this.poiDataLoadTask == null) {
            this.poiDataLoadTask = new ChunkLoadTask.PoiDataLoadTask(this.scheduler, this.world, this.chunkX, this.chunkZ, this.getEffectivePriority());
            this.poiDataLoadTask.addCallback(this::completePoiLoad);
            this.poiDataLoadTaskWaiters = new ArrayList<GenericDataLoadTaskCallback>();
        }
        this.poiDataLoadTaskWaiters.add(ret);
        if (this.poiDataLoadTask.schedule(true)) {
            ret.schedule = this.poiDataLoadTask;
        }
        this.checkUnload();
        return ret;
    }

    public ChunkCompletion getLastChunkCompletion() {
        return this.lastChunkCompletion;
    }

    public void addGenerationBlockingNeighbour(NewChunkHolder neighbour) {
        this.neighboursBlockingGenTask.add((Object)neighbour);
    }

    public void addWaitingNeighbour(NewChunkHolder neighbour, ChunkStatus requiredStatus) {
        boolean wasEmpty = this.neighboursWaitingForUs.isEmpty();
        this.neighboursWaitingForUs.put((Object)neighbour, (Object)requiredStatus);
        if (wasEmpty) {
            this.checkUnload();
        }
    }

    public PrioritisedExecutor.Priority getEffectivePriority() {
        return PrioritisedExecutor.Priority.max(this.priority, this.neighbourRequestedPriority);
    }

    protected void recalculateNeighbourRequestedPriority() {
        if (this.neighboursWaitingForUs.isEmpty()) {
            this.neighbourRequestedPriority = PrioritisedExecutor.Priority.IDLE;
            return;
        }
        PrioritisedExecutor.Priority max = PrioritisedExecutor.Priority.IDLE;
        for (NewChunkHolder holder : this.neighboursWaitingForUs.keySet()) {
            PrioritisedExecutor.Priority neighbourPriority = holder.getEffectivePriority();
            if (!neighbourPriority.isHigherPriority(max)) continue;
            max = neighbourPriority;
        }
        PrioritisedExecutor.Priority current = this.getEffectivePriority();
        this.neighbourRequestedPriority = max;
        PrioritisedExecutor.Priority next = this.getEffectivePriority();
        if (current == next) {
            return;
        }
        if (this.generationTask != null) {
            this.generationTask.setPriority(next);
        }
        this.recalculateNeighbourPriorities();
    }

    public void recalculateNeighbourPriorities() {
        for (NewChunkHolder holder : this.neighboursBlockingGenTask) {
            holder.recalculateNeighbourRequestedPriority();
        }
    }

    public void raisePriority(PrioritisedExecutor.Priority priority) {
        if (this.priority != null && this.priority.isHigherOrEqualPriority(priority)) {
            return;
        }
        this.setPriority(priority);
    }

    private void lockPriority() {
        this.priority = PrioritisedExecutor.Priority.NORMAL;
        this.priorityLocked = true;
    }

    public void setPriority(PrioritisedExecutor.Priority priority) {
        if (this.priorityLocked) {
            return;
        }
        PrioritisedExecutor.Priority old = this.getEffectivePriority();
        this.priority = priority;
        PrioritisedExecutor.Priority newPriority = this.getEffectivePriority();
        if (old != newPriority && this.generationTask != null) {
            this.generationTask.setPriority(newPriority);
        }
        this.recalculateNeighbourPriorities();
    }

    public void lowerPriority(PrioritisedExecutor.Priority priority) {
        if (this.priority != null && this.priority.isLowerOrEqualPriority(priority)) {
            return;
        }
        this.setPriority(priority);
    }

    public void failedLightUpdate() {
        this.failedLightUpdate = true;
    }

    public boolean hasFailedGeneration() {
        return this.genTaskException != null;
    }

    public int getTicketLevel() {
        return this.currentTicketLevel;
    }

    public NewChunkHolder(WorldServer world, int chunkX, int chunkZ, ChunkTaskScheduler scheduler) {
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.scheduler = scheduler;
        this.vanillaChunkHolder = new PlayerChunk(new ChunkCoordIntPair(chunkX, chunkZ), world, world.x_(), world.I.a, this);
    }

    public IChunkAccess getChunkForNeighbourAccess() {
        IChunkAccess iChunkAccess;
        if (this.wrappedChunkForNeighbour != null) {
            return this.wrappedChunkForNeighbour;
        }
        IChunkAccess ret = this.currentChunk;
        if (ret instanceof Chunk) {
            Chunk fullChunk = (Chunk)ret;
            this.wrappedChunkForNeighbour = new ProtoChunkExtension(fullChunk, false);
            iChunkAccess = this.wrappedChunkForNeighbour;
        } else {
            iChunkAccess = ret;
        }
        return iChunkAccess;
    }

    public IChunkAccess getCurrentChunk() {
        return this.currentChunk;
    }

    int getCurrentTicketLevel() {
        return this.currentTicketLevel;
    }

    void updateTicketLevel(int toLevel) {
        this.currentTicketLevel = toLevel;
    }

    public void addNeighbourUsingChunk() {
        int now;
        if ((now = ++this.totalNeighboursUsingThisChunk) == 1) {
            this.checkUnload();
        }
    }

    public void removeNeighbourUsingChunk() {
        int now;
        if ((now = --this.totalNeighboursUsingThisChunk) == 0) {
            this.checkUnload();
        }
        if (now < 0) {
            throw new IllegalStateException("Neighbours using this chunk cannot be negative");
        }
    }

    public final String isSafeToUnload() {
        if (this.oldTicketLevel <= ChunkHolderManager.MAX_TICKET_LEVEL) {
            return "ticket_level";
        }
        if (this.totalNeighboursUsingThisChunk != 0) {
            return "neighbours_generating";
        }
        if (!this.neighboursWaitingForUs.isEmpty()) {
            return "neighbours_waiting";
        }
        if (this.getChunkStatus() != FullChunkStatus.a) {
            return "fullchunkstatus";
        }
        if (this.generationTask != null) {
            return "generating";
        }
        if (this.requestedGenStatus != null) {
            return "requested_generation";
        }
        if (this.entityDataLoadTask != null) {
            return "entity_data_requested";
        }
        if (this.poiDataLoadTask != null) {
            return "poi_data_requested";
        }
        if (this.entityDataUnload != null) {
            return "entity_serialization";
        }
        if (this.poiDataUnload != null) {
            return "poi_serialization";
        }
        if (this.chunkDataUnload != null) {
            return "chunk_serialization";
        }
        return null;
    }

    private void checkUnload() {
        if (this.killed) {
            return;
        }
        if (this.isSafeToUnload() == null) {
            this.scheduler.chunkHolderManager.unloadQueue.addChunk(this.chunkX, this.chunkZ);
        } else {
            this.scheduler.chunkHolderManager.unloadQueue.removeChunk(this.chunkX, this.chunkZ);
        }
    }

    public UnloadTask getUnloadTask(RegionFileIOThread.RegionFileType type) {
        switch (type) {
            case CHUNK_DATA: {
                return this.chunkDataUnload;
            }
            case ENTITY_DATA: {
                return this.entityDataUnload;
            }
            case POI_DATA: {
                return this.poiDataUnload;
            }
        }
        throw new IllegalStateException("Unknown regionfile type " + type);
    }

    UnloadState unloadStage1() {
        IChunkAccess chunk = this.currentChunk;
        ChunkEntitySlices entityChunk = this.entityChunk;
        PoiChunk poiChunk = this.poiChunk;
        this.currentChunk = null;
        this.currentGenStatus = null;
        this.wrappedChunkForNeighbour = null;
        this.lastChunkCompletion = null;
        this.entityChunk = null;
        this.pendingEntityChunk = null;
        this.poiChunk = null;
        this.priorityLocked = false;
        if (chunk != null) {
            this.chunkDataUnload = new UnloadTask(new Completable<NBTTagCompound>(), new DelayedPrioritisedTask(PrioritisedExecutor.Priority.NORMAL));
        }
        if (poiChunk != null) {
            this.poiDataUnload = new UnloadTask(new Completable<NBTTagCompound>(), null);
        }
        if (entityChunk != null) {
            this.entityDataUnload = new UnloadTask(new Completable<NBTTagCompound>(), null);
        }
        this.unloadState = chunk != null || entityChunk != null || poiChunk != null ? new UnloadState(this, chunk, entityChunk, poiChunk) : null;
        return this.unloadState;
    }

    void completeAsyncChunkDataSave(NBTTagCompound data) {
        if (data != null) {
            RegionFileIOThread.scheduleSave(this.world, this.chunkX, this.chunkZ, data, RegionFileIOThread.RegionFileType.CHUNK_DATA);
        }
        this.chunkDataUnload.completable().complete(data);
        ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
        try {
            this.chunkDataUnload = null;
            this.checkUnload();
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void unloadStage2(UnloadState state) {
        this.unloadState = null;
        chunk = state.chunk();
        entityChunk = state.entityChunk();
        poiChunk = state.poiChunk();
        if (!(chunk instanceof Chunk)) ** GOTO lbl-1000
        levelChunk = (Chunk)chunk;
        if (levelChunk.mustNotSave) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = shouldLevelChunkNotSave = false;
        }
        if (chunk != null) {
            if (chunk instanceof Chunk) {
                levelChunk = (Chunk)chunk;
                levelChunk.c(false);
            }
            if (!shouldLevelChunkNotSave) {
                this.saveChunk(chunk, true);
            } else {
                this.completeAsyncChunkDataSave(null);
            }
            if (chunk instanceof Chunk) {
                levelChunk = (Chunk)chunk;
                this.world.a(levelChunk);
            }
        }
        if (entityChunk != null) {
            this.saveEntities(entityChunk, true);
            lastEntityUnload = this.lastEntityUnload;
            this.lastEntityUnload = null;
            if (entityChunk.unload()) {
                schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
                try {
                    entityChunk.setTransient(true);
                    this.entityChunk = entityChunk;
                }
                finally {
                    this.scheduler.schedulingLockArea.unlock(schedulingLock);
                }
            } else {
                this.world.getEntityLookup().entitySectionUnload(this.chunkX, this.chunkZ);
            }
            this.entityDataUnload.completable().complete(lastEntityUnload);
        }
        if (poiChunk != null) {
            if (poiChunk.isDirty() && !shouldLevelChunkNotSave) {
                this.savePOI(poiChunk, true);
            } else {
                this.poiDataUnload.completable().complete(null);
            }
            if (poiChunk.isLoaded()) {
                this.world.w().onUnload(CoordinateUtils.getChunkKey(this.chunkX, this.chunkZ));
            }
        }
    }

    boolean unloadStage3() {
        this.poiDataUnload = null;
        this.entityDataUnload = null;
        if (this.entityChunk != null || this.poiChunk != null || this.currentChunk != null) {
            return false;
        }
        return this.isSafeToUnload() == null;
    }

    private void cancelGenTask() {
        if (this.generationTask != null) {
            this.generationTask.cancel();
        } else if (!this.neighboursBlockingGenTask.isEmpty()) {
            for (NewChunkHolder neighbour : this.neighboursBlockingGenTask) {
                if (neighbour.neighboursWaitingForUs.remove((Object)this) == null) {
                    throw new IllegalStateException("Corrupt state");
                }
                if (!neighbour.neighboursWaitingForUs.isEmpty()) continue;
                neighbour.checkUnload();
            }
            this.neighboursBlockingGenTask.clear();
            this.checkUnload();
        }
    }

    public void processTicketLevelUpdate(List<ChunkProgressionTask> scheduledTasks, List<NewChunkHolder> changedLoadStatus) {
        int oldLevel = this.oldTicketLevel;
        int newLevel = this.currentTicketLevel;
        if (oldLevel == newLevel) {
            return;
        }
        this.oldTicketLevel = newLevel;
        FullChunkStatus oldState = ChunkLevel.b(oldLevel);
        FullChunkStatus newState = ChunkLevel.b(newLevel);
        boolean oldUnloaded = oldLevel > ChunkHolderManager.MAX_TICKET_LEVEL;
        boolean newUnloaded = newLevel > ChunkHolderManager.MAX_TICKET_LEVEL;
        ChunkStatus maxGenerationStatusOld = ChunkLevel.a(oldLevel);
        ChunkStatus maxGenerationStatusNew = ChunkLevel.a(newLevel);
        if (this.requestedGenStatus != null && !newState.a(FullChunkStatus.b) && newLevel > oldLevel) {
            if (newUnloaded) {
                this.requestedGenStatus = null;
                this.cancelGenTask();
            } else {
                ChunkStatus currentRequestedStatus = this.requestedGenStatus;
                ChunkStatus toCancel = maxGenerationStatusNew.getNextStatus();
                if (currentRequestedStatus.b(toCancel)) {
                    if (this.currentGenStatus != null && this.currentGenStatus.b(maxGenerationStatusNew)) {
                        this.requestedGenStatus = null;
                        this.cancelGenTask();
                    } else {
                        this.requestedGenStatus = maxGenerationStatusNew;
                        if (this.generationTaskStatus != null && this.generationTaskStatus.b(toCancel)) {
                            throw new IllegalStateException("?????");
                        }
                    }
                }
            }
        }
        if (newState != oldState) {
            if (newState.a(oldState)) {
                if (!oldState.a(FullChunkStatus.b) && newState.a(FullChunkStatus.b)) {
                    if (this.currentGenStatus != ChunkStatus.n) {
                        if (this.requestedGenStatus != null) {
                            this.requestedGenStatus = ChunkStatus.n;
                        } else {
                            this.scheduler.schedule(this.chunkX, this.chunkZ, ChunkStatus.n, this, scheduledTasks);
                        }
                    } else {
                        this.queueBorderFullStatus(true, changedLoadStatus);
                    }
                }
            } else {
                if (!newState.a(FullChunkStatus.d) && oldState.a(FullChunkStatus.d)) {
                    this.completeFullStatusConsumers(FullChunkStatus.d, null);
                }
                if (!newState.a(FullChunkStatus.c) && oldState.a(FullChunkStatus.c)) {
                    this.completeFullStatusConsumers(FullChunkStatus.c, null);
                }
                if (!newState.a(FullChunkStatus.b) && oldState.a(FullChunkStatus.b)) {
                    this.completeFullStatusConsumers(FullChunkStatus.b, null);
                }
            }
        }
        if (oldState != newState && this.onTicketUpdate(oldState, newState)) {
            changedLoadStatus.add(this);
        }
        if (oldUnloaded != newUnloaded) {
            this.checkUnload();
        }
    }

    private static int getFullNeighbourIndex(int relativeX, int relativeZ) {
        return relativeX + relativeZ * 5 + 12;
    }

    public final boolean isNeighbourFullLoaded(int relativeX, int relativeZ) {
        return (this.fullNeighbourChunksLoadedBitset & 1L << NewChunkHolder.getFullNeighbourIndex(relativeX, relativeZ)) != 0L;
    }

    public final boolean setNeighbourFullLoaded(int relativeX, int relativeZ) {
        long before = this.fullNeighbourChunksLoadedBitset;
        int index = NewChunkHolder.getFullNeighbourIndex(relativeX, relativeZ);
        this.fullNeighbourChunksLoadedBitset |= 1L << index;
        return this.onNeighbourChange(before, this.fullNeighbourChunksLoadedBitset);
    }

    public final boolean setNeighbourFullUnloaded(int relativeX, int relativeZ) {
        long before = this.fullNeighbourChunksLoadedBitset;
        int index = NewChunkHolder.getFullNeighbourIndex(relativeX, relativeZ);
        this.fullNeighbourChunksLoadedBitset &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
        return this.onNeighbourChange(before, this.fullNeighbourChunksLoadedBitset);
    }

    public static boolean areNeighboursFullLoaded(long bitset, int radius) {
        switch (radius) {
            case 0: {
                return (bitset & 1L << NewChunkHolder.getFullNeighbourIndex(0, 0)) != 0L;
            }
            case 1: {
                long mask = 0L;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        mask |= 1L << NewChunkHolder.getFullNeighbourIndex(dx, dz);
                    }
                }
                return (bitset & mask) == mask;
            }
            case 2: {
                long mask = 0L;
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        mask |= 1L << NewChunkHolder.getFullNeighbourIndex(dx, dz);
                    }
                }
                return (bitset & mask) == mask;
            }
        }
        throw new IllegalArgumentException("Radius not recognized: " + radius);
    }

    public static FullChunkStatus getCurrentChunkStatus(long encoded) {
        return CHUNK_STATUS_BY_ID[(int)encoded];
    }

    public static FullChunkStatus getPendingChunkStatus(long encoded) {
        return CHUNK_STATUS_BY_ID[(int)(encoded >>> 32)];
    }

    public FullChunkStatus getChunkStatus() {
        return NewChunkHolder.getCurrentChunkStatus(CHUNK_STATUS_HANDLE.getVolatile(this));
    }

    public boolean isEntityTickingReady() {
        return this.getChunkStatus().a(FullChunkStatus.d);
    }

    public boolean isTickingReady() {
        return this.getChunkStatus().a(FullChunkStatus.c);
    }

    public boolean isFullChunkReady() {
        return this.getChunkStatus().a(FullChunkStatus.b);
    }

    private static FullChunkStatus getStatusForBitset(long bitset) {
        if (NewChunkHolder.areNeighboursFullLoaded(bitset, 2)) {
            return FullChunkStatus.d;
        }
        if (NewChunkHolder.areNeighboursFullLoaded(bitset, 1)) {
            return FullChunkStatus.c;
        }
        if (NewChunkHolder.areNeighboursFullLoaded(bitset, 0)) {
            return FullChunkStatus.b;
        }
        return FullChunkStatus.a;
    }

    protected final boolean onTicketUpdate(FullChunkStatus oldState, FullChunkStatus newState) {
        if (oldState == newState) {
            return false;
        }
        FullChunkStatus byNeighbours = NewChunkHolder.getStatusForBitset(this.fullNeighbourChunksLoadedBitset);
        if (byNeighbours == FullChunkStatus.a && newState.a(FullChunkStatus.b) && this.currentGenStatus == ChunkStatus.n) {
            byNeighbours = FullChunkStatus.b;
        }
        FullChunkStatus toSet = newState.a(byNeighbours) ? byNeighbours : newState;
        long curr = CHUNK_STATUS_HANDLE.getVolatile(this);
        if (curr == ((long)toSet.ordinal() | (long)toSet.ordinal() << 32)) {
            return false;
        }
        int failures = 0;
        long update;
        block0: while (curr != (curr = CHUNK_STATUS_HANDLE.compareAndExchange(this, curr, update = curr & 0xFFFFFFFFL | (long)toSet.ordinal() << 32))) {
            ++failures;
            int i2 = 0;
            while (true) {
                if (i2 >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i2;
            }
            break;
        }
        return true;
    }

    protected final boolean onNeighbourChange(long bitsetBefore, long bitsetAfter) {
        FullChunkStatus oldState = NewChunkHolder.getStatusForBitset(bitsetBefore);
        FullChunkStatus newState = NewChunkHolder.getStatusForBitset(bitsetAfter);
        FullChunkStatus currStateTicketLevel = ChunkLevel.b(this.oldTicketLevel);
        if (oldState.a(currStateTicketLevel)) {
            oldState = currStateTicketLevel;
        }
        if (newState.a(currStateTicketLevel)) {
            newState = currStateTicketLevel;
        }
        if (newState == FullChunkStatus.a && currStateTicketLevel.a(FullChunkStatus.b) && this.currentGenStatus == ChunkStatus.n) {
            newState = FullChunkStatus.b;
        }
        if (oldState == newState) {
            return false;
        }
        int failures = 0;
        long curr = CHUNK_STATUS_HANDLE.getVolatile(this);
        long update;
        block0: while (curr != (curr = CHUNK_STATUS_HANDLE.compareAndExchange(this, curr, update = curr & 0xFFFFFFFFL | (long)newState.ordinal() << 32))) {
            ++failures;
            int i2 = 0;
            while (true) {
                if (i2 >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i2;
            }
            break;
        }
        return true;
    }

    private boolean queueBorderFullStatus(boolean loaded, List<NewChunkHolder> changedFullStatus) {
        FullChunkStatus toStatus = loaded ? FullChunkStatus.b : FullChunkStatus.a;
        int failures = 0;
        long curr = CHUNK_STATUS_HANDLE.getVolatile(this);
        block0: while (true) {
            FullChunkStatus currPending = NewChunkHolder.getPendingChunkStatus(curr);
            if (loaded && currPending != FullChunkStatus.a) {
                throw new IllegalStateException("Expected " + FullChunkStatus.a + " for pending, but got " + currPending);
            }
            long update = curr & 0xFFFFFFFFL | (long)toStatus.ordinal() << 32;
            if (curr == (curr = CHUNK_STATUS_HANDLE.compareAndExchange(this, curr, update))) {
                if ((int)update != (int)(update >>> 32)) {
                    changedFullStatus.add(this);
                    return true;
                }
                return false;
            }
            ++failures;
            int i2 = 0;
            while (true) {
                if (i2 >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i2;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFullChunkLoadChange(boolean loaded, List<NewChunkHolder> changedFullStatus) {
        ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ, 2);
        try {
            for (int dz = -2; dz <= 2; ++dz) {
                for (int dx = -2; dx <= 2; ++dx) {
                    NewChunkHolder holder;
                    NewChunkHolder newChunkHolder = holder = (dx | dz) == 0 ? this : this.scheduler.chunkHolderManager.getChunkHolder(dx + this.chunkX, dz + this.chunkZ);
                    if (loaded) {
                        if (!holder.setNeighbourFullLoaded(-dx, -dz)) continue;
                        changedFullStatus.add(holder);
                        continue;
                    }
                    if (holder == null || !holder.setNeighbourFullUnloaded(-dx, -dz)) continue;
                    changedFullStatus.add(holder);
                }
            }
        }
        finally {
            this.scheduler.schedulingLockArea.unlock(schedulingLock);
        }
    }

    private FullChunkStatus updateCurrentState(FullChunkStatus to) {
        int failures = 0;
        long curr = CHUNK_STATUS_HANDLE.getVolatile(this);
        long update;
        block0: while (curr != (curr = CHUNK_STATUS_HANDLE.compareAndExchange(this, curr, update = curr & 0xFFFFFFFF00000000L | (long)to.ordinal()))) {
            ++failures;
            int i2 = 0;
            while (true) {
                if (i2 >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i2;
            }
            break;
        }
        return NewChunkHolder.getPendingChunkStatus(curr);
    }

    private void changeEntityChunkStatus(FullChunkStatus toStatus) {
        this.world.getEntityLookup().chunkStatusChange(this.chunkX, this.chunkZ, toStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFullStatusChange(List<NewChunkHolder> changedFullStatus) {
        int ticketKeep;
        TickThread.ensureTickThread(this.world, this.chunkX, this.chunkZ, "Cannot update full status thread off-main");
        boolean ret = false;
        if (this.processingFullStatus) {
            return ret;
        }
        long statusCheck = CHUNK_STATUS_HANDLE.getOpaque(this);
        if ((int)statusCheck == (int)(statusCheck >>> 32)) {
            return ret;
        }
        ChunkTaskScheduler scheduler = this.scheduler;
        ChunkHolderManager holderManager = scheduler.chunkHolderManager;
        Long ticketId = holderManager.getNextStatusUpgradeId();
        ReentrantAreaLock.Node ticketLock = holderManager.ticketLockArea.lock(this.chunkX, this.chunkZ);
        try {
            ticketKeep = this.currentTicketLevel;
            statusCheck = CHUNK_STATUS_HANDLE.getOpaque(this);
            if ((int)statusCheck == (int)(statusCheck >>> 32)) {
                boolean bl = ret;
                return bl;
            }
            holderManager.addTicketAtLevel(TicketType.STATUS_UPGRADE, CoordinateUtils.getChunkKey(this.chunkX, this.chunkZ), ticketKeep, ticketId, false);
        }
        finally {
            holderManager.ticketLockArea.unlock(ticketLock);
        }
        this.processingFullStatus = true;
        try {
            while (true) {
                FullChunkStatus nextState;
                long currStateEncoded;
                FullChunkStatus currState;
                if ((currState = NewChunkHolder.getCurrentChunkStatus(currStateEncoded = CHUNK_STATUS_HANDLE.getOpaque(this))) == (nextState = NewChunkHolder.getPendingChunkStatus(currStateEncoded))) {
                    if (nextState != FullChunkStatus.a) break;
                    ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ);
                    try {
                        this.checkUnload();
                        break;
                    }
                    finally {
                        this.scheduler.schedulingLockArea.unlock(schedulingLock);
                    }
                }
                Chunk chunk = (Chunk)this.currentChunk;
                if (nextState.a(currState)) {
                    if (!currState.a(FullChunkStatus.b) && nextState.a(FullChunkStatus.b)) {
                        nextState = this.updateCurrentState(FullChunkStatus.b);
                        holderManager.ensureInAutosave(this);
                        chunk.pushChunkIntoLoadedMap();
                        this.changeEntityChunkStatus(FullChunkStatus.b);
                        chunk.onChunkLoad(this);
                        this.onFullChunkLoadChange(true, changedFullStatus);
                        this.completeFullStatusConsumers(FullChunkStatus.b, chunk);
                    }
                    if (!currState.a(FullChunkStatus.c) && nextState.a(FullChunkStatus.c)) {
                        nextState = this.updateCurrentState(FullChunkStatus.c);
                        this.changeEntityChunkStatus(FullChunkStatus.c);
                        chunk.onChunkTicking(this);
                        this.completeFullStatusConsumers(FullChunkStatus.c, chunk);
                    }
                    if (!currState.a(FullChunkStatus.d) && nextState.a(FullChunkStatus.d)) {
                        nextState = this.updateCurrentState(FullChunkStatus.d);
                        this.changeEntityChunkStatus(FullChunkStatus.d);
                        chunk.onChunkEntityTicking(this);
                        this.completeFullStatusConsumers(FullChunkStatus.d, chunk);
                    }
                } else {
                    if (currState.a(FullChunkStatus.d) && !nextState.a(FullChunkStatus.d)) {
                        this.changeEntityChunkStatus(FullChunkStatus.c);
                        chunk.onChunkNotEntityTicking(this);
                        nextState = this.updateCurrentState(FullChunkStatus.c);
                    }
                    if (currState.a(FullChunkStatus.c) && !nextState.a(FullChunkStatus.c)) {
                        this.changeEntityChunkStatus(FullChunkStatus.b);
                        chunk.onChunkNotTicking(this);
                        nextState = this.updateCurrentState(FullChunkStatus.b);
                    }
                    if (currState.a(FullChunkStatus.b) && !nextState.a(FullChunkStatus.b)) {
                        this.onFullChunkLoadChange(false, changedFullStatus);
                        this.changeEntityChunkStatus(FullChunkStatus.a);
                        chunk.onChunkUnload(this);
                        nextState = this.updateCurrentState(FullChunkStatus.a);
                    }
                }
                ret = true;
            }
        }
        finally {
            this.processingFullStatus = false;
            holderManager.removeTicketAtLevel(TicketType.STATUS_UPGRADE, this.chunkX, this.chunkZ, ticketKeep, ticketId);
        }
        return ret;
    }

    boolean upgradeGenTarget(ChunkStatus toStatus) {
        if (toStatus == null) {
            throw new NullPointerException("toStatus cannot be null");
        }
        if (this.requestedGenStatus == null && this.generationTask == null) {
            return false;
        }
        if (this.requestedGenStatus == null || !this.requestedGenStatus.b(toStatus)) {
            this.requestedGenStatus = toStatus;
        }
        return true;
    }

    public void setGenerationTarget(ChunkStatus toStatus) {
        this.requestedGenStatus = toStatus;
    }

    public boolean hasGenerationTask() {
        return this.generationTask != null;
    }

    public ChunkStatus getCurrentGenStatus() {
        return this.currentGenStatus;
    }

    public ChunkStatus getRequestedGenStatus() {
        return this.requestedGenStatus;
    }

    void addStatusConsumer(ChunkStatus status, Consumer<IChunkAccess> consumer) {
        ((List)this.statusWaiters.computeIfAbsent((Object)status, keyInMap -> new ArrayList(4))).add(consumer);
    }

    private void completeStatusConsumers(ChunkStatus status, IChunkAccess chunk) {
        do {
            this.completeStatusConsumers0(status, chunk);
        } while (chunk == null && status != (status = status.getNextStatus()));
    }

    private void completeStatusConsumers0(ChunkStatus status, IChunkAccess chunk) {
        List consumers = (List)this.statusWaiters.remove((Object)status);
        if (consumers == null) {
            return;
        }
        this.scheduler.scheduleChunkTask(this.chunkX, this.chunkZ, () -> {
            for (Consumer consumer : consumers) {
                try {
                    consumer.accept(chunk);
                }
                catch (ThreadDeath thr) {
                    throw thr;
                }
                catch (Throwable thr) {
                    LOGGER.error("Failed to process chunk status callback", thr);
                }
            }
        }, PrioritisedExecutor.Priority.HIGHEST);
    }

    void addFullStatusConsumer(FullChunkStatus status, Consumer<Chunk> consumer) {
        ((List)this.fullStatusWaiters.computeIfAbsent((Object)status, keyInMap -> new ArrayList(4))).add(consumer);
    }

    private void completeFullStatusConsumers(FullChunkStatus status, Chunk chunk) {
        FullChunkStatus max = CHUNK_STATUS_BY_ID[CHUNK_STATUS_BY_ID.length - 1];
        while (true) {
            this.completeFullStatusConsumers0(status, chunk);
            if (chunk != null || status == max) break;
            status = CHUNK_STATUS_BY_ID[status.ordinal() + 1];
        }
    }

    private void completeFullStatusConsumers0(FullChunkStatus status, Chunk chunk) {
        List consumers = (List)this.fullStatusWaiters.remove((Object)status);
        if (consumers == null) {
            return;
        }
        this.scheduler.scheduleChunkTask(this.chunkX, this.chunkZ, () -> {
            for (Consumer consumer : consumers) {
                try {
                    consumer.accept(chunk);
                }
                catch (ThreadDeath thr) {
                    throw thr;
                }
                catch (Throwable thr) {
                    LOGGER.error("Failed to process chunk status callback", thr);
                }
            }
        }, PrioritisedExecutor.Priority.HIGHEST);
    }

    private void onChunkGenComplete(IChunkAccess newChunk, ChunkStatus newStatus, List<ChunkProgressionTask> scheduleList, List<NewChunkHolder> changedLoadStatus) {
        if (!this.neighboursBlockingGenTask.isEmpty()) {
            throw new IllegalStateException("Cannot have neighbours blocking this gen task");
        }
        if (newChunk != null || this.requestedGenStatus == null || !this.requestedGenStatus.b(newStatus)) {
            this.completeStatusConsumers(newStatus, newChunk);
        }
        this.generationTask = null;
        this.generationTaskStatus = null;
        if (newChunk == null) {
            ChunkStatus requestedGenStatus = this.requestedGenStatus;
            this.requestedGenStatus = null;
            if (requestedGenStatus != null) {
                if (!this.neighboursWaitingForUs.isEmpty()) {
                    ObjectBidirectionalIterator iterator = this.neighboursWaitingForUs.reference2ObjectEntrySet().fastIterator();
                    while (iterator.hasNext()) {
                        Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
                        NewChunkHolder chunkHolder = (NewChunkHolder)entry.getKey();
                        ChunkStatus toStatus = (ChunkStatus)entry.getValue();
                        if (requestedGenStatus.b(toStatus)) continue;
                        if (!chunkHolder.neighboursBlockingGenTask.remove((Object)this)) {
                            throw new IllegalStateException("Corrupt state");
                        }
                        if (chunkHolder.neighboursBlockingGenTask.isEmpty()) {
                            chunkHolder.checkUnload();
                        }
                        iterator.remove();
                    }
                }
                this.scheduler.schedule(this.chunkX, this.chunkZ, requestedGenStatus, this, scheduleList);
                return;
            }
            if (!this.neighboursWaitingForUs.isEmpty()) {
                for (NewChunkHolder chunkHolder : this.neighboursWaitingForUs.keySet()) {
                    if (!chunkHolder.neighboursBlockingGenTask.remove((Object)this)) {
                        throw new IllegalStateException("Corrupt state");
                    }
                    if (!chunkHolder.neighboursBlockingGenTask.isEmpty()) continue;
                    chunkHolder.checkUnload();
                }
                this.neighboursWaitingForUs.clear();
            }
            this.setPriority(PrioritisedExecutor.Priority.NORMAL);
            this.checkUnload();
            return;
        }
        this.currentChunk = newChunk;
        this.currentGenStatus = newStatus;
        this.lastChunkCompletion = new ChunkCompletion(newChunk, newStatus);
        ChunkStatus requestedGenStatus = this.requestedGenStatus;
        ArrayList<NewChunkHolder> needsScheduling = null;
        boolean recalculatePriority = false;
        ObjectBidirectionalIterator iterator = this.neighboursWaitingForUs.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            NewChunkHolder neighbour = (NewChunkHolder)entry.getKey();
            ChunkStatus requiredStatus = (ChunkStatus)entry.getValue();
            if (!newStatus.b(requiredStatus)) {
                if (requestedGenStatus != null && requestedGenStatus.b(requiredStatus)) continue;
                if (!neighbour.neighboursBlockingGenTask.remove((Object)this)) {
                    throw new IllegalStateException("Neighbour is not waiting for us?");
                }
                if (neighbour.neighboursBlockingGenTask.isEmpty()) {
                    neighbour.checkUnload();
                }
                iterator.remove();
                continue;
            }
            recalculatePriority = true;
            if (!neighbour.neighboursBlockingGenTask.remove((Object)this)) {
                throw new IllegalStateException("Neighbour is not waiting for us?");
            }
            if (neighbour.neighboursBlockingGenTask.isEmpty()) {
                if (neighbour.requestedGenStatus != null) {
                    if (needsScheduling == null) {
                        needsScheduling = new ArrayList<NewChunkHolder>();
                    }
                    needsScheduling.add(neighbour);
                } else {
                    neighbour.checkUnload();
                }
            }
            iterator.remove();
        }
        if (newStatus == ChunkStatus.n) {
            this.lockPriority();
            if (ChunkLevel.b(this.oldTicketLevel).a(FullChunkStatus.b)) {
                this.queueBorderFullStatus(true, changedLoadStatus);
            }
        }
        if (recalculatePriority) {
            this.recalculateNeighbourRequestedPriority();
        }
        if (requestedGenStatus != null && !newStatus.b(requestedGenStatus)) {
            this.scheduleNeighbours(needsScheduling, scheduleList);
            this.scheduler.schedule(this.chunkX, this.chunkZ, requestedGenStatus, this, scheduleList);
        } else {
            if (requestedGenStatus != null) {
                this.requestedGenStatus = null;
            }
            this.setPriority(PrioritisedExecutor.Priority.NORMAL);
            this.checkUnload();
            this.scheduleNeighbours(needsScheduling, scheduleList);
        }
    }

    private void scheduleNeighbours(List<NewChunkHolder> needsScheduling, List<ChunkProgressionTask> scheduleList) {
        if (needsScheduling != null) {
            int len = needsScheduling.size();
            for (int i2 = 0; i2 < len; ++i2) {
                NewChunkHolder neighbour = needsScheduling.get(i2);
                this.scheduler.schedule(neighbour.chunkX, neighbour.chunkZ, neighbour.requestedGenStatus, neighbour, scheduleList);
            }
        }
    }

    public void setGenerationTask(ChunkProgressionTask generationTask, ChunkStatus taskStatus, List<NewChunkHolder> neighbours) {
        if (this.generationTask != null || this.currentGenStatus != null && this.currentGenStatus.b(taskStatus)) {
            throw new IllegalStateException("Currently generating or provided task is trying to generate to a level we are already at!");
        }
        if (this.requestedGenStatus == null || !this.requestedGenStatus.b(taskStatus)) {
            throw new IllegalStateException("Cannot schedule generation task when not requested");
        }
        this.generationTask = generationTask;
        this.generationTaskStatus = taskStatus;
        int len = neighbours.size();
        for (int i2 = 0; i2 < len; ++i2) {
            neighbours.get(i2).addNeighbourUsingChunk();
        }
        this.checkUnload();
        generationTask.onComplete((access, thr) -> {
            int i2;
            int len;
            boolean scheduleTasks;
            if (generationTask != this.generationTask) {
                throw new IllegalStateException("Cannot complete generation task '" + generationTask + "' because we are waiting on '" + this.generationTask + "' instead!");
            }
            if (thr != null) {
                if (this.genTaskException != null) {
                    return;
                }
                this.genTaskException = thr;
                this.failedGenStatus = taskStatus;
                this.genTaskFailedThread = Thread.currentThread();
                this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Generation task", ChunkTaskScheduler.stringIfNull(generationTask), "Task to status", ChunkTaskScheduler.stringIfNull(taskStatus)), (Throwable)thr);
                return;
            }
            List<ChunkProgressionTask> tasks = ChunkHolderManager.getCurrentTicketUpdateScheduling();
            if (tasks == null) {
                scheduleTasks = true;
                tasks = new ArrayList<ChunkProgressionTask>();
            } else {
                scheduleTasks = false;
            }
            ArrayList<NewChunkHolder> changedLoadStatus = new ArrayList<NewChunkHolder>();
            ReentrantAreaLock.Node schedulingLock = this.scheduler.schedulingLockArea.lock(this.chunkX, this.chunkZ, 2 * ChunkTaskScheduler.getMaxAccessRadius());
            try {
                len = neighbours.size();
                for (i2 = 0; i2 < len; ++i2) {
                    ((NewChunkHolder)neighbours.get(i2)).removeNeighbourUsingChunk();
                }
                this.onChunkGenComplete((IChunkAccess)access, taskStatus, tasks, (List<NewChunkHolder>)changedLoadStatus);
            }
            finally {
                this.scheduler.schedulingLockArea.unlock(schedulingLock);
            }
            this.scheduler.chunkHolderManager.addChangedStatuses(changedLoadStatus);
            if (scheduleTasks) {
                len = tasks.size();
                for (i2 = 0; i2 < len; ++i2) {
                    tasks.get(i2).schedule();
                }
            }
        });
    }

    public PoiChunk getPoiChunk() {
        return this.poiChunk;
    }

    public ChunkEntitySlices getEntityChunk() {
        return this.entityChunk;
    }

    /*
     * Unable to fully structure code
     */
    public SaveStat save(boolean shutdown, boolean unloading) {
        block12: {
            block11: {
                TickThread.ensureTickThread(this.world, this.chunkX, this.chunkZ, "Cannot save data off-main");
                chunk = this.getCurrentChunk();
                poi = this.getPoiChunk();
                entities = this.getEntityChunk();
                executedUnloadTask = false;
                if (shutdown) {
                    if (this.unloadState != null) {
                        chunk = this.unloadState.chunk();
                        poi = this.unloadState.poiChunk();
                        entities = this.unloadState.entityChunk();
                    }
                    v0 = chunkDataUnloadTask = (chunkUnloadTask = this.chunkDataUnload) == null ? null : chunkUnloadTask.task();
                    if (chunkDataUnloadTask != null && (unloadTask = chunkDataUnloadTask.getTask()) != null) {
                        executedUnloadTask = unloadTask.execute();
                    }
                }
                if (!(chunk instanceof Chunk)) break block11;
                levelChunk = (Chunk)chunk;
                if (levelChunk.mustNotSave) ** GOTO lbl-1000
            }
            if (chunk != null && (shutdown || chunk instanceof Chunk) && chunk.i()) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = canSaveChunk = false;
            }
            if (!(chunk instanceof Chunk)) break block12;
            levelChunk = (Chunk)chunk;
            if (levelChunk.mustNotSave) ** GOTO lbl-1000
        }
        if (poi != null && poi.isDirty()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        canSavePOI = v2;
        v3 = canSaveEntities = entities != null;
        if (canSaveChunk) {
            canSaveChunk = this.saveChunk(chunk, unloading);
        }
        if (canSavePOI) {
            canSavePOI = this.savePOI(poi, unloading);
        }
        if (canSaveEntities) {
            canSaveEntities = this.saveEntities(entities, unloading != false || shutdown != false);
            if (unloading || shutdown) {
                this.lastEntityUnload = null;
            }
        }
        return (executedUnloadTask | canSaveChunk | canSaveEntities | canSavePOI) != false ? new SaveStat(executedUnloadTask != false || canSaveChunk != false, canSaveEntities, canSavePOI) : null;
    }

    private boolean saveChunk(IChunkAccess chunk, boolean unloading) {
        block11: {
            if (!chunk.i()) {
                if (unloading) {
                    this.completeAsyncChunkDataSave(null);
                }
                return false;
            }
            boolean completing = false;
            try {
                if (unloading) {
                    try {
                        ChunkRegionLoader.AsyncSaveData asyncSaveData = ChunkRegionLoader.getAsyncSaveData(this.world, chunk);
                        PrioritisedExecutor.PrioritisedTask task = this.scheduler.loadExecutor.createTask(new AsyncChunkSerializeTask(this.world, chunk, asyncSaveData, this));
                        this.chunkDataUnload.task().setTask(task);
                        task.queue();
                        chunk.a(false);
                        return true;
                    }
                    catch (ThreadDeath death) {
                        throw death;
                    }
                    catch (Throwable thr) {
                        LOGGER.error("Failed to prepare async chunk data (" + this.chunkX + "," + this.chunkZ + ") in world '" + this.world.getWorld().getName() + "', falling back to synchronous save", thr);
                    }
                }
                NBTTagCompound save = ChunkRegionLoader.saveChunk(this.world, chunk, null);
                if (unloading) {
                    completing = true;
                    this.completeAsyncChunkDataSave(save);
                    LOGGER.info("Successfully serialized chunk data (" + this.chunkX + "," + this.chunkZ + ") in world '" + this.world.getWorld().getName() + "' synchronously");
                } else {
                    RegionFileIOThread.scheduleSave(this.world, this.chunkX, this.chunkZ, save, RegionFileIOThread.RegionFileType.CHUNK_DATA);
                }
                chunk.a(false);
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable thr) {
                LOGGER.error("Failed to save chunk data (" + this.chunkX + "," + this.chunkZ + ") in world '" + this.world.getWorld().getName() + "'");
                if (!unloading || completing) break block11;
                this.completeAsyncChunkDataSave(null);
            }
        }
        return true;
    }

    private boolean saveEntities(ChunkEntitySlices entities, boolean unloading) {
        try {
            NBTTagCompound mergeFrom = null;
            if (entities.isTransient()) {
                if (!unloading) {
                    return false;
                }
                try {
                    mergeFrom = RegionFileIOThread.loadData(this.world, this.chunkX, this.chunkZ, RegionFileIOThread.RegionFileType.ENTITY_DATA, PrioritisedExecutor.Priority.BLOCKING);
                }
                catch (Exception ex) {
                    LOGGER.error("Cannot merge transient entities for chunk (" + this.chunkX + "," + this.chunkZ + ") in world '" + this.world.getWorld().getName() + "', data on disk will be replaced", (Throwable)ex);
                }
            }
            NBTTagCompound save = entities.save();
            if (mergeFrom != null) {
                if (save == null) {
                    return false;
                }
                EntityStorage.copyEntities(mergeFrom, save);
            }
            if (save == null && this.lastEntitySaveNull) {
                return false;
            }
            RegionFileIOThread.scheduleSave(this.world, this.chunkX, this.chunkZ, save, RegionFileIOThread.RegionFileType.ENTITY_DATA);
            boolean bl = this.lastEntitySaveNull = save == null;
            if (unloading) {
                this.lastEntityUnload = save;
            }
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable thr) {
            LOGGER.error("Failed to save entity data (" + this.chunkX + "," + this.chunkZ + ") in world '" + this.world.getWorld().getName() + "'");
        }
        return true;
    }

    private boolean savePOI(PoiChunk poi, boolean unloading) {
        try {
            NBTTagCompound save = poi.save();
            poi.setDirty(false);
            if (save == null && this.lastPoiSaveNull) {
                if (unloading) {
                    this.poiDataUnload.completable().complete(null);
                }
                return false;
            }
            RegionFileIOThread.scheduleSave(this.world, this.chunkX, this.chunkZ, save, RegionFileIOThread.RegionFileType.POI_DATA);
            boolean bl = this.lastPoiSaveNull = save == null;
            if (unloading) {
                this.poiDataUnload.completable().complete(save);
            }
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable thr) {
            LOGGER.error("Failed to save poi data (" + this.chunkX + "," + this.chunkZ + ") in world '" + this.world.getWorld().getName() + "'");
        }
        return true;
    }

    public String toString() {
        ChunkCompletion lastCompletion = this.lastChunkCompletion;
        ChunkEntitySlices entityChunk = this.entityChunk;
        long chunkStatus = this.chunkStatus;
        int fullChunkStatus = (int)chunkStatus;
        int pendingChunkStatus = (int)(chunkStatus >>> 32);
        FullChunkStatus currentFullStatus = fullChunkStatus < 0 || fullChunkStatus >= CHUNK_STATUS_BY_ID.length ? null : CHUNK_STATUS_BY_ID[fullChunkStatus];
        FullChunkStatus pendingFullStatus = pendingChunkStatus < 0 || pendingChunkStatus >= CHUNK_STATUS_BY_ID.length ? null : CHUNK_STATUS_BY_ID[pendingChunkStatus];
        return "NewChunkHolder{world=" + this.world.getWorld().getName() + ", chunkX=" + this.chunkX + ", chunkZ=" + this.chunkZ + ", entityChunkFromDisk=" + (entityChunk != null && !entityChunk.isTransient()) + ", lastChunkCompletion={chunk_class=" + (lastCompletion == null || lastCompletion.chunk() == null ? "null" : lastCompletion.chunk().getClass().getName()) + ",status=" + (lastCompletion == null ? "null" : lastCompletion.genStatus()) + "}, currentGenStatus=" + this.currentGenStatus + ", requestedGenStatus=" + this.requestedGenStatus + ", generationTask=" + this.generationTask + ", generationTaskStatus=" + this.generationTaskStatus + ", priority=" + this.priority + ", priorityLocked=" + this.priorityLocked + ", neighbourRequestedPriority=" + this.neighbourRequestedPriority + ", effective_priority=" + this.getEffectivePriority() + ", oldTicketLevel=" + this.oldTicketLevel + ", currentTicketLevel=" + this.currentTicketLevel + ", totalNeighboursUsingThisChunk=" + this.totalNeighboursUsingThisChunk + ", fullNeighbourChunksLoadedBitset=" + this.fullNeighbourChunksLoadedBitset + ", chunkStatusRaw=" + chunkStatus + ", currentChunkStatus=" + currentFullStatus + ", pendingChunkStatus=" + pendingFullStatus + ", is_unload_safe=" + this.isSafeToUnload() + ", killed=" + this.killed + "}";
    }

    private static JsonElement serializeCompletable(Completable<?> completable) {
        if (completable == null) {
            return new JsonPrimitive("null");
        }
        JsonObject ret = new JsonObject();
        boolean isCompleted = completable.isCompleted();
        ret.addProperty("completed", Boolean.valueOf(isCompleted));
        if (isCompleted) {
            ret.addProperty("completed_exceptionally", Boolean.valueOf(completable.getThrowable() != null));
        }
        return ret;
    }

    public JsonObject getDebugJson() {
        DelayedPrioritisedTask unloadTask;
        JsonObject ret = new JsonObject();
        ChunkCompletion lastCompletion = this.lastChunkCompletion;
        ChunkEntitySlices slices = this.entityChunk;
        PoiChunk poiChunk = this.poiChunk;
        ret.addProperty("chunkX", (Number)this.chunkX);
        ret.addProperty("chunkZ", (Number)this.chunkZ);
        ret.addProperty("entity_chunk", (String)(slices == null ? "null" : "transient=" + slices.isTransient()));
        ret.addProperty("poi_chunk", "null=" + (poiChunk == null));
        ret.addProperty("completed_chunk_class", lastCompletion == null ? "null" : lastCompletion.chunk().getClass().getName());
        ret.addProperty("completed_gen_status", lastCompletion == null ? "null" : lastCompletion.genStatus().toString());
        ret.addProperty("priority", Objects.toString((Object)this.priority));
        ret.addProperty("neighbour_requested_priority", Objects.toString((Object)this.neighbourRequestedPriority));
        ret.addProperty("generation_task", Objects.toString(this.generationTask));
        ret.addProperty("is_safe_unload", Objects.toString(this.isSafeToUnload()));
        ret.addProperty("old_ticket_level", (Number)this.oldTicketLevel);
        ret.addProperty("current_ticket_level", (Number)this.currentTicketLevel);
        ret.addProperty("neighbours_using_chunk", (Number)this.totalNeighboursUsingThisChunk);
        JsonObject neighbourWaitState = new JsonObject();
        ret.add("neighbour_state", (JsonElement)neighbourWaitState);
        JsonArray blockingGenNeighbours = new JsonArray();
        neighbourWaitState.add("blocking_gen_task", (JsonElement)blockingGenNeighbours);
        for (NewChunkHolder blockingGenNeighbour : this.neighboursBlockingGenTask) {
            JsonObject neighbour = new JsonObject();
            blockingGenNeighbours.add((JsonElement)neighbour);
            neighbour.addProperty("chunkX", (Number)blockingGenNeighbour.chunkX);
            neighbour.addProperty("chunkZ", (Number)blockingGenNeighbour.chunkZ);
        }
        JsonArray neighboursWaitingForUs = new JsonArray();
        neighbourWaitState.add("neighbours_waiting_on_us", (JsonElement)neighboursWaitingForUs);
        for (Reference2ObjectMap.Entry entry : this.neighboursWaitingForUs.reference2ObjectEntrySet()) {
            NewChunkHolder holder = (NewChunkHolder)entry.getKey();
            ChunkStatus status = (ChunkStatus)entry.getValue();
            JsonObject neighbour = new JsonObject();
            neighboursWaitingForUs.add((JsonElement)neighbour);
            neighbour.addProperty("chunkX", (Number)holder.chunkX);
            neighbour.addProperty("chunkZ", (Number)holder.chunkZ);
            neighbour.addProperty("waiting_for", Objects.toString(status));
        }
        ret.addProperty("fullchunkstatus", Objects.toString((Object)this.getChunkStatus()));
        ret.addProperty("fullchunkstatus_raw", (Number)this.chunkStatus);
        ret.addProperty("generation_task", Objects.toString(this.generationTask));
        ret.addProperty("requested_generation", Objects.toString(this.requestedGenStatus));
        ret.addProperty("has_entity_load_task", Boolean.valueOf(this.entityDataLoadTask != null));
        ret.addProperty("has_poi_load_task", Boolean.valueOf(this.poiDataLoadTask != null));
        UnloadTask entityDataUnload = this.entityDataUnload;
        UnloadTask poiDataUnload = this.poiDataUnload;
        UnloadTask chunkDataUnload = this.chunkDataUnload;
        ret.add("entity_unload_completable", NewChunkHolder.serializeCompletable(entityDataUnload == null ? null : entityDataUnload.completable()));
        ret.add("poi_unload_completable", NewChunkHolder.serializeCompletable(poiDataUnload == null ? null : poiDataUnload.completable()));
        ret.add("chunk_unload_completable", NewChunkHolder.serializeCompletable(chunkDataUnload == null ? null : chunkDataUnload.completable()));
        DelayedPrioritisedTask delayedPrioritisedTask = unloadTask = chunkDataUnload == null ? null : chunkDataUnload.task();
        if (unloadTask == null) {
            ret.addProperty("unload_task_priority", "null");
            ret.addProperty("unload_task_priority_raw", "null");
        } else {
            ret.addProperty("unload_task_priority", Objects.toString((Object)unloadTask.getPriority()));
            ret.addProperty("unload_task_priority_raw", (Number)unloadTask.getPriorityInternal());
        }
        ret.addProperty("killed", Boolean.valueOf(this.killed));
        return ret;
    }

    public static abstract class GenericDataLoadTaskCallback
    implements Cancellable {
        protected final Consumer<GenericDataLoadTask.TaskResult<?, Throwable>> consumer;
        protected final NewChunkHolder chunkHolder;
        protected boolean completed;
        protected GenericDataLoadTask<?, ?> schedule;
        protected final AtomicBoolean scheduled = new AtomicBoolean();

        public GenericDataLoadTaskCallback(Consumer<GenericDataLoadTask.TaskResult<?, Throwable>> consumer, NewChunkHolder chunkHolder) {
            this.consumer = consumer;
            this.chunkHolder = chunkHolder;
        }

        public void schedule() {
            if (this.scheduled.getAndSet(true)) {
                throw new IllegalStateException("Double calling schedule()");
            }
            if (this.schedule != null) {
                this.schedule.scheduleNow();
                this.schedule = null;
            }
        }

        boolean isCompleted() {
            return this.completed;
        }

        private boolean setCompleted() {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            return true;
        }

        void markCompleted() {
            if (this.completed) {
                throw new IllegalStateException("May not be completed here");
            }
            this.completed = true;
        }

        void acceptCompleted(GenericDataLoadTask.TaskResult<?, Throwable> result) {
            if (result != null) {
                if (!this.completed) {
                    throw new IllegalStateException("Cannot be uncompleted at this point");
                }
            } else {
                throw new NullPointerException("Result cannot be null (cancelled)");
            }
            this.consumer.accept(result);
        }

        abstract void internalCancel();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            NewChunkHolder holder = this.chunkHolder;
            ReentrantAreaLock.Node schedulingLock = holder.scheduler.schedulingLockArea.lock(holder.chunkX, holder.chunkZ);
            try {
                if (!this.completed) {
                    this.completed = true;
                    this.internalCancel();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                holder.scheduler.schedulingLockArea.unlock(schedulingLock);
            }
        }
    }

    private static final class EntityDataLoadTaskCallback
    extends GenericDataLoadTaskCallback {
        public EntityDataLoadTaskCallback(Consumer<GenericDataLoadTask.TaskResult<?, Throwable>> consumer, NewChunkHolder chunkHolder) {
            super(consumer, chunkHolder);
        }

        @Override
        void internalCancel() {
            this.chunkHolder.entityDataLoadTaskWaiters.remove(this);
            this.chunkHolder.entityDataLoadTask.cancel();
        }
    }

    private static final class PoiDataLoadTaskCallback
    extends GenericDataLoadTaskCallback {
        public PoiDataLoadTaskCallback(Consumer<GenericDataLoadTask.TaskResult<?, Throwable>> consumer, NewChunkHolder chunkHolder) {
            super(consumer, chunkHolder);
        }

        @Override
        void internalCancel() {
            this.chunkHolder.poiDataLoadTaskWaiters.remove(this);
            this.chunkHolder.poiDataLoadTask.cancel();
        }
    }

    public record ChunkCompletion(IChunkAccess chunk, ChunkStatus genStatus) {
    }

    public record UnloadTask(Completable<NBTTagCompound> completable, DelayedPrioritisedTask task) {
    }

    record UnloadState(NewChunkHolder holder, IChunkAccess chunk, ChunkEntitySlices entityChunk, PoiChunk poiChunk) {
    }

    public record SaveStat(boolean savedChunk, boolean savedEntityChunk, boolean savedPoiChunk) {
    }

    static final class AsyncChunkSerializeTask
    implements Runnable {
        private final WorldServer world;
        private final IChunkAccess chunk;
        private final ChunkRegionLoader.AsyncSaveData asyncSaveData;
        private final NewChunkHolder toComplete;

        public AsyncChunkSerializeTask(WorldServer world, IChunkAccess chunk, ChunkRegionLoader.AsyncSaveData asyncSaveData, NewChunkHolder toComplete) {
            this.world = world;
            this.chunk = chunk;
            this.asyncSaveData = asyncSaveData;
            this.toComplete = toComplete;
        }

        @Override
        public void run() {
            NBTTagCompound toSerialize;
            try {
                toSerialize = ChunkRegionLoader.saveChunk(this.world, this.chunk, this.asyncSaveData);
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to asynchronously save chunk " + this.chunk.f() + " for world '" + this.world.getWorld().getName() + "', falling back to synchronous save", throwable);
                this.world.chunkTaskScheduler.scheduleChunkTask(this.chunk.locX, this.chunk.locZ, () -> {
                    NBTTagCompound synchronousSave;
                    try {
                        synchronousSave = ChunkRegionLoader.saveChunk(this.world, this.chunk, this.asyncSaveData);
                    }
                    catch (ThreadDeath death) {
                        throw death;
                    }
                    catch (Throwable throwable2) {
                        LOGGER.error("Failed to synchronously save chunk " + this.chunk.f() + " for world '" + this.world.getWorld().getName() + "', chunk data will be lost", throwable2);
                        this.toComplete.completeAsyncChunkDataSave(null);
                        return;
                    }
                    this.toComplete.completeAsyncChunkDataSave(synchronousSave);
                    LOGGER.info("Successfully serialized chunk " + this.chunk.f() + " for world '" + this.world.getWorld().getName() + "' synchronously");
                }, PrioritisedExecutor.Priority.HIGHEST);
                return;
            }
            this.toComplete.completeAsyncChunkDataSave(toSerialize);
        }

        public String toString() {
            return "AsyncChunkSerializeTask{chunk={pos=" + this.chunk.f() + ",world=\"" + this.world.getWorld().getName() + "\"}}";
        }
    }
}

