/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import com.google.common.collect.Maps;
import io.papermc.paper.command.CommandUtil;
import io.papermc.paper.command.PaperSubcommand;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.HeightMap;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EntityCommand
implements PaperSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        this.listEntities(sender, args);
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        if (args.length == 1) {
            return CommandUtil.getListMatchingLast(sender, args, "help", "list");
        }
        if (args.length == 2) {
            return CommandUtil.getListMatchingLast(sender, args, (String[])BuiltInRegistries.h.e().stream().map(MinecraftKey::toString).sorted().toArray(String[]::new));
        }
        return Collections.emptyList();
    }

    private void listEntities(CommandSender sender, String[] args) {
        if (args.length < 1 || !args[0].toLowerCase(Locale.ENGLISH).equals("list")) {
            sender.sendMessage((Component)Component.text((String)"Use /paper entity [list] help for more information on a specific command", (TextColor)NamedTextColor.RED));
            return;
        }
        if ("list".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            String worldName;
            String filter = "*";
            if (args.length > 1) {
                if (args[1].toLowerCase(Locale.ENGLISH).equals("help")) {
                    sender.sendMessage((Component)Component.text((String)"Use /paper entity list [filter] [worldName] to get entity info that matches the optional filter.", (TextColor)NamedTextColor.RED));
                    return;
                }
                filter = args[1];
            }
            String cleanfilter = filter.replace("?", ".?").replace("*", ".*?");
            Set names = BuiltInRegistries.h.e().stream().filter(n2 -> n2.toString().matches(cleanfilter)).collect(Collectors.toSet());
            if (names.isEmpty()) {
                sender.sendMessage((Component)Component.text((String)"Invalid filter, does not match any entities. Use /paper entity list for a proper list", (TextColor)NamedTextColor.RED));
                sender.sendMessage((Component)Component.text((String)"Usage: /paper entity list [filter] [worldName]", (TextColor)NamedTextColor.RED));
                return;
            }
            if (args.length > 2) {
                worldName = args[2];
            } else if (sender instanceof Player) {
                worldName = ((Player)sender).getWorld().getName();
            } else {
                sender.sendMessage((Component)Component.text((String)"Please specify the name of a world", (TextColor)NamedTextColor.RED));
                sender.sendMessage((Component)Component.text((String)"To do so without a filter, specify '*' as the filter", (TextColor)NamedTextColor.RED));
                sender.sendMessage((Component)Component.text((String)"Usage: /paper entity list [filter] [worldName]", (TextColor)NamedTextColor.RED));
                return;
            }
            HashMap list = Maps.newHashMap();
            @Nullable World bukkitWorld = Bukkit.getWorld((String)worldName);
            if (bukkitWorld == null) {
                sender.sendMessage((Component)Component.text((String)("Could not load world for " + worldName + ". Please select a valid world."), (TextColor)NamedTextColor.RED));
                sender.sendMessage((Component)Component.text((String)"Usage: /paper entity list [filter] [worldName]", (TextColor)NamedTextColor.RED));
                return;
            }
            WorldServer world = ((CraftWorld)bukkitWorld).getHandle();
            HashMap nonEntityTicking = Maps.newHashMap();
            ChunkProviderServer chunkProviderServer = world.k();
            world.y().forEach(e2 -> {
                MinecraftKey key = EntityTypes.a(e2.ag());
                MutablePair info = list.computeIfAbsent(key, k2 -> MutablePair.of((Object)0, (Object)Maps.newHashMap()));
                ChunkCoordIntPair chunk = e2.dn();
                MutablePair mutablePair = info;
                Integer n2 = (Integer)mutablePair.left;
                mutablePair.left = (Integer)mutablePair.left + 1;
                ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
                if (!chunkProviderServer.isPositionTicking((Entity)e2) || e2 instanceof Marker && !world.paperConfig().entities.markers.tick) {
                    nonEntityTicking.merge(key, 1, Integer::sum);
                }
            });
            if (names.size() == 1) {
                MinecraftKey name = (MinecraftKey)names.iterator().next();
                Pair info = (Pair)list.get(name);
                int nonTicking = nonEntityTicking.getOrDefault(name, 0);
                if (info == null) {
                    sender.sendMessage((Component)Component.text((String)"No entities found.", (TextColor)NamedTextColor.RED));
                    return;
                }
                sender.sendMessage("Entity: " + name + " Total Ticking: " + ((Integer)info.getLeft() - nonTicking) + ", Total Non-Ticking: " + nonTicking);
                ((Map)info.getRight()).entrySet().stream().sorted((a2, b2) -> !((Integer)a2.getValue()).equals(b2.getValue()) ? (Integer)b2.getValue() - (Integer)a2.getValue() : ((ChunkCoordIntPair)a2.getKey()).toString().compareTo(((ChunkCoordIntPair)b2.getKey()).toString())).limit(10L).forEach(e2 -> {
                    int x2 = (((ChunkCoordIntPair)e2.getKey()).e << 4) + 8;
                    int z2 = (((ChunkCoordIntPair)e2.getKey()).f << 4) + 8;
                    Component message = ((TextComponent)Component.text((String)("  " + e2.getValue() + ": " + ((ChunkCoordIntPair)e2.getKey()).e + ", " + ((ChunkCoordIntPair)e2.getKey()).f + (chunkProviderServer.a(((ChunkCoordIntPair)e2.getKey()).a()) ? " (Ticking)" : " (Non-Ticking)"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to teleport to chunk", (TextColor)NamedTextColor.GREEN)))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/minecraft:execute as @s in " + world.getWorld().getKey() + " run tp " + x2 + " " + (world.getWorld().getHighestBlockYAt(x2, z2, HeightMap.MOTION_BLOCKING) + 1) + " " + z2)));
                    sender.sendMessage(message);
                });
            } else {
                List<Pair> info = list.entrySet().stream().filter(e2 -> names.contains(e2.getKey())).map(e2 -> Pair.of((Object)((MinecraftKey)e2.getKey()), (Object)((Integer)((MutablePair)e2.getValue()).left))).sorted((a2, b2) -> !((Integer)a2.getRight()).equals(b2.getRight()) ? (Integer)b2.getRight() - (Integer)a2.getRight() : ((MinecraftKey)a2.getKey()).toString().compareTo(((MinecraftKey)b2.getKey()).toString())).toList();
                if (info.isEmpty()) {
                    sender.sendMessage((Component)Component.text((String)"No entities found.", (TextColor)NamedTextColor.RED));
                    return;
                }
                int count = info.stream().mapToInt(Pair::getRight).sum();
                int nonTickingCount = nonEntityTicking.values().stream().mapToInt(Integer::intValue).sum();
                sender.sendMessage("Total Ticking: " + (count - nonTickingCount) + ", Total Non-Ticking: " + nonTickingCount);
                info.forEach(e2 -> {
                    int nonTicking = nonEntityTicking.getOrDefault(e2.getKey(), 0);
                    sender.sendMessage("  " + ((Integer)e2.getValue() - nonTicking) + " (" + nonTicking + ") : " + e2.getKey());
                });
                sender.sendMessage("* First number is ticking entities, second number is non-ticking entities");
            }
        }
    }
}

